/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.recognition.nr;

import com.hankcs.hanlp.corpus.tag.Nature;
import com.hankcs.hanlp.dictionary.BaseSearcher;
import com.hankcs.hanlp.dictionary.CoreDictionary;
import com.hankcs.hanlp.dictionary.nr.JapanesePersonDictionary;
import com.hankcs.hanlp.dictionary.nr.NRConstant;
import com.hankcs.hanlp.seg.common.Vertex;
import com.hankcs.hanlp.seg.common.WordNet;
import java.util.List;
import java.util.Map;

public class JapanesePersonRecognition {
    public static void Recognition(List<Vertex> segResult, WordNet wordNetOptimum, WordNet wordNetAll) {
        Map.Entry entry;
        StringBuilder sbName = new StringBuilder();
        int appendTimes = 0;
        char[] charArray = wordNetAll.charArray;
        BaseSearcher searcher = JapanesePersonDictionary.getSearcher(charArray);
        int activeLine = 1;
        int preOffset = 0;
        while ((entry = searcher.next()) != null) {
            Character label = (Character)entry.getValue();
            String key = entry.getKey();
            int offset = searcher.getOffset();
            if (preOffset != offset) {
                if (appendTimes > 1 && sbName.length() > 2) {
                    JapanesePersonRecognition.insertName(sbName.toString(), activeLine, wordNetOptimum, wordNetAll);
                }
                sbName.setLength(0);
                appendTimes = 0;
            }
            if (appendTimes == 0) {
                if (label.charValue() == 'x') {
                    sbName.append(key);
                    ++appendTimes;
                    activeLine = offset + 1;
                }
            } else if (label.charValue() == 'm') {
                sbName.append(key);
                ++appendTimes;
            } else {
                if (appendTimes > 1 && sbName.length() > 2) {
                    JapanesePersonRecognition.insertName(sbName.toString(), activeLine, wordNetOptimum, wordNetAll);
                }
                sbName.setLength(0);
                appendTimes = 0;
            }
            preOffset = offset + key.length();
        }
        if (sbName.length() > 0 && appendTimes > 1) {
            JapanesePersonRecognition.insertName(sbName.toString(), activeLine, wordNetOptimum, wordNetAll);
        }
    }

    public static boolean isBadCase(String name) {
        Character label = JapanesePersonDictionary.get(name);
        if (label == null) {
            return false;
        }
        return label.equals(Character.valueOf('A'));
    }

    private static void insertName(String name, int activeLine, WordNet wordNetOptimum, WordNet wordNetAll) {
        if (JapanesePersonRecognition.isBadCase(name)) {
            return;
        }
        wordNetOptimum.insert(activeLine, new Vertex("\u672a##\u4eba", name, new CoreDictionary.Attribute(Nature.nrj), NRConstant.WORD_ID), wordNetAll);
    }
}

