/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.summary;

import com.hankcs.hanlp.dictionary.stopword.CoreStopWordDictionary;
import com.hankcs.hanlp.seg.common.Term;
import com.hankcs.hanlp.summary.BM25;
import com.hankcs.hanlp.tokenizer.StandardTokenizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;

public class TextRankSentence {
    static final double d = 0.85;
    static final int max_iter = 200;
    static final double min_diff = 0.001;
    int D;
    List<List<String>> docs;
    TreeMap<Double, Integer> top;
    double[][] weight;
    double[] weight_sum;
    double[] vertex;
    BM25 bm25;

    public TextRankSentence(List<List<String>> docs) {
        this.docs = docs;
        this.bm25 = new BM25(docs);
        this.D = docs.size();
        this.weight = new double[this.D][this.D];
        this.weight_sum = new double[this.D];
        this.vertex = new double[this.D];
        this.top = new TreeMap(Collections.reverseOrder());
        this.solve();
    }

    private void solve() {
        int cnt = 0;
        for (List<String> sentence : this.docs) {
            double[] scores = this.bm25.simAll(sentence);
            this.weight[cnt] = scores;
            this.weight_sum[cnt] = TextRankSentence.sum(scores) - scores[cnt];
            this.vertex[cnt] = 1.0;
            ++cnt;
        }
        for (int _ = 0; _ < 200; ++_) {
            double[] m = new double[this.D];
            double max_diff = 0.0;
            for (int i = 0; i < this.D; ++i) {
                m[i] = 0.15000000000000002;
                for (int j = 0; j < this.D; ++j) {
                    if (j == i || this.weight_sum[j] == 0.0) continue;
                    int n = i;
                    m[n] = m[n] + 0.85 * this.weight[j][i] / this.weight_sum[j] * this.vertex[j];
                }
                double diff = Math.abs(m[i] - this.vertex[i]);
                if (!(diff > max_diff)) continue;
                max_diff = diff;
            }
            this.vertex = m;
            if (max_diff <= 0.001) break;
        }
        for (int i = 0; i < this.D; ++i) {
            this.top.put(this.vertex[i], i);
        }
    }

    public int[] getTopSentence(int size) {
        Collection<Integer> values = this.top.values();
        size = Math.min(size, values.size());
        int[] indexArray = new int[size];
        Iterator<Integer> it = values.iterator();
        for (int i = 0; i < size; ++i) {
            indexArray[i] = it.next();
        }
        return indexArray;
    }

    private static double sum(double[] array) {
        double total = 0.0;
        for (double v : array) {
            total += v;
        }
        return total;
    }

    public static void main(String[] args) {
        String document = "\u7b97\u6cd5\u53ef\u5927\u81f4\u5206\u4e3a\u57fa\u672c\u7b97\u6cd5\u3001\u6570\u636e\u7ed3\u6784\u7684\u7b97\u6cd5\u3001\u6570\u8bba\u7b97\u6cd5\u3001\u8ba1\u7b97\u51e0\u4f55\u7684\u7b97\u6cd5\u3001\u56fe\u7684\u7b97\u6cd5\u3001\u52a8\u6001\u89c4\u5212\u4ee5\u53ca\u6570\u503c\u5206\u6790\u3001\u52a0\u5bc6\u7b97\u6cd5\u3001\u6392\u5e8f\u7b97\u6cd5\u3001\u68c0\u7d22\u7b97\u6cd5\u3001\u968f\u673a\u5316\u7b97\u6cd5\u3001\u5e76\u884c\u7b97\u6cd5\u3001\u5384\u7c73\u53d8\u5f62\u6a21\u578b\u3001\u968f\u673a\u68ee\u6797\u7b97\u6cd5\u3002\n\u7b97\u6cd5\u53ef\u4ee5\u5bbd\u6cdb\u7684\u5206\u4e3a\u4e09\u7c7b\uff0c\n\u4e00\uff0c\u6709\u9650\u7684\u786e\u5b9a\u6027\u7b97\u6cd5\uff0c\u8fd9\u7c7b\u7b97\u6cd5\u5728\u6709\u9650\u7684\u4e00\u6bb5\u65f6\u95f4\u5185\u7ec8\u6b62\u3002\u4ed6\u4eec\u53ef\u80fd\u8981\u82b1\u5f88\u957f\u65f6\u95f4\u6765\u6267\u884c\u6307\u5b9a\u7684\u4efb\u52a1\uff0c\u4f46\u4ecd\u5c06\u5728\u4e00\u5b9a\u7684\u65f6\u95f4\u5185\u7ec8\u6b62\u3002\u8fd9\u7c7b\u7b97\u6cd5\u5f97\u51fa\u7684\u7ed3\u679c\u5e38\u53d6\u51b3\u4e8e\u8f93\u5165\u503c\u3002\n\u4e8c\uff0c\u6709\u9650\u7684\u975e\u786e\u5b9a\u7b97\u6cd5\uff0c\u8fd9\u7c7b\u7b97\u6cd5\u5728\u6709\u9650\u7684\u65f6\u95f4\u5185\u7ec8\u6b62\u3002\u7136\u800c\uff0c\u5bf9\u4e8e\u4e00\u4e2a\uff08\u6216\u4e00\u4e9b\uff09\u7ed9\u5b9a\u7684\u6570\u503c\uff0c\u7b97\u6cd5\u7684\u7ed3\u679c\u5e76\u4e0d\u662f\u552f\u4e00\u7684\u6216\u786e\u5b9a\u7684\u3002\n\u4e09\uff0c\u65e0\u9650\u7684\u7b97\u6cd5\uff0c\u662f\u90a3\u4e9b\u7531\u4e8e\u6ca1\u6709\u5b9a\u4e49\u7ec8\u6b62\u5b9a\u4e49\u6761\u4ef6\uff0c\u6216\u5b9a\u4e49\u7684\u6761\u4ef6\u65e0\u6cd5\u7531\u8f93\u5165\u7684\u6570\u636e\u6ee1\u8db3\u800c\u4e0d\u7ec8\u6b62\u8fd0\u884c\u7684\u7b97\u6cd5\u3002\u901a\u5e38\uff0c\u65e0\u9650\u7b97\u6cd5\u7684\u4ea7\u751f\u662f\u7531\u4e8e\u672a\u80fd\u786e\u5b9a\u7684\u5b9a\u4e49\u7ec8\u6b62\u6761\u4ef6\u3002";
        System.out.println(TextRankSentence.getTopSentenceList(document, 3));
    }

    static List<String> spiltSentence(String document) {
        ArrayList<String> sentences = new ArrayList<String>();
        for (String line : document.split("[\r\n]")) {
            if ((line = line.trim()).length() == 0) continue;
            for (String sent : line.split("[\uff0c,\u3002:\uff1a\u201c\u201d\uff1f?\uff01!\uff1b;]")) {
                if ((sent = sent.trim()).length() == 0) continue;
                sentences.add(sent);
            }
        }
        return sentences;
    }

    public static List<String> getTopSentenceList(String document, int size) {
        List<String> sentenceList = TextRankSentence.spiltSentence(document);
        ArrayList<List<String>> docs = new ArrayList<List<String>>();
        for (String sentence : sentenceList) {
            List<Term> termList = StandardTokenizer.segment(sentence.toCharArray());
            LinkedList<String> wordList = new LinkedList<String>();
            for (Term term : termList) {
                if (!CoreStopWordDictionary.shouldInclude(term)) continue;
                wordList.add(term.word);
            }
            docs.add(wordList);
        }
        TextRankSentence textRank = new TextRankSentence(docs);
        int[] topSentence = textRank.getTopSentence(size);
        LinkedList<String> resultList = new LinkedList<String>();
        for (int i : topSentence) {
            resultList.add(sentenceList.get(i));
        }
        return resultList;
    }
}

