/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.summary;

import com.hankcs.hanlp.seg.common.Term;
import com.hankcs.hanlp.summary.KeywordExtractor;
import com.hankcs.hanlp.tokenizer.StandardTokenizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class TextRankKeyword
extends KeywordExtractor {
    int nKeyword = 10;
    static final float d = 0.85f;
    static final int max_iter = 200;
    static final float min_diff = 0.001f;

    public static List<String> getKeywordList(String document, int size) {
        TextRankKeyword textRankKeyword = new TextRankKeyword();
        textRankKeyword.nKeyword = size;
        return textRankKeyword.getKeyword(document);
    }

    public List<String> getKeyword(String content) {
        List<Term> termList = StandardTokenizer.segment(content);
        ArrayList<String> wordList = new ArrayList<String>();
        for (Term t : termList) {
            if (!this.shouldInclude(t)) continue;
            wordList.add(t.word);
        }
        TreeMap words = new TreeMap();
        LinkedList<String> que = new LinkedList<String>();
        for (String w : wordList) {
            if (!words.containsKey(w)) {
                words.put(w, new TreeSet());
            }
            que.offer(w);
            if (que.size() > 5) {
                que.poll();
            }
            for (String w1 : que) {
                for (String w2 : que) {
                    if (w1.equals(w2)) continue;
                    ((Set)words.get(w1)).add(w2);
                    ((Set)words.get(w2)).add(w1);
                }
            }
        }
        HashMap score = new HashMap();
        for (int i = 0; i < 200; ++i) {
            HashMap<String, Float> m = new HashMap<String, Float>();
            float max_diff = 0.0f;
            for (Map.Entry entry : words.entrySet()) {
                String key = (String)entry.getKey();
                Set value = (Set)entry.getValue();
                m.put(key, Float.valueOf(0.14999998f));
                for (String element : value) {
                    int size = ((Set)words.get(element)).size();
                    if (key.equals(element) || size == 0) continue;
                    m.put(key, Float.valueOf(((Float)m.get(key)).floatValue() + 0.85f / (float)size * (score.get(element) == null ? 0.0f : ((Float)score.get(element)).floatValue())));
                }
                max_diff = Math.max(max_diff, Math.abs(((Float)m.get(key)).floatValue() - (score.get(key) == null ? 0.0f : ((Float)score.get(key)).floatValue())));
            }
            score = m;
            if (max_diff <= 0.001f) break;
        }
        ArrayList entryList = new ArrayList(score.entrySet());
        Collections.sort(entryList, new Comparator<Map.Entry<String, Float>>(){

            @Override
            public int compare(Map.Entry<String, Float> o1, Map.Entry<String, Float> o2) {
                return o2.getValue().compareTo(o1.getValue());
            }
        });
        int limit = Math.min(this.nKeyword, entryList.size());
        ArrayList<String> result = new ArrayList<String>(limit);
        for (int i = 0; i < limit; ++i) {
            result.add((String)((Map.Entry)entryList.get(i)).getKey());
        }
        return result;
    }
}

