/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.seg.Other;

import com.hankcs.hanlp.collection.AhoCorasick.AhoCorasickDoubleArrayTrie;
import com.hankcs.hanlp.corpus.tag.Nature;
import com.hankcs.hanlp.dictionary.CoreDictionary;
import com.hankcs.hanlp.seg.DictionaryBasedSegment;
import com.hankcs.hanlp.seg.NShort.Path.AtomNode;
import com.hankcs.hanlp.seg.Segment;
import com.hankcs.hanlp.seg.common.Term;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class AhoCorasickDoubleArrayTrieSegment
extends DictionaryBasedSegment {
    AhoCorasickDoubleArrayTrie<CoreDictionary.Attribute> trie;

    @Override
    protected List<Term> segSentence(char[] sentence) {
        int i;
        if (this.trie == null) {
            System.err.println("\u8fd8\u672a\u4f20\u5165AhoCorasickDoubleArrayTrie");
            return Collections.emptyList();
        }
        char[] charArray = sentence;
        final int[] wordNet = new int[charArray.length];
        Arrays.fill(wordNet, 1);
        final Nature[] natureArray = this.config.speechTagging ? new Nature[charArray.length] : null;
        this.trie.parseText(charArray, new AhoCorasickDoubleArrayTrie.IHit<CoreDictionary.Attribute>(){

            @Override
            public void hit(int begin, int end, CoreDictionary.Attribute value) {
                int length = end - begin;
                if (length > wordNet[begin]) {
                    wordNet[begin] = length;
                    if (((AhoCorasickDoubleArrayTrieSegment)AhoCorasickDoubleArrayTrieSegment.this).config.speechTagging) {
                        natureArray[begin] = value.nature[0];
                    }
                }
            }
        });
        LinkedList<Term> termList = new LinkedList<Term>();
        if (this.config.speechTagging) {
            i = 0;
            while (i < natureArray.length) {
                if (natureArray[i] == null) {
                    int j;
                    for (j = i + 1; j < natureArray.length && natureArray[j] == null; ++j) {
                    }
                    List<AtomNode> atomNodeList = AhoCorasickDoubleArrayTrieSegment.quickAtomSegment(charArray, i, j);
                    for (AtomNode atomNode : atomNodeList) {
                        if (atomNode.sWord.length() < wordNet[i]) continue;
                        wordNet[i] = atomNode.sWord.length();
                        natureArray[i] = atomNode.getNature();
                        i += wordNet[i];
                    }
                    i = j;
                    continue;
                }
                ++i;
            }
        }
        for (i = 0; i < wordNet.length; i += wordNet[i]) {
            Term term = new Term(new String(charArray, i, wordNet[i]), this.config.speechTagging ? (natureArray[i] == null ? Nature.nz : natureArray[i]) : null);
            term.offset = i;
            termList.add(term);
        }
        return termList;
    }

    public AhoCorasickDoubleArrayTrieSegment() {
        this.config.useCustomDictionary = false;
    }

    @Override
    public Segment enableCustomDictionary(boolean enable) {
        throw new UnsupportedOperationException("AhoCorasickDoubleArrayTrieSegment\u6682\u65f6\u4e0d\u652f\u6301\u7528\u6237\u8bcd\u5178\u3002");
    }

    public AhoCorasickDoubleArrayTrie<CoreDictionary.Attribute> getTrie() {
        return this.trie;
    }

    public void setTrie(AhoCorasickDoubleArrayTrie<CoreDictionary.Attribute> trie) {
        this.trie = trie;
    }
}

