/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.recognition.nt;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.algoritm.Viterbi;
import com.hankcs.hanlp.corpus.dictionary.item.EnumItem;
import com.hankcs.hanlp.corpus.tag.NT;
import com.hankcs.hanlp.corpus.tag.Nature;
import com.hankcs.hanlp.dictionary.nt.OrganizationDictionary;
import com.hankcs.hanlp.seg.common.Vertex;
import com.hankcs.hanlp.seg.common.WordNet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class OrganizationRecognition {
    public static boolean Recognition(List<Vertex> pWordSegResult, WordNet wordNetOptimum, WordNet wordNetAll) {
        List<EnumItem<NT>> roleTagList = OrganizationRecognition.roleTag(pWordSegResult, wordNetAll);
        if (HanLP.Config.DEBUG) {
            StringBuilder sbLog = new StringBuilder();
            Iterator<Vertex> iterator = pWordSegResult.iterator();
            for (EnumItem<NT> NTEnumItem : roleTagList) {
                sbLog.append('[');
                sbLog.append(iterator.next().realWord);
                sbLog.append(' ');
                sbLog.append(NTEnumItem);
                sbLog.append(']');
            }
            System.out.printf("\u673a\u6784\u540d\u89d2\u8272\u89c2\u5bdf\uff1a%s\n", sbLog.toString());
        }
        List<NT> NTList = OrganizationRecognition.viterbiExCompute(roleTagList);
        if (HanLP.Config.DEBUG) {
            StringBuilder sbLog = new StringBuilder();
            Iterator<Vertex> iterator = pWordSegResult.iterator();
            sbLog.append('[');
            for (NT NT2 : NTList) {
                sbLog.append(iterator.next().realWord);
                sbLog.append('/');
                sbLog.append((Object)NT2);
                sbLog.append(" ,");
            }
            if (sbLog.length() > 1) {
                sbLog.delete(sbLog.length() - 2, sbLog.length());
            }
            sbLog.append(']');
            System.out.printf("\u673a\u6784\u540d\u89d2\u8272\u6807\u6ce8\uff1a%s\n", sbLog.toString());
        }
        OrganizationDictionary.parsePattern(NTList, pWordSegResult, wordNetOptimum, wordNetAll);
        return true;
    }

    public static List<EnumItem<NT>> roleTag(List<Vertex> vertexList, WordNet wordNetAll) {
        LinkedList<EnumItem<NT>> tagList = new LinkedList<EnumItem<NT>>();
        ListIterator<Vertex> listIterator = vertexList.listIterator();
        block4: while (listIterator.hasNext()) {
            EnumItem<NT> NTEnumItem;
            Vertex vertex = listIterator.next();
            Nature nature = vertex.getNature();
            if (nature != null) {
                switch (nature) {
                    case nz: {
                        if (vertex.getAttribute().totalFrequency > 1000) break;
                        tagList.add(new EnumItem<NT>(NT.F, 1000));
                        continue block4;
                    }
                    case ni: 
                    case nic: 
                    case nis: 
                    case nit: {
                        EnumItem<NT> ntEnumItem = new EnumItem<NT>(NT.K, 1000);
                        ntEnumItem.addLabel(NT.D, 1000);
                        tagList.add(ntEnumItem);
                        continue block4;
                    }
                }
            }
            if ((NTEnumItem = (EnumItem<NT>)OrganizationDictionary.dictionary.get(vertex.word)) == null) {
                NTEnumItem = new EnumItem<NT>(NT.Z, OrganizationDictionary.transformMatrixDictionary.getTotalFrequency(NT.Z));
            }
            tagList.add(NTEnumItem);
        }
        return tagList;
    }

    public static List<NT> viterbiExCompute(List<EnumItem<NT>> roleTagList) {
        return Viterbi.computeEnum(roleTagList, OrganizationDictionary.transformMatrixDictionary);
    }
}

