/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.collection.AhoCorasick.AhoCorasickDoubleArrayTrie;
import com.hankcs.hanlp.collection.trie.DoubleArrayTrie;
import com.hankcs.hanlp.collection.trie.bintrie.BinTrie;
import com.hankcs.hanlp.corpus.io.ByteArray;
import com.hankcs.hanlp.corpus.tag.Nature;
import com.hankcs.hanlp.dictionary.BaseSearcher;
import com.hankcs.hanlp.dictionary.CoreDictionary;
import com.hankcs.hanlp.utility.Predefine;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;

public class CustomDictionary {
    static BinTrie<CoreDictionary.Attribute> trie;
    public static DoubleArrayTrie<CoreDictionary.Attribute> dat;
    public static final String[] path;

    private static boolean loadMainDictionary(String mainPath) {
        Predefine.logger.info("\u81ea\u5b9a\u4e49\u8bcd\u5178\u5f00\u59cb\u52a0\u8f7d:" + mainPath);
        if (CustomDictionary.loadDat(mainPath)) {
            return true;
        }
        TreeMap<String, CoreDictionary.Attribute> map = new TreeMap<String, CoreDictionary.Attribute>();
        try {
            for (String p : path) {
                Nature defaultNature = Nature.n;
                int cut = p.indexOf(32);
                if (cut > 0) {
                    String nature = p.substring(cut + 1);
                    p = p.substring(0, cut);
                    try {
                        defaultNature = Nature.valueOf(nature);
                    }
                    catch (Exception e) {
                        Predefine.logger.severe("\u914d\u7f6e\u6587\u4ef6\u3010" + p + "\u3011\u5199\u9519\u4e86\uff01" + e);
                        continue;
                    }
                }
                Predefine.logger.info("\u52a0\u8f7d\u81ea\u5b9a\u4e49\u8bcd\u5178" + p + "\u4e2d\u2026\u2026");
                boolean success = CustomDictionary.load(p, defaultNature, map);
                if (success) continue;
                Predefine.logger.warning("\u5931\u8d25\uff1a" + p);
            }
            Predefine.logger.info("\u6b63\u5728\u6784\u5efaAhoCorasickDoubleArrayTrie\u2026\u2026");
            dat.build(map);
            Predefine.logger.info("\u6b63\u5728\u7f13\u5b58\u8bcd\u5178\u4e3adat\u6587\u4ef6\u2026\u2026");
            LinkedList attributeList = new LinkedList();
            for (Map.Entry entry : map.entrySet()) {
                attributeList.add(entry.getValue());
            }
            DataOutputStream out = new DataOutputStream(new FileOutputStream(mainPath + ".bin"));
            out.writeInt(attributeList.size());
            for (CoreDictionary.Attribute attribute : attributeList) {
                out.writeInt(attribute.totalFrequency);
                out.writeInt(attribute.nature.length);
                for (int i = 0; i < attribute.nature.length; ++i) {
                    out.writeInt(attribute.nature[i].ordinal());
                    out.writeInt(attribute.frequency[i]);
                }
            }
            dat.save(out);
            out.close();
        }
        catch (FileNotFoundException e) {
            Predefine.logger.severe("\u81ea\u5b9a\u4e49\u8bcd\u5178" + mainPath + "\u4e0d\u5b58\u5728\uff01" + e);
            return false;
        }
        catch (IOException e) {
            Predefine.logger.severe("\u81ea\u5b9a\u4e49\u8bcd\u5178" + mainPath + "\u8bfb\u53d6\u9519\u8bef\uff01" + e);
            return false;
        }
        catch (Exception e) {
            Predefine.logger.warning("\u81ea\u5b9a\u4e49\u8bcd\u5178" + mainPath + "\u7f13\u5b58\u5931\u8d25\uff01" + e);
        }
        return true;
    }

    public static boolean load(String path, Nature defaultNature, TreeMap<String, CoreDictionary.Attribute> map) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), "UTF-8"));
            while ((line = br.readLine()) != null) {
                CoreDictionary.Attribute attribute;
                String[] param = line.split("\\s");
                if (param[0].length() == 0 || CoreDictionary.contains(param[0]) || map.containsKey(param[0])) continue;
                int natureCount = (param.length - 1) / 2;
                if (natureCount == 0) {
                    attribute = new CoreDictionary.Attribute(defaultNature);
                } else {
                    attribute = new CoreDictionary.Attribute(natureCount);
                    for (int i = 0; i < natureCount; ++i) {
                        attribute.nature[i] = Enum.valueOf(Nature.class, param[1 + 2 * i]);
                        attribute.frequency[i] = Integer.parseInt(param[2 + 2 * i]);
                        attribute.totalFrequency += attribute.frequency[i];
                    }
                }
                map.put(param[0], attribute);
            }
            br.close();
        }
        catch (Exception e) {
            if (!path.startsWith(".")) {
                Predefine.logger.severe("\u81ea\u5b9a\u4e49\u8bcd\u5178" + path + "\u8bfb\u53d6\u9519\u8bef\uff01" + e);
            }
            return false;
        }
        return true;
    }

    public static boolean add(String word, String natureWithFrequency) {
        if (CustomDictionary.contains(word)) {
            return false;
        }
        return CustomDictionary.insert(word, natureWithFrequency);
    }

    public static boolean add(String word) {
        if (CustomDictionary.contains(word)) {
            return false;
        }
        return CustomDictionary.insert(word, null);
    }

    public static boolean insert(String word, String natureWithFrequency) {
        CoreDictionary.Attribute att;
        if (word == null) {
            return false;
        }
        CoreDictionary.Attribute attribute = att = natureWithFrequency == null ? new CoreDictionary.Attribute(Nature.nz, 1) : CoreDictionary.Attribute.create(natureWithFrequency);
        if (att == null) {
            return false;
        }
        if (dat != null && dat.set(word, att)) {
            return true;
        }
        if (trie == null) {
            trie = new BinTrie();
        }
        trie.put(word, att);
        return true;
    }

    public static boolean insert(String word) {
        return CustomDictionary.insert(word, null);
    }

    static boolean loadDat(String path) {
        try {
            ByteArray byteArray = ByteArray.createByteArray(path + ".bin");
            int size = byteArray.nextInt();
            CoreDictionary.Attribute[] attributes = new CoreDictionary.Attribute[size];
            Nature[] natureIndexArray = Nature.values();
            for (int i = 0; i < size; ++i) {
                int currentTotalFrequency = byteArray.nextInt();
                int length = byteArray.nextInt();
                attributes[i] = new CoreDictionary.Attribute(length);
                attributes[i].totalFrequency = currentTotalFrequency;
                for (int j = 0; j < length; ++j) {
                    attributes[i].nature[j] = natureIndexArray[byteArray.nextInt()];
                    attributes[i].frequency[j] = byteArray.nextInt();
                }
            }
            if (!dat.load(byteArray, (CoreDictionary.Attribute[])attributes)) {
                return false;
            }
        }
        catch (Exception e) {
            Predefine.logger.warning("\u8bfb\u53d6\u5931\u8d25\uff0c\u95ee\u9898\u53d1\u751f\u5728" + e);
            return false;
        }
        return true;
    }

    public static CoreDictionary.Attribute get(String key) {
        if (dat == null) {
            if (trie != null) {
                return trie.get(key);
            }
            return null;
        }
        return dat.get(key);
    }

    public static void remove(String key) {
        trie.remove(key);
    }

    public static LinkedList<Map.Entry<String, CoreDictionary.Attribute>> commonPrefixSearch(String key) {
        return trie.commonPrefixSearchWithValue(key);
    }

    public static LinkedList<Map.Entry<String, CoreDictionary.Attribute>> commonPrefixSearch(char[] chars, int begin) {
        return trie.commonPrefixSearchWithValue(chars, begin);
    }

    public static BaseSearcher getSearcher(String text) {
        return new Searcher(text);
    }

    public String toString() {
        return "CustomDictionary{trie=" + trie + '}';
    }

    public static boolean contains(String key) {
        if (dat != null && dat.exactMatchSearch(key) >= 0) {
            return true;
        }
        return trie != null && trie.containsKey(key);
    }

    public static BaseSearcher getSearcher(char[] charArray) {
        return new Searcher(charArray);
    }

    public static BinTrie<CoreDictionary.Attribute> getTrie() {
        return trie;
    }

    public static void parseText(char[] text, AhoCorasickDoubleArrayTrie.IHit<CoreDictionary.Attribute> processor) {
        Object searcher;
        if (trie != null) {
            Map.Entry entry;
            searcher = CustomDictionary.getSearcher(text);
            while ((entry = ((BaseSearcher)searcher).next()) != null) {
                int offset = ((BaseSearcher)searcher).getOffset();
                processor.hit(offset, offset + entry.getKey().length(), (CoreDictionary.Attribute)entry.getValue());
            }
        }
        if (dat == null) {
            return;
        }
        searcher = dat.getSearcher(text, 0);
        while (((DoubleArrayTrie.Searcher)searcher).next()) {
            processor.hit(((DoubleArrayTrie.Searcher)searcher).begin, ((DoubleArrayTrie.Searcher)searcher).begin + ((DoubleArrayTrie.Searcher)searcher).length, (CoreDictionary.Attribute)((DoubleArrayTrie.Searcher)searcher).value);
        }
    }

    static {
        dat = new DoubleArrayTrie();
        path = HanLP.Config.CustomDictionaryPath;
        long start = System.currentTimeMillis();
        if (!CustomDictionary.loadMainDictionary(path[0])) {
            Predefine.logger.warning("\u81ea\u5b9a\u4e49\u8bcd\u5178" + Arrays.toString(path) + "\u52a0\u8f7d\u5931\u8d25");
        } else {
            Predefine.logger.info("\u81ea\u5b9a\u4e49\u8bcd\u5178\u52a0\u8f7d\u6210\u529f:" + dat.size() + "\u4e2a\u8bcd\u6761\uff0c\u8017\u65f6" + (System.currentTimeMillis() - start) + "ms");
        }
    }

    static class Searcher
    extends BaseSearcher<CoreDictionary.Attribute> {
        int begin;
        private LinkedList<Map.Entry<String, CoreDictionary.Attribute>> entryList = new LinkedList();

        protected Searcher(char[] c) {
            super(c);
        }

        protected Searcher(String text) {
            super(text);
        }

        @Override
        public Map.Entry<String, CoreDictionary.Attribute> next() {
            while (this.entryList.size() == 0 && this.begin < this.c.length) {
                this.entryList = trie.commonPrefixSearchWithValue(this.c, this.begin);
                ++this.begin;
            }
            if (this.entryList.size() == 0 && this.begin < this.c.length) {
                this.entryList = trie.commonPrefixSearchWithValue(this.c, this.begin);
                ++this.begin;
            }
            if (this.entryList.size() == 0) {
                return null;
            }
            Map.Entry<String, CoreDictionary.Attribute> result = this.entryList.getFirst();
            this.entryList.removeFirst();
            this.offset = this.begin - 1;
            return result;
        }
    }
}

