/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.collection.dynamicarray;

import com.hankcs.hanlp.collection.dynamicarray.ChainItem;
import com.hankcs.hanlp.collection.dynamicarray.DynamicArray;

public class ColumnFirstDynamicArray<T>
extends DynamicArray<T> {
    public ChainItem<T> GetFirstElementOfCol(int nCol) {
        ChainItem pCur = this.pHead;
        while (pCur != null && pCur.col != nCol) {
            pCur = pCur.next;
        }
        return pCur;
    }

    public ChainItem<T> GetFirstElementOfCol(int nCol, ChainItem<T> startFrom) {
        ChainItem<T> pCur = startFrom;
        while (pCur != null && pCur.col != nCol) {
            pCur = pCur.next;
        }
        return pCur;
    }

    @Override
    public void SetElement(int nRow, int nCol, T content) {
        ChainItem pCur = this.pHead;
        ChainItem pPre = null;
        if (nRow > this.RowCount) {
            this.RowCount = nRow;
        }
        if (nCol > this.ColumnCount) {
            this.ColumnCount = nCol;
        }
        while (pCur != null && (pCur.col < nCol || pCur.col == nCol && pCur.row < nRow)) {
            pPre = pCur;
            pCur = pCur.next;
        }
        if (pCur != null && pCur.row == nRow && pCur.col == nCol) {
            pCur.Content = content;
        } else {
            ChainItem pNew = new ChainItem();
            pNew.col = nCol;
            pNew.row = nRow;
            pNew.Content = content;
            pNew.next = pCur;
            if (pPre == null) {
                this.pHead = pNew;
            } else {
                pPre.next = pNew;
            }
        }
    }
}

