/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.collection.trie.ITrie;
import com.hankcs.hanlp.collection.trie.bintrie.BinTrie;
import com.hankcs.hanlp.model.crf.CRFModel;
import com.hankcs.hanlp.model.crf.FeatureFunction;
import com.hankcs.hanlp.model.crf.Table;
import com.hankcs.hanlp.utility.Predefine;
import java.util.LinkedList;

public final class CRFSegmentModel
extends CRFModel {
    public static CRFModel crfModel;
    private static final int idM;
    private static final int idE;
    private static final int idS;

    private CRFSegmentModel() {
    }

    private CRFSegmentModel(ITrie<FeatureFunction> featureFunctionTrie) {
        super(featureFunctionTrie);
    }

    @Override
    public void tag(Table table) {
        int size = table.size();
        if (size == 1) {
            table.setLast(0, "S");
            return;
        }
        double[][] net = new double[size][4];
        for (int i = 0; i < size; ++i) {
            LinkedList<double[]> scoreList = this.computeScoreList(table, i);
            for (int tag = 0; tag < 4; ++tag) {
                net[i][tag] = CRFSegmentModel.computeScore(scoreList, tag);
            }
        }
        net[0][CRFSegmentModel.idM] = -1000.0;
        net[0][CRFSegmentModel.idE] = -1000.0;
        int[][] from = new int[size][4];
        for (int i = 1; i < size; ++i) {
            for (int now = 0; now < 4; ++now) {
                double maxScore = -1.0E10;
                for (int pre = 0; pre < 4; ++pre) {
                    double score = net[i - 1][pre] + this.matrix[pre][now] + net[i][now];
                    if (!(score > maxScore)) continue;
                    maxScore = score;
                    from[i][now] = pre;
                }
                net[i][now] = maxScore;
            }
        }
        int maxTag = net[size - 1][idS] > net[size - 1][idE] ? idS : idE;
        table.setLast(size - 1, this.id2tag[maxTag]);
        maxTag = from[size - 1][maxTag];
        for (int i = size - 2; i > 0; --i) {
            table.setLast(i, this.id2tag[maxTag]);
            maxTag = from[i][maxTag];
        }
        table.setLast(0, this.id2tag[maxTag]);
    }

    static {
        Predefine.logger.info("CRF\u5206\u8bcd\u6a21\u578b\u6b63\u5728\u52a0\u8f7d " + HanLP.Config.CRFSegmentModelPath);
        long start = System.currentTimeMillis();
        crfModel = CRFModel.loadTxt(HanLP.Config.CRFSegmentModelPath, new CRFSegmentModel(new BinTrie<FeatureFunction>()));
        if (crfModel == null) {
            String error = "CRF\u5206\u8bcd\u6a21\u578b\u52a0\u8f7d " + HanLP.Config.CRFSegmentModelPath + " \u5931\u8d25\uff0c\u8017\u65f6 " + (System.currentTimeMillis() - start) + " ms";
            Predefine.logger.severe(error);
            throw new IllegalArgumentException(error);
        }
        Predefine.logger.info("CRF\u5206\u8bcd\u6a21\u578b\u52a0\u8f7d " + HanLP.Config.CRFSegmentModelPath + " \u6210\u529f\uff0c\u8017\u65f6 " + (System.currentTimeMillis() - start) + " ms");
        idM = crfModel.getTagId("M");
        idE = crfModel.getTagId("E");
        idS = crfModel.getTagId("S");
    }
}

