/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.seg.HMM;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.corpus.io.ByteArray;
import com.hankcs.hanlp.model.trigram.CharacterBasedGenerativeModel;
import com.hankcs.hanlp.seg.CharacterBasedGenerativeModelSegment;
import com.hankcs.hanlp.seg.common.Term;
import com.hankcs.hanlp.utility.Predefine;
import com.hankcs.hanlp.utility.TextUtility;
import java.util.LinkedList;
import java.util.List;

public class HMMSegment
extends CharacterBasedGenerativeModelSegment {
    static CharacterBasedGenerativeModel model = new CharacterBasedGenerativeModel();

    @Override
    protected List<Term> segSentence(char[] sentence) {
        char[] tag = model.tag(sentence);
        LinkedList<Term> termList = new LinkedList<Term>();
        int offset = 0;
        for (int i = 0; i < tag.length; ++i) {
            switch (tag[i]) {
                case 'b': {
                    int begin = offset;
                    while (tag[i] != 'e') {
                        ++offset;
                        if (++i != tag.length) continue;
                    }
                    if (i == tag.length) {
                        termList.add(new Term(new String(sentence, begin, offset - begin), null));
                        break;
                    }
                    termList.add(new Term(new String(sentence, begin, offset - begin + 1), null));
                    break;
                }
                default: {
                    termList.add(new Term(new String(sentence, offset, 1), null));
                }
            }
            ++offset;
        }
        return termList;
    }

    static {
        long start = System.currentTimeMillis();
        Predefine.logger.info("\u5f00\u59cb\u4ece[ " + HanLP.Config.HMMSegmentModelPath + " ]\u52a0\u8f7d2\u9636HMM\u6a21\u578b");
        try {
            ByteArray byteArray = ByteArray.createByteArray(HanLP.Config.HMMSegmentModelPath);
            if (byteArray == null) {
                Predefine.logger.severe("HMM\u5206\u8bcd\u6a21\u578b[ " + HanLP.Config.HMMSegmentModelPath + " ]\u4e0d\u5b58\u5728");
                System.exit(-1);
            }
            model.load(byteArray);
        }
        catch (Exception e) {
            Predefine.logger.severe("\u53d1\u751f\u4e86\u5f02\u5e38\uff1a" + TextUtility.exceptionToString(e));
            System.exit(-1);
        }
        Predefine.logger.info("\u52a0\u8f7d\u6210\u529f\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start) + " ms");
    }
}

