/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.corpus.io;

import com.hankcs.hanlp.corpus.io.ByteArray;
import com.hankcs.hanlp.utility.Predefine;
import com.hankcs.hanlp.utility.TextUtility;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class ByteArrayStream
extends ByteArray {
    private int bufferSize;
    private FileChannel fileChannel;

    public ByteArrayStream(byte[] bytes, int bufferSize, FileChannel fileChannel) {
        super(bytes);
        this.bufferSize = bufferSize;
        this.fileChannel = fileChannel;
    }

    public static ByteArrayStream createByteArrayStream(String path) {
        try {
            FileInputStream fileInputStream = new FileInputStream(path);
            FileChannel channel = fileInputStream.getChannel();
            long size = channel.size();
            int bufferSize = (int)Math.min(0x100000L, size);
            ByteBuffer byteBuffer = ByteBuffer.allocate(bufferSize);
            if ((long)channel.read(byteBuffer) == size) {
                channel.close();
                channel = null;
            }
            byteBuffer.flip();
            byte[] bytes = byteBuffer.array();
            return new ByteArrayStream(bytes, bufferSize, channel);
        }
        catch (Exception e) {
            Predefine.logger.warning(TextUtility.exceptionToString(e));
            return null;
        }
    }

    @Override
    public int nextInt() {
        this.ensureAvailableBytes(4);
        return super.nextInt();
    }

    @Override
    public char nextChar() {
        this.ensureAvailableBytes(2);
        return super.nextChar();
    }

    @Override
    public double nextDouble() {
        this.ensureAvailableBytes(8);
        return super.nextDouble();
    }

    @Override
    public byte nextByte() {
        this.ensureAvailableBytes(1);
        return super.nextByte();
    }

    @Override
    public float nextFloat() {
        this.ensureAvailableBytes(4);
        return super.nextFloat();
    }

    @Override
    public boolean hasMore() {
        return this.offset < this.bufferSize || this.fileChannel != null;
    }

    private void ensureAvailableBytes(int size) {
        if (this.offset + size > this.bufferSize) {
            try {
                int availableBytes = (int)(this.fileChannel.size() - this.fileChannel.position());
                ByteBuffer byteBuffer = ByteBuffer.allocate(Math.min(availableBytes, this.offset));
                int readBytes = this.fileChannel.read(byteBuffer);
                if (readBytes == availableBytes) {
                    this.fileChannel.close();
                    this.fileChannel = null;
                }
                assert (readBytes > 0) : "\u5df2\u5230\u8fbe\u6587\u4ef6\u5c3e\u90e8\uff01";
                byteBuffer.flip();
                byte[] bytes = byteBuffer.array();
                System.arraycopy(this.bytes, this.offset, this.bytes, this.offset - readBytes, this.bufferSize - this.offset);
                System.arraycopy(bytes, 0, this.bytes, this.bufferSize - readBytes, readBytes);
                this.offset -= readBytes;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

