/*
 * Decompiled with CFR 0.152.
 */
package com.hacknife.immersive;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.RequiresApi;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;

public class ImmersiveHelper {
    @RequiresApi(api=17)
    public static boolean hasNavigationBarShow(Activity activity) {
        WindowManager wm = activity.getWindowManager();
        Display display = wm.getDefaultDisplay();
        DisplayMetrics outMetrics = new DisplayMetrics();
        display.getRealMetrics(outMetrics);
        int heightPixels = outMetrics.heightPixels;
        int widthPixels = outMetrics.widthPixels;
        outMetrics = new DisplayMetrics();
        display.getMetrics(outMetrics);
        int heightPixels2 = outMetrics.heightPixels;
        int widthPixels2 = outMetrics.widthPixels;
        int w = widthPixels - widthPixels2;
        int h = heightPixels - heightPixels2;
        return w != 0 || h != 0 || ImmersiveHelper.getNavigationBarHeight((Context)activity) != 0;
    }

    public static DisplayMetrics getScreenPix(Activity activity) {
        DisplayMetrics displaysMetrics = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(displaysMetrics);
        return displaysMetrics;
    }

    private static int getSystemComponentDimen(Context context, String dimenName) {
        int statusHeight = 0;
        try {
            Class<?> clazz = Class.forName("com.android.internal.R$dimen");
            Object object = clazz.newInstance();
            String heightStr = clazz.getField(dimenName).get(object).toString();
            int height = Integer.parseInt(heightStr);
            statusHeight = context.getResources().getDimensionPixelSize(height);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return statusHeight;
    }

    public static int getNavigationBarHeight(Context context) {
        return ImmersiveHelper.getSystemComponentDimen(context, "navigation_bar_height");
    }

    public static int getStatusBarHeight(Context context) {
        return ImmersiveHelper.getSystemComponentDimen(context, "status_bar_height");
    }
}

