/*
 * Decompiled with CFR 0.152.
 */
package com.hacknife.immersive;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.support.annotation.LayoutRes;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.hacknife.immersive.ImmersiveHelper;
import com.hacknife.immersive.R;
import com.hacknife.immersive.StatusView;

public class Immersive {
    private static final String TAG = Immersive.class.getName();

    private static void compatible(Activity activity, boolean navigationEmbed) {
        if (Build.VERSION.SDK_INT >= 19 && Build.VERSION.SDK_INT < 21) {
            activity.getWindow().requestFeature(1);
            activity.getWindow().addFlags(0x4000000);
            activity.getWindow().addFlags(0x8000000);
            Log.i((String)TAG, (String)"compatible: system version < 21");
        }
        if (Build.VERSION.SDK_INT >= 21) {
            Log.i((String)TAG, (String)"compatible: system version >= 21");
            if (navigationEmbed) {
                activity.getWindow().addFlags(0x8000000);
            }
            activity.getWindow().getDecorView().setSystemUiVisibility(1280);
            activity.getWindow().setStatusBarColor(activity.getResources().getColor(R.color.immersive_translucent));
            activity.getWindow().setNavigationBarColor(activity.getResources().getColor(R.color.immersive_translucent));
        }
    }

    public static void setContentView(Activity activity, @LayoutRes int layoutRes, int statusRes, int navigationRes, boolean statusEmbed, boolean navigationEmbed) {
        Immersive.compatible(activity, navigationEmbed);
        activity.setContentView(R.layout.activity_immersive);
        FrameLayout immersive_status = (FrameLayout)activity.findViewById(R.id.immersive_status);
        FrameLayout immersive_content = (FrameLayout)activity.findViewById(R.id.immersive_content);
        FrameLayout immersive_navigation = (FrameLayout)activity.findViewById(R.id.immersive_navigation);
        if (!statusEmbed) {
            StatusView status = new StatusView((Context)activity);
            status.setBackgroundResource(statusRes);
            immersive_status.addView((View)status);
            immersive_content.addView(LayoutInflater.from((Context)activity).inflate(layoutRes, (ViewGroup)null));
            if (Build.VERSION.SDK_INT >= 21 && !navigationEmbed) {
                activity.getWindow().setNavigationBarColor(activity.getResources().getColor(navigationRes));
            }
            if (Build.VERSION.SDK_INT < 21 && Build.VERSION.SDK_INT >= 19 && !navigationEmbed && ImmersiveHelper.hasNavigationBarShow(activity)) {
                View navigationBar = new View((Context)activity);
                navigationBar.setId(R.id.navigation);
                ViewGroup.LayoutParams navigatioParams = new ViewGroup.LayoutParams(-1, ImmersiveHelper.getNavigationBarHeight((Context)activity));
                navigationBar.setLayoutParams(navigatioParams);
                navigationBar.setBackgroundResource(navigationRes);
                immersive_navigation.addView(navigationBar);
            }
        } else if (Build.VERSION.SDK_INT >= 19 && Build.VERSION.SDK_INT < 21 && !navigationEmbed && ImmersiveHelper.hasNavigationBarShow(activity)) {
            immersive_content.addView(LayoutInflater.from((Context)activity).inflate(layoutRes, (ViewGroup)null));
            View navigation = new View((Context)activity);
            navigation.setId(R.id.navigation);
            ViewGroup.LayoutParams navigation_layout = new ViewGroup.LayoutParams(-1, ImmersiveHelper.getNavigationBarHeight((Context)activity));
            navigation.setLayoutParams(navigation_layout);
            navigation.setBackgroundResource(navigationRes);
            immersive_navigation.addView(navigation);
        } else {
            if (Build.VERSION.SDK_INT >= 21 && !navigationEmbed) {
                activity.getWindow().setNavigationBarColor(activity.getResources().getColor(navigationRes));
            }
            immersive_content.addView(LayoutInflater.from((Context)activity).inflate(layoutRes, (ViewGroup)null));
        }
    }

    public static void setStatusBarColorRes(Activity activity, int colorRes) {
        View status = activity.findViewById(R.id.status);
        if (status != null) {
            status.setBackgroundResource(colorRes);
        }
    }

    public static void setNavigationBarColorRes(Activity activity, int colorRes) {
        View navigation = activity.findViewById(R.id.navigation);
        if (navigation != null) {
            navigation.setBackgroundResource(colorRes);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            activity.getWindow().setNavigationBarColor(activity.getResources().getColor(colorRes));
        }
    }

    public static void setStatusBarColor(Activity activity, int color2) {
        View status = activity.findViewById(R.id.status);
        if (status != null) {
            status.setBackgroundColor(color2);
        }
    }

    public static void setNavigationBarColor(Activity activity, int color2) {
        View navigation = activity.findViewById(R.id.navigation);
        if (navigation != null) {
            navigation.setBackgroundColor(color2);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            activity.getWindow().setNavigationBarColor(color2);
        }
    }

    public static boolean setStatusBarLightMode(Activity activity) {
        if (Build.VERSION.SDK_INT >= 23) {
            activity.getWindow().getDecorView().setSystemUiVisibility(activity.getWindow().getDecorView().getSystemUiVisibility() | 0x2000);
            return true;
        }
        return false;
    }
}

