/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.retirejs;

import com.h3xstream.retirejs.repo.JsLibraryResult;
import com.h3xstream.retirejs.vuln.TemplateBuilder;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.network.HttpMessage;

public class ZapIssueCreator {
    private static Logger logger = Logger.getLogger(ZapIssueCreator.class);
    private static final String TITLE = "The JavaScript file '%s' includes a vulnerable version of the library '%s'";
    private static String TEMPLATE_DESC = "/org/zaproxy/zap/extension/retirejs/description.txt";
    private static String TEMPLATE_OTHER_INFO = "/org/zaproxy/zap/extension/retirejs/other_info.txt";

    public static Alert convertBugToAlert(int pluginId, JsLibraryResult lib, HttpMessage message) {
        String filename = "unknown";
        try {
            filename = ZapIssueCreator.getFileRequested(message.getRequestHeader().getURI().getPathQuery());
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        String title = String.format(TITLE, filename, lib.getLibrary().getName());
        String description = TemplateBuilder.buildDescription((String)TEMPLATE_DESC, (String)lib.getLibrary().getName(), (String)lib.getDetectedVersion(), (List)lib.getVuln().getInfo(), (String)lib.getVuln().getAtOrAbove(), (String)lib.getVuln().getBelow());
        String otherInfo = TemplateBuilder.buildDescription((String)TEMPLATE_OTHER_INFO, (String)lib.getLibrary().getName(), (String)lib.getDetectedVersion(), (List)lib.getVuln().getInfo(), (String)lib.getVuln().getAtOrAbove(), (String)lib.getVuln().getBelow());
        Alert alert = new Alert(pluginId, ZapIssueCreator.mapToZapSeverity(lib.getVuln().getSeverity()), 1, title);
        alert.setDetail(description, message.getRequestHeader().getURI().toString(), "", "", otherInfo, "Update the JavaScript library", ZapIssueCreator.joinStrings(lib.getVuln().getInfo()), message);
        return alert;
    }

    private static int mapToZapSeverity(String severity) {
        String severityLower = severity.toLowerCase();
        if (severityLower.equals("high")) {
            return 3;
        }
        if (severityLower.equals("medium")) {
            return 2;
        }
        if (severityLower.equals("low")) {
            return 1;
        }
        if (severityLower.equals("info")) {
            return 0;
        }
        return 2;
    }

    private static String joinStrings(List<String> info) {
        StringBuilder buffer = new StringBuilder();
        for (String link : info) {
            buffer.append(link).append('\n');
        }
        return buffer.toString();
    }

    public static String getFileRequested(String path) {
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash < 0) {
            lastSlash = 0;
        }
        return path.substring(lastSlash + 1);
    }
}

