/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.retirejs;

import com.esotericsoftware.minlog.Log;
import com.h3xstream.retirejs.repo.JsLibraryResult;
import com.h3xstream.retirejs.repo.ScannerFacade;
import java.io.IOException;
import java.util.List;
import net.htmlparser.jericho.Source;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpResponseHeader;
import org.zaproxy.zap.extension.pscan.PassiveScanThread;
import org.zaproxy.zap.extension.pscan.PluginPassiveScanner;
import org.zaproxy.zap.extension.retirejs.ZapIssueCreator;

public class RetireJsScannerPlugin
extends PluginPassiveScanner {
    private PassiveScanThread parent = null;
    private static final int PLUGIN_ID = 322420463;
    private Logger logger = Logger.getLogger(RetireJsScannerPlugin.class);

    public RetireJsScannerPlugin() {
        Log.setLogger((Log.Logger)new Log.Logger(){

            public void log(int level, String category, String message, Throwable ex) {
                if (ex != null) {
                    RetireJsScannerPlugin.this.logger.error((Object)message, ex);
                } else {
                    RetireJsScannerPlugin.this.logger.info((Object)message);
                }
            }
        });
        Log.DEBUG();
    }

    public void scanHttpRequestSend(HttpMessage httpMessage, int id) {
    }

    public void scanHttpResponseReceive(HttpMessage httpMessage, int refId, Source source) {
        HttpResponseHeader h = httpMessage.getResponseHeader();
        URI uri = httpMessage.getRequestHeader().getURI();
        try {
            String pathQuery = uri.getPathQuery();
            if (h.isJavaScript() || pathQuery.endsWith(".js")) {
                this.scanJavaScriptFile(pathQuery, refId, httpMessage);
            }
        }
        catch (URIException e) {
            this.logger.error((Object)("Unable to scan the script '" + uri.toString() + "': " + e.getMessage()), (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error((Object)("Unable to scan the script '" + uri.toString() + "': " + e.getMessage()), (Throwable)e);
        }
    }

    private void scanJavaScriptFile(String scriptName, int refId, HttpMessage httpMessage) throws IOException {
        List librariesVuln = ScannerFacade.getInstance().scanScript(scriptName, httpMessage.getResponseBody().getBytes(), 0);
        for (JsLibraryResult libVuln : librariesVuln) {
            Alert newAlert = ZapIssueCreator.convertBugToAlert(322420463, libVuln, httpMessage);
            this.parent.raiseAlert(refId, newAlert);
        }
    }

    public void setParent(PassiveScanThread thread) {
        this.parent = thread;
    }

    public String getName() {
        return "Retire.js";
    }

    public int getPluginId() {
        return 322420463;
    }
}

