/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.retirejs;

import com.esotericsoftware.minlog.Log;
import com.h3xstream.retirejs.MavenDownloader;
import com.h3xstream.retirejs.repo.JsLibrary;
import com.h3xstream.retirejs.repo.JsLibraryResult;
import com.h3xstream.retirejs.repo.ScannerFacade;
import com.h3xstream.retirejs.repo.VulnerabilitiesRepository;
import com.h3xstream.retirejs.repo.VulnerabilitiesRepositoryLoader;
import com.h3xstream.retirejs.repo.dl.Downloader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class RetireJsScan
extends AbstractMojo {
    protected boolean breakOnFailure;
    protected String repoUrl;
    protected MavenProject project;
    protected WagonManager wagonManager;
    protected File webAppDirectory;
    private VulnerabilitiesRepository repo;

    private void initMiniLog() {
        Log.setLogger((Log.Logger)new Log.Logger(){

            public void log(int level, String category, String message, Throwable ex) {
                switch (level) {
                    case 1: 
                    case 2: 
                    case 3: {
                        RetireJsScan.this.getLog().debug((CharSequence)message);
                        break;
                    }
                    case 4: {
                        RetireJsScan.this.getLog().warn((CharSequence)message);
                        break;
                    }
                    case 5: {
                        RetireJsScan.this.getLog().error((CharSequence)message, ex);
                    }
                }
            }
        });
        Log.DEBUG();
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.initMiniLog();
        ArrayList<JsLibraryResult> completeResults = new ArrayList<JsLibraryResult>();
        if (this.repoUrl == null || this.repoUrl.length() == 0) {
            this.getLog().debug((CharSequence)"Using default URL: https://raw.githubusercontent.com/Retirejs/retire.js/master/repository/jsrepository.json");
            this.repoUrl = "https://raw.githubusercontent.com/Retirejs/retire.js/master/repository/jsrepository.json";
        }
        try {
            this.repo = new VulnerabilitiesRepositoryLoader().load(this.repoUrl, (Downloader)new MavenDownloader(this.getLog(), this.wagonManager));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            HashSet allResources = new HashSet();
            allResources.addAll(this.project.getResources());
            allResources.addAll(this.project.getTestResources());
            for (Resource res : allResources) {
                File sourceDir;
                if (res.getDirectory() == null || !(sourceDir = new File(res.getDirectory())).exists()) continue;
                this.getLog().debug((CharSequence)("Scanning directory: " + sourceDir.toString()));
                this.scanDirectory(sourceDir, completeResults);
            }
            if (this.webAppDirectory == null) {
                this.getLog().debug((CharSequence)"Not scanning webAppDirectory since it's null.");
            } else if (!this.webAppDirectory.exists()) {
                this.getLog().debug((CharSequence)("Not scanning webAppDirectory (" + this.webAppDirectory.getAbsolutePath() + ") since it doesn't exist."));
            } else {
                this.getLog().info((CharSequence)("Scanning directory: " + this.webAppDirectory.toString()));
                this.scanDirectory(this.webAppDirectory, completeResults);
            }
            HashSet allSources = new HashSet();
            allSources.addAll(this.project.getCompileSourceRoots());
            allSources.addAll(this.project.getTestCompileSourceRoots());
            allSources.addAll(this.project.getScriptSourceRoots());
            for (String path : allSources) {
                File sourceDir = new File(path);
                if (!sourceDir.exists()) continue;
                this.getLog().debug((CharSequence)("Scanning directory: " + sourceDir.toString()));
                this.scanDirectory(sourceDir, completeResults);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to scan the file ", e);
        }
        if (this.breakOnFailure && completeResults.size() > 0) {
            throw new MojoFailureException(String.format("%d known vulnerabilitie%s were identified in the JavaScript libraries.", completeResults.size(), completeResults.size() > 1 ? "s" : ""));
        }
    }

    protected void scanDirectory(File directory, List<JsLibraryResult> results) throws IOException {
        for (File child : directory.listFiles()) {
            if (child.isDirectory()) {
                this.scanDirectory(child, results);
                continue;
            }
            if (!this.isJavaScriptFile(child)) continue;
            this.scanJavaScriptFile(child, results);
        }
    }

    protected boolean isJavaScriptFile(File child) {
        return child.getName().endsWith(".js");
    }

    protected void scanJavaScriptFile(File javascriptFile, List<JsLibraryResult> completeResults) throws IOException {
        this.getLog().debug((CharSequence)("Scanning " + javascriptFile.getCanonicalFile()));
        byte[] fileContent = IOUtils.toByteArray((InputStream)new FileInputStream(javascriptFile));
        ScannerFacade scanner = new ScannerFacade(this.repo);
        List results = scanner.scanScript(javascriptFile.getAbsolutePath(), fileContent, 0);
        completeResults.addAll(results);
        if (results.size() > 0) {
            this.getLog().warn((CharSequence)(javascriptFile.getName() + " contains a vulnerable JavaScript library."));
            this.getLog().info((CharSequence)("Path: " + javascriptFile.getCanonicalPath()));
            for (JsLibraryResult libraryResult : results) {
                JsLibrary lib = libraryResult.getLibrary();
                this.getLog().info((CharSequence)(lib.getName() + " version " + libraryResult.getDetectedVersion() + " is vulnerable."));
                for (String url : libraryResult.getVuln().getInfo()) {
                    this.getLog().info((CharSequence)("+ " + url));
                }
            }
        }
    }
}

