/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.retirejs;

import com.h3xstream.retirejs.repo.dl.Downloader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.manager.WagonConfigurationException;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.UnsupportedProtocolException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.repository.Repository;

public class MavenDownloader
implements Downloader {
    private Log log;
    private WagonManager wagonManager;

    public MavenDownloader(Log log, WagonManager wagonManager) throws WagonConfigurationException, UnsupportedProtocolException, ConnectionException, AuthenticationException {
        this.log = log;
        this.wagonManager = wagonManager;
    }

    public void downloadUrlToFile(String url, File file) throws Exception {
        if (url == null || url.length() == 0) {
            throw new IllegalArgumentException("url is null or empty");
        }
        URL u = new URL(url);
        if (u.getProtocol().equals("http") || u.getProtocol().equals("https")) {
            this.log.debug((CharSequence)("Downloading from the web : " + url));
            String prefixUrl = u.getProtocol() + "://" + u.getHost() + "/";
            Repository repo = new Repository(prefixUrl, prefixUrl);
            Wagon w = this.wagonManager.getWagon(repo);
            w.connect(repo, this.wagonManager.getProxy(repo.getProtocol()));
            if (url.startsWith(prefixUrl)) {
                url = url.replace(prefixUrl, "");
            }
            w.get(url, file);
        } else if (u.getProtocol().equals("file")) {
            this.log.debug((CharSequence)("Downloading from the local file : " + url));
            try (FileOutputStream outputStream = new FileOutputStream(file);){
                IOUtils.copy((InputStream)u.openStream(), (OutputStream)outputStream);
            }
        } else {
            throw new IllegalArgumentException("Protocol " + u.getProtocol() + " is not supported.");
        }
    }
}

