/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.retirejs.util;

import com.esotericsoftware.minlog.Log;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexUtil {
    private static Pattern PATTERN_REPLACE = Pattern.compile("^\\/(.*[^\\\\])\\/([^\\/]+)\\/$");

    public static String simpleMatch(Pattern pattern, String data) {
        try {
            Matcher m = pattern.matcher(data);
            RegexUtil.validateRegexResult(m);
            return m.find() ? m.group(1) : null;
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static String replaceMatch(String replacePattern, String data) {
        Matcher mRP = PATTERN_REPLACE.matcher(replacePattern);
        if (mRP.find() || mRP.groupCount() != 3) {
            String patternToFind = mRP.group(1);
            String replaceBy = mRP.group(2);
            Log.debug((String)("Pattern to find: " + patternToFind));
            Log.debug((String)("Replace by: " + replaceBy));
            Matcher m = Pattern.compile(patternToFind).matcher(data);
            RegexUtil.validateRegexResult(m);
            if (m.find()) {
                return m.group(0).replaceAll(patternToFind, replaceBy);
            }
            return null;
        }
        throw new RuntimeException("Invalid replace pattern.");
    }

    private static void validateRegexResult(Matcher m) {
        if (m.find() && m.groupCount() == 0) {
            throw new IllegalArgumentException("The regex is expected to contain at least one group.");
        }
        m.reset();
    }

    public static String replaceVersion(String regex) {
        if ((regex = regex.replace("\u00a7\u00a7version\u00a7\u00a7", "[0-9][0-9.a-z_\\\\\\\\-]+")).contains("{")) {
            regex = regex.replaceAll("\\{\\}", "\\\\{\\\\}");
        }
        if (regex.contains("\n")) {
            regex = regex.replaceAll("\n", "\\\\n");
        }
        return regex;
    }
}

