/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.retirejs.repo;

import com.esotericsoftware.minlog.Log;
import com.h3xstream.retirejs.repo.JsLibraryResult;
import com.h3xstream.retirejs.repo.VulnerabilitiesRepository;
import com.h3xstream.retirejs.repo.VulnerabilitiesRepositoryLoader;
import com.h3xstream.retirejs.util.HashUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ScannerFacade {
    private VulnerabilitiesRepository repo;
    private static ScannerFacade instance;

    private ScannerFacade() throws IOException {
        this.repo = new VulnerabilitiesRepositoryLoader().load();
    }

    public ScannerFacade(VulnerabilitiesRepository repo) throws IOException {
        this.repo = repo;
    }

    public static ScannerFacade getInstance() throws IOException {
        if (instance == null) {
            instance = new ScannerFacade();
        }
        return instance;
    }

    public List<JsLibraryResult> scanHtml(byte[] respBytes, int offset) {
        String contentString = new String(respBytes, offset, respBytes.length - offset);
        ArrayList<JsLibraryResult> res = new ArrayList<JsLibraryResult>();
        for (String url : this.findScriptUrl(contentString)) {
            res.addAll(this.scanPath(url));
        }
        return res;
    }

    private List<String> findScriptUrl(String source) {
        String[] tokens = source.split("</");
        ArrayList<String> urls = new ArrayList<String>();
        for (String line : tokens) {
            Pattern p;
            Matcher m;
            if (!line.contains("<script") && !line.contains("<SCRIPT") || !(m = (p = Pattern.compile("<[sS][cC][rR][iI][pP][tT][^>]*[sS][rR][cC]=[\"']([^>]*)[\"']")).matcher(line)).find()) continue;
            String urlScript = m.group(1);
            urls.add(urlScript);
        }
        return urls;
    }

    public List<JsLibraryResult> scanPath(String path) {
        return this.scanScript(path, "".getBytes(), 0);
    }

    public List<JsLibraryResult> scanScript(String path, byte[] respBytes, int offset) {
        List<JsLibraryResult> res = this.repo.findByUri(path);
        if (res.size() == 0) {
            Log.debug((String)String.format("No path matching the script (%s)", path));
            String filename = ScannerFacade.getFilename(path);
            res = this.repo.findByFilename(filename);
            if (res.size() == 0) {
                Log.debug((String)String.format("No filename matching the script (%s)", filename));
                String hash = HashUtil.hashSha1(respBytes, offset);
                res = this.repo.findByHash(hash);
                if (res.size() == 0) {
                    Log.debug((String)String.format("No hash matching %s (%s)", hash, path));
                    String contentString = new String(respBytes, offset, respBytes.length - offset);
                    res = this.repo.findByFileContent(contentString);
                    if (res.size() == 0) {
                        Log.debug((String)String.format("No content matching the script \"%s\"", path));
                    }
                }
            }
        }
        return res;
    }

    private static String getFilename(String path) {
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash < 0) {
            lastSlash = 0;
        }
        return path.substring(lastSlash + 1);
    }
}

