/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.retirejs.repo;

import com.esotericsoftware.minlog.Log;
import com.h3xstream.retirejs.repo.JsLibrary;
import com.h3xstream.retirejs.repo.JsVulnerability;
import com.h3xstream.retirejs.repo.VulnerabilitiesRepository;
import com.h3xstream.retirejs.util.RegexUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.json.JSONArray;
import org.json.JSONObject;

public class VulnerabilitiesRepositoryLoader {
    public static boolean syncWithOnlineRepository = true;

    public VulnerabilitiesRepository load() throws IOException {
        InputStream inputStream = null;
        if (syncWithOnlineRepository) {
            try {
                URL remoteRepo = new URL("https://raw.githubusercontent.com/Retirejs/retire.js/master/repository/jsrepository.json");
                URLConnection conn = remoteRepo.openConnection();
                conn.connect();
                inputStream = conn.getInputStream();
                Log.info((String)"Loading the latest Retire.js repository");
                return this.loadFromInputStream(inputStream);
            }
            catch (UnknownHostException exception) {
                Log.error((String)("Exception while loading the repository (Most likely unable to access the internet) " + exception.getClass().getName() + ": " + exception.getMessage()));
            }
            catch (IOException exception) {
                Log.error((String)("Exception while loading the repository (Connection problem while loading latest repository from GitHub) " + exception.getClass().getName() + ": " + exception.getMessage()));
            }
            catch (RuntimeException exception) {
                Log.error((String)("Exception while loading the repository (Unable to access GitHub ?) " + exception.getClass().getName() + ": " + exception.getMessage()));
                exception.printStackTrace();
            }
        }
        Log.info((String)"Loading the local Retire.js repository (old cache version)");
        inputStream = this.getClass().getResourceAsStream("/retirejs_repository.json");
        return this.loadFromInputStream(inputStream);
    }

    public VulnerabilitiesRepository loadFromInputStream(InputStream in) throws IOException {
        JSONObject rootJson = new JSONObject(VulnerabilitiesRepositoryLoader.convertStreamToString(in));
        VulnerabilitiesRepository repo = new VulnerabilitiesRepository();
        int nbLoaded = 0;
        for (String key : rootJson.keySet()) {
            JSONObject libJson = rootJson.getJSONObject(key);
            JsLibrary lib = new JsLibrary();
            if (libJson.has("vulnerabilities")) {
                JSONArray vulnerabilities = libJson.getJSONArray("vulnerabilities");
                lib.setName(key);
                for (int i = 0; i < vulnerabilities.length(); ++i) {
                    JSONObject vuln = vulnerabilities.getJSONObject(i);
                    String atOrAbove = vuln.has("atOrAbove") ? vuln.getString("atOrAbove") : null;
                    String below = vuln.getString("below");
                    List<String> info = this.objToStringList(vuln.get("info"), false);
                    HashMap<String, List<String>> identifiers = vuln.has("identifiers") ? this.objToStringMapMultiValues(vuln.get("identifiers")) : new HashMap<String, List<String>>();
                    String severity = vuln.has("severity") ? vuln.getString("severity") : "medium";
                    lib.getVulnerabilities().add(new JsVulnerability(atOrAbove, below, info, identifiers, severity));
                }
            }
            if (libJson.has("extractors")) {
                JSONObject extractor = libJson.getJSONObject("extractors");
                if (extractor.has("func")) {
                    lib.setFunctions(this.objToStringList(extractor.get("func"), false));
                }
                if (extractor.has("filename")) {
                    lib.setFilename(this.objToStringList(extractor.get("filename"), true));
                }
                if (extractor.has("filecontent")) {
                    lib.setFileContents(this.objToStringList(extractor.get("filecontent"), true));
                }
                if (extractor.has("hashes")) {
                    lib.setHashes(this.objToStringMap(extractor.get("hashes")));
                }
                if (extractor.has("uri")) {
                    lib.setUris(this.objToStringList(extractor.get("uri"), true));
                }
            }
            repo.addLibrary(lib);
            ++nbLoaded;
        }
        Log.debug((String)(nbLoaded + " loaded library."));
        return repo;
    }

    public List<String> objToStringList(Object obj, boolean replaceVersionWildcard) {
        JSONArray array = (JSONArray)obj;
        ArrayList<String> strArray = new ArrayList<String>(array.length());
        for (int i = 0; i < array.length(); ++i) {
            if (replaceVersionWildcard) {
                strArray.add(RegexUtil.replaceVersion(array.getString(i)));
                continue;
            }
            strArray.add(array.getString(i));
        }
        return strArray;
    }

    public Map<String, String> objToStringMap(Object obj) {
        HashMap<String, String> finalMap = new HashMap<String, String>();
        JSONObject jsonObj = (JSONObject)obj;
        for (String key : jsonObj.keySet()) {
            finalMap.put(key, jsonObj.getString(key));
        }
        return finalMap;
    }

    public Map<String, List<String>> objToStringMapMultiValues(Object obj) {
        HashMap<String, List<String>> finalMap = new HashMap<String, List<String>>();
        JSONObject jsonObj = (JSONObject)obj;
        for (String key : jsonObj.keySet()) {
            JSONArray valuesArray = jsonObj.optJSONArray(key);
            if (valuesArray == null) {
                finalMap.put(key, Arrays.asList(jsonObj.getString(key)));
                continue;
            }
            finalMap.put(key, this.objToStringList(valuesArray, false));
        }
        return finalMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String convertStreamToString(InputStream is) {
        try {
            Scanner s = new Scanner(is, "UTF-8").useDelimiter("\\A");
            String string = s.hasNext() ? s.next() : "";
            return string;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }
}

