/*
 * Decompiled with CFR 0.152.
 */
package burp.vuln;

import burp.BurpExtender;
import burp.IHttpRequestResponse;
import burp.IHttpRequestResponseWithMarkers;
import burp.IHttpService;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MockHttpRequestResponse
implements IHttpRequestResponseWithMarkers {
    IHttpRequestResponse actual;
    List<int[]> requestMarkers = new ArrayList<int[]>();
    List<int[]> responseMarkers = new ArrayList<int[]>();

    MockHttpRequestResponse(IHttpRequestResponse actual, String regexRequest, String regexResponse) {
        if (regexRequest != null) {
            byte[] requestBytes = actual.getRequest();
            this.addMarkers(requestBytes, this.requestMarkers, regexRequest);
        }
        if (regexResponse != null) {
            byte[] responseBytes = actual.getResponse();
            this.addMarkers(responseBytes, this.responseMarkers, regexResponse);
        }
        this.actual = actual;
    }

    private void addMarkers(byte[] content, List<int[]> markers, String ... regexValues) {
        if (regexValues != null) {
            for (String value : regexValues) {
                int[] position;
                if (value == null || (position = this.indexFromRegex(value, content)) == null) continue;
                markers.add(position);
            }
        }
    }

    public byte[] getRequest() {
        return this.actual.getRequest();
    }

    public void setRequest(byte[] message) {
        this.actual.setRequest(message);
    }

    public byte[] getResponse() {
        return this.actual.getResponse();
    }

    public void setResponse(byte[] message) {
        this.actual.setResponse(message);
    }

    public String getComment() {
        return this.actual.getComment();
    }

    public void setComment(String comment) {
        this.actual.setComment(comment);
    }

    public String getHighlight() {
        return "http";
    }

    public void setHighlight(String color) {
        this.actual.setHighlight(color);
    }

    public IHttpService getHttpService() {
        return this.actual.getHttpService();
    }

    public void setHttpService(IHttpService httpService) {
        this.actual.setHttpService(httpService);
    }

    public List<int[]> getRequestMarkers() {
        return this.requestMarkers;
    }

    public List<int[]> getResponseMarkers() {
        return this.responseMarkers;
    }

    public int[] indexFromRegex(String regex, byte[] content) {
        Pattern pattern = Pattern.compile(regex);
        Matcher m = pattern.matcher(BurpExtender.getInstance().getHelpers().bytesToString(content));
        if (m.find()) {
            return new int[]{m.start(), m.end()};
        }
        return null;
    }
}

