/*
 * Decompiled with CFR 0.152.
 */
package burp.vuln;

import burp.HttpUtil;
import burp.IHttpRequestResponse;
import burp.IHttpService;
import burp.IRequestInfo;
import burp.IScanIssue;
import burp.vuln.VulnerableLibraryIssue;
import com.esotericsoftware.minlog.Log;
import com.h3xstream.retirejs.repo.JsLibraryResult;
import com.h3xstream.retirejs.vuln.TemplateBuilder;
import java.util.ArrayList;
import java.util.List;

public class VulnerableLibraryIssueBuilder {
    private static final String TITLE = "The JavaScript file '%s' includes a vulnerable version of the library '%s'";
    private static final String TEMPLATE_DESC = "/burp/vuln/description.html";

    public static List<IScanIssue> convert(List<JsLibraryResult> librariesFound, IHttpService httpService, IHttpRequestResponse reqResp, IRequestInfo requestInfo) {
        ArrayList<IScanIssue> issues = new ArrayList<IScanIssue>();
        for (JsLibraryResult lib : librariesFound) {
            String path = HttpUtil.getPathRequested(requestInfo);
            String filename = HttpUtil.getFileRequested(requestInfo);
            String libraryName = lib.getLibrary().getName();
            String title = String.format(TITLE, filename, libraryName);
            String description = TemplateBuilder.buildDescription((String)TEMPLATE_DESC, (String)libraryName, (String)lib.getDetectedVersion(), (List)lib.getVuln().getInfo(), (String)lib.getVuln().getAtOrAbove(), (String)lib.getVuln().getBelow());
            issues.add(new VulnerableLibraryIssue(httpService, requestInfo.getUrl(), reqResp, title, description, VulnerableLibraryIssueBuilder.mapToBurpSeverity(lib.getVuln().getSeverity()), "Certain", libraryName, path));
        }
        Log.debug((String)(issues.size() + " issues raised for the script " + HttpUtil.getPathRequested(requestInfo)));
        return issues;
    }

    private static String mapToBurpSeverity(String severity) {
        if (severity.equals("info")) {
            return "Information";
        }
        if (severity.equals("high") || severity.equals("medium") || severity.equals("low")) {
            return Character.toUpperCase(severity.charAt(0)) + severity.substring(1);
        }
        return "Medium";
    }
}

