/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.taintanalysis;

import com.h3xstream.findsecbugs.FindSecBugsGlobalConfig;
import com.h3xstream.findsecbugs.common.ByteCode;
import com.h3xstream.findsecbugs.taintanalysis.Taint;
import com.h3xstream.findsecbugs.taintanalysis.TaintConfig;
import com.h3xstream.findsecbugs.taintanalysis.TaintFrame;
import com.h3xstream.findsecbugs.taintanalysis.TaintFrameAdditionalVisitor;
import com.h3xstream.findsecbugs.taintanalysis.TaintMethodConfig;
import com.h3xstream.findsecbugs.taintanalysis.data.TaintLocation;
import com.h3xstream.findsecbugs.taintanalysis.data.UnknownSource;
import com.h3xstream.findsecbugs.taintanalysis.data.UnknownSourceType;
import edu.umd.cs.findbugs.ba.AbstractFrameModelingVisitor;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.InvalidBytecodeException;
import edu.umd.cs.findbugs.ba.generic.GenericSignatureParser;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.util.ClassName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.bcel.generic.AALOAD;
import org.apache.bcel.generic.AASTORE;
import org.apache.bcel.generic.ACONST_NULL;
import org.apache.bcel.generic.ANEWARRAY;
import org.apache.bcel.generic.ARETURN;
import org.apache.bcel.generic.BIPUSH;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.ICONST;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.LDC2_W;
import org.apache.bcel.generic.LoadInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUTFIELD;
import org.apache.bcel.generic.PUTSTATIC;
import org.apache.bcel.generic.SIPUSH;
import org.apache.bcel.generic.StoreInstruction;

public class TaintFrameModelingVisitor
extends AbstractFrameModelingVisitor<Taint, TaintFrame> {
    private static final Logger LOG = Logger.getLogger(TaintFrameModelingVisitor.class.getName());
    private static final Map<String, Taint.Tag> REPLACE_TAGS = new HashMap<String, Taint.Tag>();
    private final MethodDescriptor methodDescriptor;
    private final TaintConfig taintConfig;
    private final TaintMethodConfig analyzedMethodConfig;
    private final List<TaintFrameAdditionalVisitor> visitors;
    private final MethodGen methodGen;

    public TaintFrameModelingVisitor(ConstantPoolGen cpg, MethodDescriptor method, TaintConfig taintConfig, List<TaintFrameAdditionalVisitor> visitors, MethodGen methodGen) {
        super(cpg);
        if (method == null) {
            throw new NullPointerException("null method descriptor");
        }
        if (taintConfig == null) {
            throw new NullPointerException("null taint config");
        }
        this.methodDescriptor = method;
        this.taintConfig = taintConfig;
        this.analyzedMethodConfig = new TaintMethodConfig(false);
        this.visitors = visitors;
        this.methodGen = methodGen;
    }

    private Collection<Integer> getMutableStackIndices(String signature) {
        assert (signature != null && !signature.isEmpty());
        ArrayList<Integer> indices = new ArrayList<Integer>();
        int stackIndex = 0;
        GenericSignatureParser parser = new GenericSignatureParser(signature);
        Iterator iterator = parser.parameterSignatureIterator();
        while (iterator.hasNext()) {
            String parameter = (String)iterator.next();
            if ((parameter.startsWith("L") || parameter.startsWith("[")) && !this.taintConfig.isClassImmutable(parameter)) {
                indices.add(stackIndex);
            }
            if (parameter.equals("D") || parameter.equals("J")) {
                stackIndex += 2;
                continue;
            }
            ++stackIndex;
        }
        for (int i = 0; i < indices.size(); ++i) {
            int reverseIndex = stackIndex - indices.get(i) - 1;
            assert (reverseIndex >= 0);
            indices.set(i, reverseIndex);
        }
        return indices;
    }

    public void analyzeInstruction(Instruction ins) throws DataflowAnalysisException {
        if (FindSecBugsGlobalConfig.getInstance().isDebugPrintInvocationVisited() && ins instanceof InvokeInstruction) {
            ByteCode.printOpCode(ins, this.cpg);
        } else if (FindSecBugsGlobalConfig.getInstance().isDebugPrintInstructionVisited()) {
            ByteCode.printOpCode(ins, this.cpg);
        }
        super.analyzeInstruction(ins);
    }

    public Taint getDefaultValue() {
        return new Taint(Taint.State.UNKNOWN);
    }

    public void visitLDC(LDC ldc) {
        Taint taint = new Taint(Taint.State.SAFE);
        Object value = ldc.getValue(this.cpg);
        if (value instanceof String) {
            taint.setConstantValue((String)value);
        }
        if (FindSecBugsGlobalConfig.getInstance().isDebugTaintState()) {
            if (value instanceof String) {
                taint.setDebugInfo("\"" + value + "\"");
            } else {
                taint.setDebugInfo("LDC " + ldc.getType(this.cpg).getSignature());
            }
        }
        ((TaintFrame)this.getFrame()).pushValue(taint);
    }

    public void visitLDC2_W(LDC2_W obj) {
        if (FindSecBugsGlobalConfig.getInstance().isDebugTaintState()) {
            this.pushSafeDebug("partial long/double");
            this.pushSafeDebug("partial long/double");
        } else {
            this.pushSafe();
            this.pushSafe();
        }
    }

    public void visitBIPUSH(BIPUSH obj) {
        Taint taint = new Taint(Taint.State.SAFE);
        taint.setConstantValue(String.valueOf((char)obj.getValue().byteValue()));
        ((TaintFrame)this.getFrame()).pushValue(taint);
    }

    public void visitSIPUSH(SIPUSH obj) {
        Taint taint = new Taint(Taint.State.SAFE);
        taint.setConstantValue(String.valueOf((char)obj.getValue().shortValue()));
        ((TaintFrame)this.getFrame()).pushValue(taint);
    }

    public void visitGETSTATIC(GETSTATIC obj) {
        if (obj.getLoadClassType(this.getCPG()).getSignature().equals("Lscala/collection/immutable/Nil$;")) {
            if (FindSecBugsGlobalConfig.getInstance().isDebugTaintState()) {
                ((TaintFrame)this.getFrame()).pushValue(new Taint(Taint.State.NULL).setDebugInfo("NULL"));
            } else {
                ((TaintFrame)this.getFrame()).pushValue(new Taint(Taint.State.NULL));
            }
        } else {
            String fieldSig = obj.getClassName(this.cpg).replaceAll("\\.", "/") + "." + obj.getName(this.cpg);
            Taint.State state = this.taintConfig.getClassTaintState(fieldSig, Taint.State.UNKNOWN);
            Taint taint = new Taint(state);
            if (!state.equals((Object)Taint.State.SAFE)) {
                taint.addLocation(this.getTaintLocation(), false);
            }
            taint.addSource(new UnknownSource(UnknownSourceType.FIELD, state).setSignatureField(fieldSig));
            int numConsumed = this.getNumWordsConsumed((Instruction)obj);
            int numProduced = this.getNumWordsProduced((Instruction)obj);
            this.modelInstruction((Instruction)obj, numConsumed, numProduced, taint);
            this.notifyAdditionalVisitorField((FieldInstruction)obj, this.methodGen, (TaintFrame)this.getFrame(), taint, numProduced);
        }
    }

    public void visitACONST_NULL(ACONST_NULL obj) {
        if (FindSecBugsGlobalConfig.getInstance().isDebugTaintState()) {
            ((TaintFrame)this.getFrame()).pushValue(new Taint(Taint.State.NULL).setDebugInfo("NULL"));
        } else {
            ((TaintFrame)this.getFrame()).pushValue(new Taint(Taint.State.NULL));
        }
    }

    public void visitICONST(ICONST obj) {
        Taint t = new Taint(Taint.State.SAFE);
        if (FindSecBugsGlobalConfig.getInstance().isDebugTaintState()) {
            t.setDebugInfo("" + obj.getValue().intValue());
        }
        ((TaintFrame)this.getFrame()).pushValue(t);
    }

    public void visitGETFIELD(GETFIELD obj) {
        String fieldSig = obj.getClassName(this.cpg).replaceAll("\\.", "/") + "." + obj.getName(this.cpg);
        Taint.State state = this.taintConfig.getClassTaintState(fieldSig, Taint.State.UNKNOWN);
        Taint taint = new Taint(state);
        if (!state.equals((Object)Taint.State.SAFE)) {
            taint.addLocation(this.getTaintLocation(), false);
        }
        taint.addSource(new UnknownSource(UnknownSourceType.FIELD, state).setSignatureField(fieldSig));
        if (FindSecBugsGlobalConfig.getInstance().isDebugTaintState()) {
            taint.setDebugInfo("." + obj.getFieldName(this.cpg));
        }
        int numConsumed = this.getNumWordsConsumed((Instruction)obj);
        int numProduced = this.getNumWordsProduced((Instruction)obj);
        this.modelInstruction((Instruction)obj, numConsumed, numProduced, taint);
        this.notifyAdditionalVisitorField((FieldInstruction)obj, this.methodGen, (TaintFrame)this.getFrame(), taint, numProduced);
    }

    public void visitPUTFIELD(PUTFIELD obj) {
        this.visitPutFieldOp((FieldInstruction)obj);
    }

    public void visitPUTSTATIC(PUTSTATIC obj) {
        this.visitPutFieldOp((FieldInstruction)obj);
    }

    public void visitPutFieldOp(FieldInstruction obj) {
        int numConsumed = this.getNumWordsConsumed((Instruction)obj);
        int numProduced = this.getNumWordsProduced((Instruction)obj);
        try {
            Taint t = (Taint)((TaintFrame)this.getFrame()).getTopValue();
            this.handleNormalInstruction((Instruction)obj);
            this.notifyAdditionalVisitorField(obj, this.methodGen, (TaintFrame)this.getFrame(), t, numProduced);
        }
        catch (DataflowAnalysisException dataflowAnalysisException) {
            // empty catch block
        }
    }

    private void notifyAdditionalVisitorField(FieldInstruction instruction, MethodGen methodGen, TaintFrame frame, Taint taintValue, int numProduced) {
        for (TaintFrameAdditionalVisitor visitor : this.visitors) {
            try {
                visitor.visitField(instruction, methodGen, frame, taintValue, numProduced, this.cpg);
            }
            catch (Throwable e) {
                LOG.log(Level.SEVERE, "Error while executing " + visitor.getClass().getName(), e);
            }
        }
    }

    public void visitNEW(NEW obj) {
        Taint taint = new Taint(Taint.State.SAFE);
        ObjectType type = obj.getLoadClassType(this.cpg);
        taint.setRealInstanceClass(type);
        if (FindSecBugsGlobalConfig.getInstance().isDebugTaintState()) {
            taint.setDebugInfo("new " + type.getClassName() + "()");
        }
        ((TaintFrame)this.getFrame()).pushValue(taint);
    }

    public void handleStoreInstruction(StoreInstruction obj) {
        try {
            int numConsumed = obj.consumeStack(this.cpg);
            if (numConsumed == -2) {
                throw new InvalidBytecodeException("Unpredictable stack consumption");
            }
            int index = obj.getIndex();
            while (numConsumed-- > 0) {
                Taint value = new Taint((Taint)((TaintFrame)this.getFrame()).popValue());
                value.setVariableIndex(index);
                ((TaintFrame)this.getFrame()).setValue(index++, value);
            }
        }
        catch (DataflowAnalysisException ex) {
            throw new InvalidBytecodeException(ex.toString(), (Throwable)ex);
        }
    }

    public void handleLoadInstruction(LoadInstruction load) {
        int numProducedOrig = load.produceStack(this.cpg);
        int numProduced = numProducedOrig;
        if (numProduced == -2) {
            throw new InvalidBytecodeException("Unpredictable stack production");
        }
        int index = load.getIndex() + numProduced;
        while (numProduced-- > 0) {
            Taint value = (Taint)((TaintFrame)this.getFrame()).getValue(--index);
            if (!value.hasValidVariableIndex()) {
                throw new RuntimeException("index not set in " + this.methodDescriptor);
            }
            if (index != value.getVariableIndex()) {
                throw new RuntimeException("bad index in " + this.methodDescriptor);
            }
            ((TaintFrame)this.getFrame()).pushValue(new Taint(value));
        }
        for (TaintFrameAdditionalVisitor visitor : this.visitors) {
            try {
                visitor.visitLoad(load, this.methodGen, (TaintFrame)this.getFrame(), numProducedOrig, this.cpg);
            }
            catch (Throwable e) {
                LOG.log(Level.SEVERE, "Error while executing " + visitor.getClass().getName(), e);
            }
        }
    }

    public void visitINVOKEINTERFACE(INVOKEINTERFACE obj) {
        this.visitInvoke((InvokeInstruction)obj);
    }

    public void visitINVOKESPECIAL(INVOKESPECIAL obj) {
        this.visitInvoke((InvokeInstruction)obj);
    }

    public void visitINVOKESTATIC(INVOKESTATIC obj) {
        this.visitInvoke((InvokeInstruction)obj);
    }

    public void visitINVOKEVIRTUAL(INVOKEVIRTUAL obj) {
        this.visitInvoke((InvokeInstruction)obj);
    }

    public void visitANEWARRAY(ANEWARRAY obj) {
        try {
            ((TaintFrame)this.getFrame()).popValue();
            if (FindSecBugsGlobalConfig.getInstance().isDebugTaintState()) {
                this.pushSafeDebug("new " + obj.getLoadClassType(this.cpg).getClassName() + "[]");
            } else {
                this.pushSafe();
            }
        }
        catch (DataflowAnalysisException ex) {
            throw new InvalidBytecodeException("Array length not in the stack", (Throwable)ex);
        }
    }

    public void visitAASTORE(AASTORE obj) {
        try {
            Taint valueTaint = (Taint)((TaintFrame)this.getFrame()).popValue();
            ((TaintFrame)this.getFrame()).popValue();
            Taint arrayTaint = (Taint)((TaintFrame)this.getFrame()).popValue();
            Taint merge = Taint.merge(valueTaint, arrayTaint);
            this.setLocalVariableTaint(merge, arrayTaint);
            Taint stackTop = null;
            if (((TaintFrame)this.getFrame()).getStackDepth() > 0) {
                stackTop = (Taint)((TaintFrame)this.getFrame()).getTopValue();
            }
            if (stackTop == arrayTaint) {
                ((TaintFrame)this.getFrame()).popValue();
                ((TaintFrame)this.getFrame()).pushValue(new Taint(merge));
            }
        }
        catch (DataflowAnalysisException ex) {
            throw new InvalidBytecodeException("Not enough values on the stack", (Throwable)ex);
        }
    }

    public void visitAALOAD(AALOAD obj) {
        try {
            ((TaintFrame)this.getFrame()).popValue();
        }
        catch (DataflowAnalysisException ex) {
            throw new InvalidBytecodeException("Not enough values on the stack", (Throwable)ex);
        }
    }

    public void visitCHECKCAST(CHECKCAST obj) {
        ObjectType objectType = obj.getLoadClassType(this.cpg);
        if (objectType == null) {
            return;
        }
        String objectTypeSignature = objectType.getSignature();
        if (!this.taintConfig.isClassTaintSafe(objectTypeSignature)) {
            return;
        }
        try {
            ((TaintFrame)this.getFrame()).popValue();
            this.pushSafe();
        }
        catch (DataflowAnalysisException ex) {
            throw new InvalidBytecodeException("empty stack for checkcast", (Throwable)ex);
        }
    }

    public void visitARETURN(ARETURN obj) {
        Taint returnTaint = null;
        try {
            returnTaint = (Taint)((TaintFrame)this.getFrame()).getTopValue();
            Taint currentTaint = this.analyzedMethodConfig.getOutputTaint();
            this.analyzedMethodConfig.setOuputTaint(Taint.merge(returnTaint, currentTaint));
        }
        catch (DataflowAnalysisException ex) {
            throw new InvalidBytecodeException("empty stack before reference return", (Throwable)ex);
        }
        this.handleNormalInstruction((Instruction)obj);
        for (TaintFrameAdditionalVisitor visitor : this.visitors) {
            try {
                visitor.visitReturn(this.methodGen, returnTaint, this.cpg);
            }
            catch (Throwable e) {
                LOG.log(Level.SEVERE, "Error while executing " + visitor.getClass().getName(), e);
            }
        }
    }

    private void visitInvoke(InvokeInstruction obj) {
        assert (obj != null);
        try {
            TaintMethodConfig methodConfig = this.getMethodConfig(obj);
            ObjectType realInstanceClass = methodConfig == null ? null : methodConfig.getOutputTaint().getRealInstanceClass();
            Taint taint = this.getMethodTaint(methodConfig);
            assert (taint != null);
            if (FindSecBugsGlobalConfig.getInstance().isDebugTaintState()) {
                taint.setDebugInfo(obj.getMethodName(this.cpg) + "()");
            }
            taint.addSource(new UnknownSource(UnknownSourceType.RETURN, taint.getState()).setSignatureMethod(obj.getClassName(this.cpg).replace(".", "/") + "." + obj.getMethodName(this.cpg) + obj.getSignature(this.cpg)));
            if (taint.isUnknown()) {
                taint.addLocation(this.getTaintLocation(), false);
            }
            this.taintMutableArguments(methodConfig, obj);
            this.transferTaintToMutables(methodConfig, taint);
            Taint taintCopy = new Taint(taint);
            taintCopy.setRealInstanceClass(realInstanceClass);
            TaintFrame tf = (TaintFrame)this.getFrame();
            int stackDepth = tf.getStackDepth();
            int nbParam = this.getNumWordsConsumed((Instruction)obj);
            ArrayList<Taint> parameters = new ArrayList<Taint>(nbParam);
            for (int i = 0; i < Math.min(stackDepth, nbParam); ++i) {
                parameters.add(new Taint((Taint)tf.getStackValue(i)));
            }
            this.modelInstruction((Instruction)obj, this.getNumWordsConsumed((Instruction)obj), this.getNumWordsProduced((Instruction)obj), taintCopy);
            for (TaintFrameAdditionalVisitor visitor : this.visitors) {
                try {
                    visitor.visitInvoke(obj, this.methodGen, (TaintFrame)this.getFrame(), parameters, this.cpg);
                }
                catch (Throwable e) {
                    LOG.log(Level.SEVERE, "Error while executing " + visitor.getClass().getName(), e);
                }
            }
        }
        catch (Exception e) {
            String className = ClassName.toSlashedClassName((String)obj.getReferenceType(this.cpg).toString());
            String methodName = obj.getMethodName(this.cpg);
            String signature = obj.getSignature(this.cpg);
            throw new RuntimeException("Unable to call " + className + '.' + methodName + signature, e);
        }
    }

    private TaintMethodConfig getMethodConfig(InvokeInstruction obj) {
        String signature = obj.getSignature(this.cpg);
        String returnType = TaintFrameModelingVisitor.getReturnType(signature);
        String className = this.getInstanceClassName(obj);
        String methodName = obj.getMethodName(this.cpg);
        String methodId = "." + methodName + signature;
        TaintMethodConfig config = this.taintConfig.getMethodConfig((TaintFrame)this.getFrame(), this.methodDescriptor, className, methodId);
        if (config != null) {
            config = this.getConfigWithReplaceTags(config, className, methodName);
        }
        if (config != null && config.isConfigured()) {
            return config;
        }
        if (this.taintConfig.isClassTaintSafe(returnType)) {
            return TaintMethodConfig.SAFE_CONFIG;
        }
        if (config != null) {
            return config;
        }
        if ("<init>".equals(methodName) && !this.taintConfig.isClassTaintSafe("L" + className + ";")) {
            try {
                int stackSize = ((TaintFrame)this.getFrame()).getNumArgumentsIncludingObjectInstance(obj, this.cpg);
                return TaintMethodConfig.getDefaultConstructorConfig(stackSize);
            }
            catch (DataflowAnalysisException ex) {
                throw new InvalidBytecodeException(ex.getMessage(), (Throwable)ex);
            }
        }
        return null;
    }

    private TaintMethodConfig getConfigWithReplaceTags(TaintMethodConfig config, String className, String methodName) {
        if (!"java/lang/String".equals(className)) {
            return config;
        }
        boolean isRegex = "replaceAll".equals(methodName);
        if (!isRegex && !"replace".equals(methodName)) {
            return config;
        }
        try {
            String toReplace = ((Taint)((TaintFrame)this.getFrame()).getStackValue(1)).getConstantValue();
            if (toReplace == null) {
                return config;
            }
            Taint taint = config.getOutputTaint();
            for (Map.Entry<String, Taint.Tag> replaceTag : REPLACE_TAGS.entrySet()) {
                String tagString = replaceTag.getKey();
                if ((!isRegex || !toReplace.contains(tagString)) && !toReplace.equals(tagString)) continue;
                taint.addTag(replaceTag.getValue());
            }
            TaintMethodConfig configCopy = new TaintMethodConfig(config);
            configCopy.setOuputTaint(taint);
            return configCopy;
        }
        catch (DataflowAnalysisException ex) {
            throw new InvalidBytecodeException(ex.getMessage(), (Throwable)ex);
        }
    }

    private String getInstanceClassName(InvokeInstruction invoke) {
        block5: {
            try {
                int instanceIndex = ((TaintFrame)this.getFrame()).getNumArgumentsIncludingObjectInstance(invoke, this.cpg) - 1;
                if (instanceIndex != -1) {
                    assert (instanceIndex < ((TaintFrame)this.getFrame()).getStackDepth());
                    Taint instanceTaint = (Taint)((TaintFrame)this.getFrame()).getStackValue(instanceIndex);
                    String className = instanceTaint.getRealInstanceClassName();
                    if (className != null) {
                        return className;
                    }
                }
            }
            catch (DataflowAnalysisException ex) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError((Object)ex.getMessage());
            }
        }
        String dottedClassName = invoke.getReferenceType(this.cpg).toString();
        return ClassName.toSlashedClassName((String)dottedClassName);
    }

    private static String getReturnType(String signature) {
        assert (signature != null && signature.contains(")"));
        return signature.substring(signature.indexOf(41) + 1);
    }

    private Taint getMethodTaint(TaintMethodConfig methodConfig) {
        if (methodConfig == null) {
            return this.getDefaultValue();
        }
        Taint taint = methodConfig.getOutputTaint();
        assert (taint != null);
        assert (taint != methodConfig.getOutputTaint()) : "defensive copy not made";
        Taint taintCopy = new Taint(taint);
        if (taint.isUnknown() && taint.hasParameters()) {
            Taint merge = this.mergeTransferParameters(taint.getParameters());
            assert (merge != null);
            taint = Taint.merge(Taint.valueOf(taint.getNonParametricState()), merge);
        }
        if (taint.isTainted()) {
            taint.addLocation(this.getTaintLocation(), true);
        }
        if (!taint.isSafe() && taintCopy.hasTags()) {
            for (Taint.Tag tag : taintCopy.getTags()) {
                taint.addTag(tag);
            }
        }
        if (taintCopy.isRemovingTags()) {
            for (Taint.Tag tag : taintCopy.getTagsToRemove()) {
                taint.removeTag(tag);
            }
        }
        return taint;
    }

    private void taintMutableArguments(TaintMethodConfig methodConfig, InvokeInstruction obj) {
        if (methodConfig != null && methodConfig.isConfigured()) {
            return;
        }
        Collection<Integer> mutableStackIndices = this.getMutableStackIndices(obj.getSignature(this.cpg));
        for (Integer index : mutableStackIndices) {
            assert (index >= 0 && index < ((TaintFrame)this.getFrame()).getStackDepth());
            try {
                Taint stackValue = (Taint)((TaintFrame)this.getFrame()).getStackValue(index);
                Taint taint = Taint.merge(stackValue, this.getDefaultValue());
                if (stackValue.hasValidVariableIndex()) {
                    taint.setVariableIndex(stackValue.getVariableIndex());
                }
                taint.setRealInstanceClass(stackValue.getRealInstanceClass());
                taint.addLocation(this.getTaintLocation(), false);
                ((TaintFrame)this.getFrame()).setValue(((TaintFrame)this.getFrame()).getStackLocation(index), taint);
                this.setLocalVariableTaint(taint, taint);
            }
            catch (DataflowAnalysisException ex) {
                throw new InvalidBytecodeException("Not enough values on the stack", (Throwable)ex);
            }
        }
    }

    private Taint mergeTransferParameters(Collection<Integer> transferParameters) {
        assert (transferParameters != null && !transferParameters.isEmpty());
        Taint taint = null;
        for (Integer transferParameter : transferParameters) {
            try {
                Taint value = (Taint)((TaintFrame)this.getFrame()).getStackValue(transferParameter);
                taint = Taint.merge(taint, value);
            }
            catch (DataflowAnalysisException ex) {
                throw new RuntimeException("Bad transfer parameter specification", ex);
            }
        }
        assert (taint != null);
        return taint;
    }

    private void transferTaintToMutables(TaintMethodConfig methodConfig, Taint taint) {
        block8: {
            assert (taint != null);
            if (methodConfig == null || !methodConfig.hasMutableStackIndices()) {
                return;
            }
            try {
                int stackDepth = ((TaintFrame)this.getFrame()).getStackDepth();
                for (Integer mutableStackIndex : methodConfig.getMutableStackIndices()) {
                    assert (mutableStackIndex >= 0);
                    if (mutableStackIndex >= stackDepth) {
                        if (!"<init>".equals(this.methodDescriptor.getName()) && !"<clinit>".equals(this.methodDescriptor.getName())) assert (false) : "Out of bounds mutables in " + this.methodDescriptor + " Method Config: " + methodConfig.toString();
                        continue;
                    }
                    Taint stackValue = (Taint)((TaintFrame)this.getFrame()).getStackValue(mutableStackIndex);
                    this.setLocalVariableTaint(taint, stackValue);
                    Taint taintCopy = new Taint(taint);
                    taintCopy.setRealInstanceClass(stackValue.getRealInstanceClass());
                    ((TaintFrame)this.getFrame()).setValue(((TaintFrame)this.getFrame()).getStackLocation(mutableStackIndex), taintCopy);
                }
            }
            catch (DataflowAnalysisException ex) {
                if ($assertionsDisabled) break block8;
                throw new AssertionError((Object)ex.getMessage());
            }
        }
    }

    private void setLocalVariableTaint(Taint valueTaint, Taint indexTaint) {
        assert (valueTaint != null && indexTaint != null);
        if (!indexTaint.hasValidVariableIndex()) {
            return;
        }
        int index = indexTaint.getVariableIndex();
        if (index >= ((TaintFrame)this.getFrame()).getNumLocals()) {
            assert (false) : "Out of bounds local variable index in " + this.methodDescriptor;
            return;
        }
        valueTaint.setVariableIndex(index);
        ((TaintFrame)this.getFrame()).setValue(index, valueTaint);
    }

    private void pushSafe() {
        ((TaintFrame)this.getFrame()).pushValue(new Taint(Taint.State.SAFE));
    }

    private void pushSafeDebug(String debugInfo) {
        ((TaintFrame)this.getFrame()).pushValue(new Taint(Taint.State.SAFE).setDebugInfo(debugInfo));
    }

    private TaintLocation getTaintLocation() {
        return new TaintLocation(this.methodDescriptor, this.getLocation().getHandle().getPosition());
    }

    public void finishAnalysis() {
        String fullMethodName;
        assert (this.analyzedMethodConfig != null);
        Taint outputTaint = this.analyzedMethodConfig.getOutputTaint();
        if (outputTaint == null) {
            return;
        }
        String returnType = TaintFrameModelingVisitor.getReturnType(this.methodDescriptor.getSignature());
        if (this.taintConfig.isClassTaintSafe(returnType) && outputTaint.getState() != Taint.State.NULL) {
            return;
        }
        String realInstanceClassName = outputTaint.getRealInstanceClassName();
        if (returnType.equals("L" + realInstanceClassName + ";")) {
            outputTaint.setRealInstanceClass(null);
            this.analyzedMethodConfig.setOuputTaint(outputTaint);
        }
        String className = this.methodDescriptor.getSlashedClassName();
        String methodId = "." + this.methodDescriptor.getName() + this.methodDescriptor.getSignature();
        if ((this.analyzedMethodConfig.isInformative() || this.taintConfig.getSuperMethodConfig(className, methodId) != null) && !this.taintConfig.containsKey(fullMethodName = className.concat(methodId))) {
            this.taintConfig.put(fullMethodName, this.analyzedMethodConfig);
        }
    }

    static {
        REPLACE_TAGS.put("\r", Taint.Tag.CR_ENCODED);
        REPLACE_TAGS.put("\n", Taint.Tag.LF_ENCODED);
        REPLACE_TAGS.put("\"", Taint.Tag.QUOTE_ENCODED);
        REPLACE_TAGS.put("'", Taint.Tag.APOSTROPHE_ENCODED);
        REPLACE_TAGS.put("<", Taint.Tag.LT_ENCODED);
    }
}

