/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.ldap;

import com.h3xstream.findsecbugs.common.ByteCode;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import java.util.Iterator;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.LDC;

public class AnonymousLdapDetector
implements Detector {
    private static final String LDAP_ANONYMOUS = "LDAP_ANONYMOUS";
    private BugReporter bugReporter;

    public AnonymousLdapDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        JavaClass javaClass = classContext.getJavaClass();
        for (Method m : methodList = javaClass.getMethods()) {
            try {
                this.analyzeMethod(m, classContext);
            }
            catch (CFGBuilderException cFGBuilderException) {
            }
            catch (DataflowAnalysisException dataflowAnalysisException) {
                // empty catch block
            }
        }
    }

    private void analyzeMethod(Method m, ClassContext classContext) throws CFGBuilderException, DataflowAnalysisException {
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        CFG cfg = classContext.getCFG(m);
        Iterator i = cfg.locationIterator();
        while (i.hasNext()) {
            LDC ldc;
            Location location = (Location)i.next();
            Instruction inst = location.getHandle().getInstruction();
            if (!(inst instanceof LDC) || (ldc = (LDC)inst) == null || !"java.naming.security.authentication".equals(ldc.getValue(cpg)) || !"none".equals(ByteCode.getConstantLDC(location.getHandle().getNext(), cpg, String.class))) continue;
            JavaClass clz = classContext.getJavaClass();
            this.bugReporter.reportBug(new BugInstance((Detector)this, LDAP_ANONYMOUS, 3).addClass(clz).addMethod(clz, m).addSourceLine(classContext, m, location));
            break;
        }
    }

    public void report() {
    }
}

