/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.Iterator;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;

public class ImproperHandlingUnicodeDetector
extends OpcodeStackDetector {
    private String IMPROPER_UNICODE_TYPE = "IMPROPER_UNICODE";
    private BugReporter bugReporter;

    public ImproperHandlingUnicodeDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    private void reportBug() {
        BugInstance bug = new BugInstance((Detector)this, this.IMPROPER_UNICODE_TYPE, 3).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this);
        this.bugReporter.reportBug(bug);
    }

    private boolean hasComparisonInMethod() {
        CFG cfg;
        ClassContext classCtx = this.getClassContext();
        ConstantPoolGen cpg = classCtx.getConstantPoolGen();
        try {
            cfg = classCtx.getCFG(this.getMethod());
        }
        catch (CFGBuilderException e) {
            AnalysisContext.logError((String)"Cannot get CFG", (Exception)((Object)e));
            return false;
        }
        Iterator i = cfg.locationIterator();
        while (i.hasNext()) {
            Location location = (Location)i.next();
            Instruction inst = location.getHandle().getInstruction();
            if (!(inst instanceof INVOKEVIRTUAL)) continue;
            INVOKEVIRTUAL inv = (INVOKEVIRTUAL)inst;
            String className = inv.getClassName(cpg);
            String methodName = inv.getMethodName(cpg);
            if (!className.equals("java.lang.String") || !methodName.equals("equals") && !methodName.equals("indexOf")) continue;
            return true;
        }
        return false;
    }

    public void sawOpcode(int seen) {
        if (seen == 184 && this.getClassConstantOperand().equals("java/text/Normalizer") && this.getNameConstantOperand().equals("normalize")) {
            this.reportBug();
        } else if (seen == 182 && this.getClassConstantOperand().equals("java/net/URI") && this.getNameConstantOperand().equals("toASCIIString")) {
            this.reportBug();
        } else if (seen == 184 && this.getClassConstantOperand().equals("java/net/IDN") && this.getNameConstantOperand().equals("toASCII")) {
            this.reportBug();
        } else if (seen == 182 && this.getClassConstantOperand().equals("java/lang/String") && (this.getNameConstantOperand().equals("toUpperCase") || this.getNameConstantOperand().equals("toLowerCase"))) {
            if (this.hasComparisonInMethod()) {
                this.reportBug();
            }
        } else if (seen == 182 && this.getClassConstantOperand().equals("java/lang/String") && this.getNameConstantOperand().equals("equalsIgnoreCase")) {
            this.reportBug();
        }
    }
}

