/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.password;

import com.h3xstream.findsecbugs.injection.BasicInjectionDetector;
import com.h3xstream.findsecbugs.taintanalysis.Taint;
import com.h3xstream.findsecbugs.taintanalysis.TaintFrame;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractHardcodePasswordInMapDetector
extends BasicInjectionDetector {
    private static List<String> PASSWORD_WORDS = new ArrayList<String>();

    public AbstractHardcodePasswordInMapDetector(BugReporter bugReporter) {
        super(bugReporter);
    }

    @Override
    protected int getPriorityFromTaintFrame(TaintFrame fact, int offset) throws DataflowAnalysisException {
        Taint valueTaint = (Taint)fact.getStackValue(0);
        Taint parameterTaint = (Taint)fact.getStackValue(1);
        if (valueTaint.getConstantValue() == null || parameterTaint.getConstantValue() == null) {
            return 5;
        }
        String parameterValue = parameterTaint.getConstantValue().toLowerCase();
        if (parameterValue.equals("java.naming.security.credentials")) {
            return 2;
        }
        for (String password : PASSWORD_WORDS) {
            if (!parameterValue.contains(password)) continue;
            return 2;
        }
        return 5;
    }

    static {
        PASSWORD_WORDS.add("password");
        PASSWORD_WORDS.add("motdepasse");
        PASSWORD_WORDS.add("heslo");
        PASSWORD_WORDS.add("adgangskode");
        PASSWORD_WORDS.add("wachtwoord");
        PASSWORD_WORDS.add("salasana");
        PASSWORD_WORDS.add("passwort");
        PASSWORD_WORDS.add("passord");
        PASSWORD_WORDS.add("senha");
        PASSWORD_WORDS.add("geslo");
        PASSWORD_WORDS.add("clave");
        PASSWORD_WORDS.add("losenord");
        PASSWORD_WORDS.add("clave");
        PASSWORD_WORDS.add("parola");
        PASSWORD_WORDS.add("secretkey");
        PASSWORD_WORDS.add("pwd");
    }
}

