/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.h2.engine.CastDataProvider;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.function.FunctionN;
import org.h2.message.DbException;
import org.h2.util.DateTimeUtils;
import org.h2.util.LegacyDateTimeUtils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueTimestampTimeZone;
import org.h2.value.ValueVarchar;

public final class DateTimeFormatFunction
extends FunctionN {
    public static final int FORMATDATETIME = 0;
    public static final int PARSEDATETIME = 1;
    private static final String[] NAMES = new String[]{"FORMATDATETIME", "PARSEDATETIME"};
    private final int function;

    public DateTimeFormatFunction(int n) {
        super(new Expression[4]);
        this.function = n;
    }

    @Override
    public Value getValue(SessionLocal sessionLocal, Value value, Value value2, Value value3) {
        String string;
        String string2;
        String string3 = value2.getString();
        if (value3 != null) {
            string2 = value3.getString();
            string = this.args.length > 3 ? this.args[3].getValue(sessionLocal).getString() : null;
        } else {
            string2 = null;
            string = null;
        }
        switch (this.function) {
            case 0: {
                if (value instanceof ValueTimestampTimeZone) {
                    string = DateTimeUtils.timeZoneNameFromOffsetSeconds(((ValueTimestampTimeZone)value).getTimeZoneOffsetSeconds());
                }
                value = ValueVarchar.get(DateTimeFormatFunction.formatDateTime(LegacyDateTimeUtils.toTimestamp(sessionLocal, null, value), string3, string2, string), sessionLocal);
                break;
            }
            case 1: {
                value = LegacyDateTimeUtils.fromTimestamp((CastDataProvider)sessionLocal, DateTimeFormatFunction.parseDateTime(value.getString(), string3, string2, string).getTime(), 0);
                break;
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDateTime(Date date, String string, String string2, String string3) {
        SimpleDateFormat simpleDateFormat;
        SimpleDateFormat simpleDateFormat2 = simpleDateFormat = DateTimeFormatFunction.getDateFormat(string, string2, string3);
        synchronized (simpleDateFormat2) {
            return simpleDateFormat.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseDateTime(String string, String string2, String string3, String string4) {
        SimpleDateFormat simpleDateFormat = DateTimeFormatFunction.getDateFormat(string2, string3, string4);
        try {
            SimpleDateFormat simpleDateFormat2 = simpleDateFormat;
            synchronized (simpleDateFormat2) {
                return simpleDateFormat.parse(string);
            }
        }
        catch (Exception exception) {
            throw DbException.get(90014, exception, string);
        }
    }

    private static SimpleDateFormat getDateFormat(String string, String string2, String string3) {
        try {
            SimpleDateFormat simpleDateFormat;
            if (string2 == null) {
                simpleDateFormat = new SimpleDateFormat(string);
            } else {
                Locale locale = new Locale(string2);
                simpleDateFormat = new SimpleDateFormat(string, locale);
            }
            if (string3 != null) {
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone(string3));
            }
            return simpleDateFormat;
        }
        catch (Exception exception) {
            throw DbException.get(90014, exception, string + '/' + string2 + '/' + string3);
        }
    }

    @Override
    public Expression optimize(SessionLocal sessionLocal) {
        boolean bl = this.optimizeArguments(sessionLocal, true);
        switch (this.function) {
            case 0: {
                this.type = TypeInfo.TYPE_VARCHAR;
                break;
            }
            case 1: {
                this.type = TypeInfo.TYPE_TIMESTAMP;
                break;
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        if (bl) {
            return TypedValueExpression.getTypedIfNull(this.getValue(sessionLocal), this.type);
        }
        return this;
    }

    @Override
    public String getName() {
        return NAMES[this.function];
    }
}

