/*
 * Decompiled with CFR 0.152.
 */
package org.h2.bnf.context;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.h2.bnf.context.DbContents;

public class DbColumn {
    private final String name;
    private final String quotedName;
    private final String dataType;
    private int position;

    public DbColumn(DbContents dbContents, ResultSet resultSet) throws SQLException {
        this.name = resultSet.getString("COLUMN_NAME");
        this.quotedName = dbContents.quoteIdentifier(this.name);
        String string = resultSet.getString("TYPE_NAME");
        int n = DbContents.findColumn(resultSet, "PRECISION", 0);
        int n2 = n == 0 ? resultSet.getInt(DbContents.findColumn(resultSet, "COLUMN_SIZE", 7)) : resultSet.getInt(n);
        this.position = resultSet.getInt("ORDINAL_POSITION");
        boolean bl = dbContents.isSQLite();
        if (n2 > 0 && !bl) {
            string = string + "(" + n2;
            int n3 = resultSet.getInt(DbContents.findColumn(resultSet, "DECIMAL_DIGITS", 9));
            if (n3 > 0) {
                string = string + ", " + n3;
            }
            string = string + ")";
        }
        if (resultSet.getInt("NULLABLE") == 0) {
            string = string + " NOT NULL";
        }
        this.dataType = string;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getName() {
        return this.name;
    }

    public String getQuotedName() {
        return this.quotedName;
    }

    public int getPosition() {
        return this.position;
    }
}

