/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.command.dml.Query;
import org.h2.engine.Session;
import org.h2.expression.Condition;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.result.LocalResult;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;

public class ConditionExists
extends Condition {
    private final Query query;

    public ConditionExists(Query query) {
        this.query = query;
    }

    public Value getValue(Session session) {
        this.query.setSession(session);
        LocalResult localResult = this.query.query(1);
        session.addTemporaryResult(localResult);
        boolean bl = localResult.getRowCount() > 0;
        return ValueBoolean.get(bl);
    }

    public Expression optimize(Session session) {
        this.query.prepare();
        return this;
    }

    public String getSQL() {
        return "EXISTS(" + this.query.getPlanSQL() + ")";
    }

    public void updateAggregate(Session session) {
    }

    public void mapColumns(ColumnResolver columnResolver, int n) {
        this.query.mapColumns(columnResolver, n + 1);
    }

    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.query.setEvaluatable(tableFilter, bl);
    }

    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.query.isEverything(expressionVisitor);
    }

    public int getCost() {
        return 10 + (int)(10.0 * this.query.getCost());
    }
}

