/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import org.h2.constant.SysProperties;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.result.ResultExternal;
import org.h2.result.SortOrder;
import org.h2.store.Data;
import org.h2.store.DataHandler;
import org.h2.store.FileStore;
import org.h2.util.New;
import org.h2.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResultDiskBuffer
implements ResultExternal {
    private static final int READ_AHEAD = 128;
    private Data rowBuff;
    private FileStore file;
    private ArrayList<ResultDiskTape> tapes;
    private ResultDiskTape mainTape;
    private SortOrder sort;
    private int columnCount;

    ResultDiskBuffer(Session session, SortOrder sortOrder, int n) {
        this.sort = sortOrder;
        this.columnCount = n;
        Database database = session.getDatabase();
        this.rowBuff = Data.create((DataHandler)database, SysProperties.PAGE_SIZE);
        String string = session.getDatabase().createTempFile();
        this.file = session.getDatabase().openFile(string, "rw", false);
        this.file.setCheckedWriting(false);
        this.file.seek(48L);
        if (sortOrder != null) {
            this.tapes = New.arrayList();
        } else {
            this.mainTape = new ResultDiskTape();
            this.mainTape.pos = 48L;
        }
    }

    @Override
    public void addRows(ArrayList<Value[]> arrayList) {
        Object object;
        if (this.sort != null) {
            this.sort.sort(arrayList);
        }
        Data data = this.rowBuff;
        long l = this.file.getFilePointer();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        int n2 = SysProperties.LARGE_RESULT_BUFFER_SIZE;
        for (Value[] valueArray : arrayList) {
            Object object2;
            int n3;
            data.reset();
            data.writeInt(0);
            for (n3 = 0; n3 < this.columnCount; ++n3) {
                object2 = valueArray[n3];
                data.checkCapacity(data.getValueLen((Value)object2));
                data.writeValue((Value)object2);
            }
            data.fillAligned();
            n3 = data.length();
            data.setInt(0, n3);
            if (n2 > 0) {
                byteArrayOutputStream.write(data.getBytes(), 0, n3);
                if ((n += n3) <= n2) continue;
                object2 = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.reset();
                this.file.write((byte[])object2, 0, ((Object)object2).length);
                n = 0;
                continue;
            }
            this.file.write(data.getBytes(), 0, n3);
        }
        if (n > 0) {
            object = byteArrayOutputStream.toByteArray();
            this.file.write((byte[])object, 0, ((Object)object).length);
        }
        if (this.sort != null) {
            object = new ResultDiskTape();
            ((ResultDiskTape)object).start = l;
            ((ResultDiskTape)object).end = this.file.getFilePointer();
            this.tapes.add((ResultDiskTape)object);
        } else {
            this.mainTape.end = this.file.getFilePointer();
        }
    }

    @Override
    public void done() {
        this.file.seek(48L);
        this.file.autoDelete();
    }

    @Override
    public void reset() {
        if (this.sort != null) {
            for (ResultDiskTape resultDiskTape : this.tapes) {
                resultDiskTape.pos = resultDiskTape.start;
                resultDiskTape.buffer = New.arrayList();
            }
        } else {
            this.mainTape.pos = 48L;
            this.mainTape.buffer = New.arrayList();
        }
    }

    private void readRow(ResultDiskTape resultDiskTape) {
        int n = 16;
        Data data = this.rowBuff;
        data.reset();
        this.file.readFully(data.getBytes(), 0, n);
        int n2 = data.readInt();
        data.checkCapacity(n2);
        if (n2 - n > 0) {
            this.file.readFully(data.getBytes(), n, n2 - n);
        }
        resultDiskTape.pos += (long)n2;
        Value[] valueArray = new Value[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            valueArray[i] = data.readValue();
        }
        resultDiskTape.buffer.add(valueArray);
    }

    @Override
    public Value[] next() {
        return this.sort != null ? this.nextSorted() : this.nextUnsorted();
    }

    private Value[] nextUnsorted() {
        this.file.seek(this.mainTape.pos);
        if (this.mainTape.buffer.size() == 0) {
            for (int i = 0; this.mainTape.pos < this.mainTape.end && i < 128; ++i) {
                this.readRow(this.mainTape);
            }
        }
        Value[] valueArray = this.mainTape.buffer.get(0);
        this.mainTape.buffer.remove(0);
        return valueArray;
    }

    private Value[] nextSorted() {
        int n = -1;
        int n2 = this.tapes.size();
        for (int i = 0; i < n2; ++i) {
            ResultDiskTape resultDiskTape = this.tapes.get(i);
            if (resultDiskTape.buffer.size() == 0 && resultDiskTape.pos < resultDiskTape.end) {
                this.file.seek(resultDiskTape.pos);
                for (int j = 0; resultDiskTape.pos < resultDiskTape.end && j < 128; ++j) {
                    this.readRow(resultDiskTape);
                }
            }
            if (resultDiskTape.buffer.size() <= 0) continue;
            if (n == -1) {
                n = i;
                continue;
            }
            if (this.compareTapes(resultDiskTape, this.tapes.get(n)) >= 0) continue;
            n = i;
        }
        ResultDiskTape resultDiskTape = this.tapes.get(n);
        Value[] valueArray = resultDiskTape.buffer.get(0);
        resultDiskTape.buffer.remove(0);
        return valueArray;
    }

    private int compareTapes(ResultDiskTape resultDiskTape, ResultDiskTape resultDiskTape2) {
        Value[] valueArray = resultDiskTape.buffer.get(0);
        Value[] valueArray2 = resultDiskTape2.buffer.get(0);
        return this.sort.compare(valueArray, valueArray2);
    }

    protected void finalize() {
        if (!SysProperties.runFinalize) {
            return;
        }
        this.close();
    }

    @Override
    public void close() {
        if (this.file != null) {
            this.file.closeAndDeleteSilently();
            this.file = null;
        }
    }

    @Override
    public int removeRow(Value[] valueArray) {
        throw DbException.throwInternalError();
    }

    @Override
    public boolean contains(Value[] valueArray) {
        throw DbException.throwInternalError();
    }

    @Override
    public int addRow(Value[] valueArray) {
        throw DbException.throwInternalError();
    }

    static class ResultDiskTape {
        long start;
        long end;
        long pos;
        ArrayList<Value[]> buffer = New.arrayList();

        ResultDiskTape() {
        }
    }
}

