/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.zip.CRC32;
import org.h2.command.ddl.CreateTableData;
import org.h2.constant.SysProperties;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.MultiVersionIndex;
import org.h2.index.PageBtreeIndex;
import org.h2.index.PageBtreeLeaf;
import org.h2.index.PageBtreeNode;
import org.h2.index.PageDataIndex;
import org.h2.index.PageDataLeaf;
import org.h2.index.PageDataNode;
import org.h2.index.PageDataOverflow;
import org.h2.index.PageDelegateIndex;
import org.h2.index.PageIndex;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.schema.Schema;
import org.h2.store.Data;
import org.h2.store.DataHandler;
import org.h2.store.FileStore;
import org.h2.store.InDoubtTransaction;
import org.h2.store.Page;
import org.h2.store.PageFreeList;
import org.h2.store.PageLog;
import org.h2.store.PageStreamData;
import org.h2.store.PageStreamTrunk;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableData;
import org.h2.util.Cache;
import org.h2.util.CacheLRU;
import org.h2.util.CacheObject;
import org.h2.util.CacheWriter;
import org.h2.util.IOUtils;
import org.h2.util.IntArray;
import org.h2.util.IntIntHashMap;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.ValueInt;
import org.h2.value.ValueString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageStore
implements CacheWriter {
    public static final int PAGE_SIZE_MIN = 64;
    public static final int PAGE_SIZE_MAX = 32768;
    private static final int PAGE_ID_FREE_LIST_ROOT = 3;
    private static final int PAGE_ID_META_ROOT = 4;
    private static final int MIN_PAGE_COUNT = 6;
    private static final int INCREMENT_PAGES = 128;
    private static final int READ_VERSION = 3;
    private static final int WRITE_VERSION = 3;
    private static final int META_TYPE_SCAN_INDEX = 0;
    private static final int META_TYPE_BTREE_INDEX = 1;
    private static final int META_TABLE_ID = -1;
    private static final SearchRow[] EMPTY_SEARCH_ROW = new SearchRow[0];
    private Database database;
    private final Trace trace;
    private String fileName;
    private FileStore file;
    private String accessMode;
    private int pageSize;
    private int pageSizeShift;
    private long writeCountBase;
    private long writeCount;
    private long readCount;
    private int logKey;
    private int logFirstTrunkPage;
    private int logFirstDataPage;
    private Cache cache;
    private int freeListPagesPerList;
    private boolean recoveryRunning;
    private long fileLength;
    private int pageCount;
    private PageLog log;
    private Schema metaSchema;
    private TableData metaTable;
    private PageDataIndex metaIndex;
    private IntIntHashMap metaRootPageId = new IntIntHashMap();
    private HashMap<Integer, PageIndex> metaObjects = New.hashMap();
    private HashMap<Integer, Integer> reservedPages;
    private boolean isNew;
    private long maxLogSize = 0x333333L;
    private Session systemSession;
    private BitSet freed = new BitSet();
    private ArrayList<PageFreeList> freeLists = New.arrayList();
    private int changeCount = 1;
    private Data emptyPage;

    public PageStore(Database database, String string, String string2, int n) {
        this.fileName = string;
        this.accessMode = string2;
        this.database = database;
        this.trace = database.getTrace("pageStore");
        String string3 = database.getCacheType();
        this.cache = CacheLRU.getCache(this, string3, n);
        this.systemSession = new Session(database, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int copyDirect(int n, OutputStream outputStream) throws IOException {
        Database database = this.database;
        synchronized (database) {
            byte[] byArray = new byte[this.pageSize];
            if (n >= this.pageCount) {
                return -1;
            }
            this.file.seek((long)n << this.pageSizeShift);
            this.file.readFullyDirect(byArray, 0, this.pageSize);
            ++this.readCount;
            outputStream.write(byArray, 0, this.pageSize);
            return n + 1;
        }
    }

    public void open() {
        try {
            this.metaRootPageId.put(-1, 4);
            if (IOUtils.exists(this.fileName)) {
                if (IOUtils.length(this.fileName) < 384L) {
                    this.openNew();
                } else {
                    this.openExisting();
                }
            } else {
                this.openNew();
            }
        }
        catch (DbException dbException) {
            this.close();
            throw dbException;
        }
    }

    private void openNew() {
        this.setPageSize(SysProperties.PAGE_SIZE);
        this.freeListPagesPerList = PageFreeList.getPagesAddressed(this.pageSize);
        this.file = this.database.openFile(this.fileName, this.accessMode, false);
        this.recoveryRunning = true;
        this.writeStaticHeader();
        this.writeVariableHeader();
        this.log = new PageLog(this);
        this.increaseFileSize(6);
        this.openMetaIndex();
        this.logFirstTrunkPage = this.allocatePage();
        this.log.openForWriting(this.logFirstTrunkPage, false);
        this.isNew = true;
        this.recoveryRunning = false;
        this.increaseFileSize(128);
    }

    private void openExisting() {
        this.file = this.database.openFile(this.fileName, this.accessMode, true);
        this.readStaticHeader();
        this.freeListPagesPerList = PageFreeList.getPagesAddressed(this.pageSize);
        this.fileLength = this.file.length();
        this.pageCount = (int)(this.fileLength / (long)this.pageSize);
        if (this.pageCount < 6) {
            this.close();
            this.openNew();
            return;
        }
        this.readVariableHeader();
        this.log = new PageLog(this);
        this.log.openForReading(this.logKey, this.logFirstTrunkPage, this.logFirstDataPage);
        this.recover();
        if (!this.database.isReadOnly()) {
            this.recoveryRunning = true;
            this.log.free();
            this.logFirstTrunkPage = this.allocatePage();
            this.log.openForWriting(this.logFirstTrunkPage, false);
            this.recoveryRunning = false;
            this.checkpoint();
        }
    }

    private void writeIndexRowCounts() {
        for (PageIndex pageIndex : this.metaObjects.values()) {
            pageIndex.writeRowCount();
        }
    }

    private void writeBack() {
        ArrayList<CacheObject> arrayList = this.cache.getAllChanged();
        Collections.sort(arrayList);
        for (CacheObject cacheObject : arrayList) {
            this.writeBack(cacheObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkpoint() {
        this.trace.debug("checkpoint");
        if (this.log == null || this.database.isReadOnly()) {
            return;
        }
        Database database = this.database;
        synchronized (database) {
            this.database.checkPowerOff();
            this.writeIndexRowCounts();
            this.writeBack();
            this.log.checkpoint();
            this.switchLog();
            this.writeBack();
            byte[] byArray = new byte[this.pageSize];
            for (int i = 3; i < this.pageCount; ++i) {
                if (this.isUsed(i)) {
                    this.freed.clear(i);
                    continue;
                }
                if (this.freed.get(i)) continue;
                if (this.trace.isDebugEnabled()) {
                    this.trace.debug("free " + i);
                }
                this.freed.set(i);
                this.file.seek((long)i << this.pageSizeShift);
                this.file.write(byArray, 0, this.pageSize);
                ++this.writeCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compact(boolean bl) {
        if (!SysProperties.PAGE_STORE_TRIM) {
            return;
        }
        int n = -1;
        for (int i = this.getFreeListId(this.pageCount); i >= 0 && (n = this.getFreeList(i).getLastUsed()) == -1; --i) {
        }
        this.writeBack();
        this.recoveryRunning = true;
        try {
            this.log.free();
            this.logFirstTrunkPage = n + 1;
            this.allocatePage(this.logFirstTrunkPage);
            this.log.openForWriting(this.logFirstTrunkPage, true);
        }
        finally {
            this.recoveryRunning = false;
        }
        long l = System.currentTimeMillis();
        int n2 = SysProperties.MAX_COMPACT_TIME;
        int n3 = SysProperties.MAX_COMPACT_COUNT;
        if (bl) {
            n2 = Integer.MAX_VALUE;
            n3 = Integer.MAX_VALUE;
        }
        int n4 = n;
        for (int i = 0; n4 > 6 && i < n3; --n4, ++i) {
            this.compact(n4);
            long l2 = System.currentTimeMillis();
            if (l2 > l + (long)n2) break;
        }
        this.writeIndexRowCounts();
        this.writeBack();
        this.recoveryRunning = true;
        try {
            this.log.free();
            this.setLogFirstPage(0, 0, 0);
        }
        finally {
            this.recoveryRunning = false;
        }
        this.writeBack();
        for (n4 = this.getFreeListId(this.pageCount); n4 >= 0 && (n = this.getFreeList(n4).getLastUsed()) == -1; --n4) {
        }
        n4 = n + 1;
        if (n4 < this.pageCount) {
            this.freed.set(n4, this.pageCount, false);
        }
        this.pageCount = n4;
        this.freeLists.clear();
        this.trace.debug("pageCount:" + this.pageCount);
        long l3 = (long)this.pageCount << this.pageSizeShift;
        if (this.file.length() != l3) {
            this.file.setLength(l3);
            ++this.writeCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compact(int n) {
        int n2 = -1;
        for (int i = 0; i < this.pageCount && (n2 = this.getFreeList(i).getFirstFree()) == -1; ++i) {
        }
        if (n2 == -1 || n2 >= n) {
            return;
        }
        Page page = (Page)this.cache.get(n2);
        if (page != null) {
            DbException.throwInternalError("not free: " + page);
        }
        if (this.isUsed(n)) {
            Page page2 = this.getPage(n);
            if (page2 != null) {
                this.trace.debug("move " + page2.getPos() + " to " + n2);
                long l = this.log.getLogSectionId();
                long l2 = this.log.getLogPos();
                try {
                    page2.moveTo(this.systemSession, n2);
                }
                finally {
                    ++this.changeCount;
                }
                if ((long)this.log.getLogSectionId() == l || this.log.getLogPos() != l2) {
                    this.commit(this.systemSession);
                }
            } else {
                this.freePage(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page getPage(int n) {
        Page page;
        Object object = this.database;
        synchronized (object) {
            Page page2 = (Page)this.cache.find(n);
            if (page2 != null) {
                return page2;
            }
        }
        object = this.createData();
        this.readPage(n, (Data)object);
        int n2 = ((Data)object).readByte();
        if (n2 == 0) {
            return null;
        }
        ((Data)object).readShortInt();
        ((Data)object).readInt();
        if (!PageStore.checksumTest(((Data)object).getBytes(), n, this.pageSize)) {
            throw DbException.get(90030, "wrong checksum");
        }
        switch (n2 & 0xFFFFFFEF) {
            case 6: {
                page = PageFreeList.read(this, (Data)object, n);
                break;
            }
            case 1: {
                int n3 = ((Data)object).readVarInt();
                PageDataIndex pageDataIndex = (PageDataIndex)this.metaObjects.get(n3);
                if (pageDataIndex == null) {
                    throw DbException.get(90030, "index not found " + n3);
                }
                page = PageDataLeaf.read(pageDataIndex, (Data)object, n);
                break;
            }
            case 2: {
                int n4 = ((Data)object).readVarInt();
                PageDataIndex pageDataIndex = (PageDataIndex)this.metaObjects.get(n4);
                if (pageDataIndex == null) {
                    throw DbException.get(90030, "index not found " + n4);
                }
                page = PageDataNode.read(pageDataIndex, (Data)object, n);
                break;
            }
            case 3: {
                page = PageDataOverflow.read(this, (Data)object, n);
                break;
            }
            case 4: {
                int n5 = ((Data)object).readVarInt();
                PageBtreeIndex pageBtreeIndex = (PageBtreeIndex)this.metaObjects.get(n5);
                if (pageBtreeIndex == null) {
                    throw DbException.get(90030, "index not found " + n5);
                }
                page = PageBtreeLeaf.read(pageBtreeIndex, (Data)object, n);
                break;
            }
            case 5: {
                int n6 = ((Data)object).readVarInt();
                PageBtreeIndex pageBtreeIndex = (PageBtreeIndex)this.metaObjects.get(n6);
                if (pageBtreeIndex == null) {
                    throw DbException.get(90030, "index not found " + n6);
                }
                page = PageBtreeNode.read(pageBtreeIndex, (Data)object, n);
                break;
            }
            case 7: {
                page = PageStreamTrunk.read(this, (Data)object, n);
                break;
            }
            case 8: {
                page = PageStreamData.read(this, (Data)object, n);
                break;
            }
            default: {
                throw DbException.get(90030, "page=" + n + " type=" + n2);
            }
        }
        this.cache.put(page);
        return page;
    }

    private void switchLog() {
        this.trace.debug("switchLog");
        Session[] sessionArray = this.database.getSessions(true);
        int n = this.log.getLogSectionId();
        for (int i = 0; i < sessionArray.length; ++i) {
            Session session = sessionArray[i];
            int n2 = session.getFirstUncommittedLog();
            if (n2 == -1 || n2 >= n) continue;
            n = n2;
        }
        this.log.removeUntil(n);
    }

    private void readStaticHeader() {
        this.file.seek(48L);
        Data data = Data.create((DataHandler)this.database, new byte[16]);
        this.file.readFully(data.getBytes(), 0, 16);
        ++this.readCount;
        this.setPageSize(data.readInt());
        int n = data.readByte();
        int n2 = data.readByte();
        if (n2 > 3) {
            throw DbException.get(90048, this.fileName);
        }
        if (n > 3) {
            this.close();
            this.database.setReadOnly(true);
            this.accessMode = "r";
            this.file = this.database.openFile(this.fileName, this.accessMode, true);
        }
    }

    private void readVariableHeader() {
        Data data = this.createData();
        int n = 1;
        while (true) {
            if (n == 3) {
                throw DbException.get(90030, this.fileName);
            }
            data.reset();
            this.readPage(n, data);
            CRC32 cRC32 = new CRC32();
            cRC32.update(data.getBytes(), 4, this.pageSize - 4);
            int n2 = (int)cRC32.getValue();
            int n3 = data.readInt();
            if (n2 == n3) break;
            ++n;
        }
        this.writeCountBase = data.readLong();
        this.logKey = data.readInt();
        this.logFirstTrunkPage = data.readInt();
        this.logFirstDataPage = data.readInt();
    }

    private void setPageSize(int n) {
        if (n < 64 || n > 32768) {
            throw DbException.get(90030, this.fileName);
        }
        boolean bl = false;
        int n2 = 0;
        for (int i = 1; i <= n; i += i) {
            if (n == i) {
                bl = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            throw DbException.get(90030, this.fileName);
        }
        this.pageSize = n;
        this.emptyPage = this.createData();
        this.pageSizeShift = n2;
    }

    private void writeStaticHeader() {
        Data data = Data.create((DataHandler)this.database, new byte[this.pageSize - 48]);
        data.writeInt(this.pageSize);
        data.writeByte((byte)3);
        data.writeByte((byte)3);
        this.file.seek(48L);
        this.file.write(data.getBytes(), 0, this.pageSize - 48);
        ++this.writeCount;
    }

    void setLogFirstPage(int n, int n2, int n3) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("setLogFirstPage key: " + n + " trunk: " + n2 + " data: " + n3);
        }
        this.logKey = n;
        this.logFirstTrunkPage = n2;
        this.logFirstDataPage = n3;
        this.writeVariableHeader();
    }

    private void writeVariableHeader() {
        Data data = this.createData();
        data.writeInt(0);
        data.writeLong(this.getWriteCountTotal());
        data.writeInt(this.logKey);
        data.writeInt(this.logFirstTrunkPage);
        data.writeInt(this.logFirstDataPage);
        CRC32 cRC32 = new CRC32();
        cRC32.update(data.getBytes(), 4, this.pageSize - 4);
        data.setInt(0, (int)cRC32.getValue());
        this.file.seek(this.pageSize);
        this.file.write(data.getBytes(), 0, this.pageSize);
        this.file.seek(this.pageSize + this.pageSize);
        this.file.write(data.getBytes(), 0, this.pageSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.trace.debug("close");
        if (this.log != null) {
            this.log.close();
            this.log = null;
        }
        if (this.file != null) {
            try {
                this.file.close();
            }
            finally {
                this.file = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushLog() {
        if (this.file != null) {
            Database database = this.database;
            synchronized (database) {
                this.log.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() {
        if (this.file != null) {
            Database database = this.database;
            synchronized (database) {
                this.log.flush();
                this.file.sync();
            }
        }
    }

    @Override
    public Trace getTrace() {
        return this.trace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeBack(CacheObject cacheObject) {
        Database database = this.database;
        synchronized (database) {
            Page page = (Page)cacheObject;
            if (this.trace.isDebugEnabled()) {
                this.trace.debug("writeBack " + page);
            }
            page.write();
            page.setChanged(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logUndo(Page page, Data data) {
        Database database = this.database;
        synchronized (database) {
            int n;
            if (this.trace.isDebugEnabled()) {
                // empty if block
            }
            this.checkOpen();
            this.database.checkWritingAllowed();
            if (!this.recoveryRunning && !this.log.getUndo(n = page.getPos())) {
                if (data == null) {
                    data = this.readPage(n);
                }
                this.log.addUndo(n, data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Page page) {
        Database database = this.database;
        synchronized (database) {
            if (this.trace.isDebugEnabled() && !page.isChanged()) {
                this.trace.debug("updateRecord " + page.toString());
            }
            this.checkOpen();
            this.database.checkWritingAllowed();
            page.setChanged(true);
            int n = page.getPos();
            if (SysProperties.CHECK && !this.recoveryRunning) {
                this.log.addUndo(n, null);
            }
            this.allocatePage(n);
            this.cache.update(n, page);
        }
    }

    private int getFreeListId(int n) {
        return (n - 3) / this.freeListPagesPerList;
    }

    private PageFreeList getFreeListForPage(int n) {
        return this.getFreeList(this.getFreeListId(n));
    }

    private PageFreeList getFreeList(int n) {
        PageFreeList pageFreeList = null;
        if (n < this.freeLists.size() && (pageFreeList = this.freeLists.get(n)) != null) {
            return pageFreeList;
        }
        int n2 = 3 + n * this.freeListPagesPerList;
        while (n2 >= this.pageCount) {
            this.increaseFileSize(128);
        }
        if (n2 < this.pageCount) {
            pageFreeList = (PageFreeList)this.getPage(n2);
        }
        if (pageFreeList == null) {
            pageFreeList = PageFreeList.create(this, n2);
            this.cache.put(pageFreeList);
        }
        while (this.freeLists.size() <= n) {
            this.freeLists.add(null);
        }
        this.freeLists.set(n, pageFreeList);
        return pageFreeList;
    }

    private void freePage(int n) {
        PageFreeList pageFreeList = this.getFreeListForPage(n);
        pageFreeList.free(n);
    }

    void allocatePage(int n) {
        PageFreeList pageFreeList = this.getFreeListForPage(n);
        pageFreeList.allocate(n);
    }

    private boolean isUsed(int n) {
        return this.getFreeListForPage(n).isUsed(n);
    }

    void allocatePages(IntArray intArray, int n, BitSet bitSet, int n2) {
        for (int i = 0; i < n; ++i) {
            int n3;
            n2 = n3 = this.allocatePage(bitSet, n2);
            intArray.add(n3);
        }
    }

    public int allocatePage() {
        int n = this.allocatePage(null, 0);
        if (!this.recoveryRunning) {
            this.log.addUndo(n, this.emptyPage);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int allocatePage(BitSet bitSet, int n) {
        Database database = this.database;
        synchronized (database) {
            PageFreeList pageFreeList;
            int n2;
            int n3 = 0;
            while ((n2 = (pageFreeList = this.getFreeList(n3)).allocate(bitSet, n)) < 0) {
                ++n3;
            }
            if (n2 >= this.pageCount) {
                this.increaseFileSize(128);
            }
            if (this.trace.isDebugEnabled()) {
                // empty if block
            }
            return n2;
        }
    }

    private void increaseFileSize(int n) {
        for (int i = this.pageCount; i < this.pageCount + n; ++i) {
            this.freed.set(i);
        }
        this.pageCount += n;
        long l = (long)this.pageCount << this.pageSizeShift;
        this.file.setLength(l);
        ++this.writeCount;
        this.fileLength = l;
    }

    public void free(int n) {
        this.free(n, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void free(int n, boolean bl) {
        if (this.trace.isDebugEnabled()) {
            // empty if block
        }
        Database database = this.database;
        synchronized (database) {
            this.cache.remove(n);
            if (SysProperties.CHECK && !this.recoveryRunning && bl) {
                this.log.addUndo(n, null);
            }
            this.freePage(n);
            if (this.recoveryRunning) {
                this.writePage(n, this.createData());
            }
        }
    }

    public Data createData() {
        return Data.create((DataHandler)this.database, new byte[this.pageSize]);
    }

    public Data readPage(int n) {
        Data data = this.createData();
        this.readPage(n, data);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readPage(int n, Data data) {
        Database database = this.database;
        synchronized (database) {
            if (n < 0 || n >= this.pageCount) {
                throw DbException.get(90030, n + " of " + this.pageCount);
            }
            this.file.seek((long)n << this.pageSizeShift);
            this.file.readFully(data.getBytes(), 0, this.pageSize);
            ++this.readCount;
        }
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePage(int n, Data data) {
        if (n <= 0) {
            DbException.throwInternalError("write to page " + n);
        }
        byte[] byArray = data.getBytes();
        if (SysProperties.CHECK) {
            boolean bl;
            boolean bl2 = (n - 3) % this.freeListPagesPerList == 0;
            boolean bl3 = bl = byArray[0] == 6;
            if (byArray[0] != 0 && bl2 != bl) {
                throw DbException.throwInternalError();
            }
        }
        this.checksumSet(byArray, n);
        Database database = this.database;
        synchronized (database) {
            this.file.seek((long)n << this.pageSizeShift);
            this.file.write(byArray, 0, this.pageSize);
            ++this.writeCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRecord(int n) {
        Database database = this.database;
        synchronized (database) {
            this.cache.remove(n);
        }
    }

    Database getDatabase() {
        return this.database;
    }

    private void recover() {
        PageDataIndex pageDataIndex;
        this.trace.debug("log recover");
        this.recoveryRunning = true;
        this.log.recover(0);
        if (this.reservedPages != null) {
            for (int n : this.reservedPages.keySet()) {
                if (this.trace.isDebugEnabled()) {
                    this.trace.debug("reserve " + n);
                }
                this.allocatePage(n);
            }
        }
        this.log.recover(1);
        this.openMetaIndex();
        this.readMetaData();
        this.log.recover(2);
        boolean bl = false;
        if (!this.database.isReadOnly()) {
            if (this.log.getInDoubtTransactions().size() == 0) {
                this.log.recoverEnd();
                this.switchLog();
            } else {
                bl = true;
            }
        }
        this.isNew = (pageDataIndex = (PageDataIndex)this.metaObjects.get(0)) == null;
        Iterator<PageIndex> iterator = this.metaObjects.values().iterator();
        while (iterator.hasNext()) {
            Index index = iterator.next();
            if (index.getTable().isTemporary()) {
                index.truncate(this.systemSession);
                index.remove(this.systemSession);
                this.removeMetaIndex(index, this.systemSession);
                iterator.remove();
                continue;
            }
            index.close(this.systemSession);
        }
        this.allocatePage(4);
        this.writeIndexRowCounts();
        this.recoveryRunning = false;
        this.reservedPages = null;
        this.writeBack();
        this.cache.clear();
        this.freeLists.clear();
        this.metaObjects.clear();
        this.metaObjects.put(-1, this.metaIndex);
        if (bl) {
            this.database.setReadOnly(true);
        }
        this.trace.debug("log recover done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logAddOrRemoveRow(Session session, int n, Row row, boolean bl) {
        Database database = this.database;
        synchronized (database) {
            if (!this.recoveryRunning) {
                this.log.logAddOrRemoveRow(session, n, row, bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Session session) {
        Database database = this.database;
        synchronized (database) {
            this.checkOpen();
            this.log.commit(session.getId());
            if (this.log.getSize() > this.maxLogSize) {
                this.checkpoint();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareCommit(Session session, String string) {
        Database database = this.database;
        synchronized (database) {
            this.log.prepareCommit(session, string);
        }
    }

    public boolean isNew() {
        return this.isNew;
    }

    void allocateIfIndexRoot(int n, int n2, Row row) {
        if (n2 == -1) {
            int n3 = row.getValue(3).getInt();
            if (this.reservedPages == null) {
                this.reservedPages = New.hashMap();
            }
            this.reservedPages.put(n3, n);
        }
    }

    void redoDelete(int n, int n2, long l) {
        Index index = this.metaObjects.get(n2);
        PageDataIndex pageDataIndex = (PageDataIndex)index;
        Row row = pageDataIndex.getRow(l);
        this.redo(n, n2, row, false);
    }

    void redo(int n, int n2, Row row, boolean bl) {
        Index index;
        if (n2 == -1) {
            if (bl) {
                this.addMeta(row, this.systemSession, true);
            } else {
                this.removeMeta(n, row);
            }
        }
        if ((index = (Index)this.metaObjects.get(n2)) == null) {
            throw DbException.throwInternalError("Table not found: " + n2 + " " + row + " " + bl);
        }
        Table table = index.getTable();
        if (bl) {
            table.addRow(this.systemSession, row);
        } else {
            table.removeRow(this.systemSession, row);
        }
    }

    void redoTruncate(int n) {
        Index index = this.metaObjects.get(n);
        Table table = index.getTable();
        table.truncate(this.systemSession);
    }

    private void openMetaIndex() {
        CreateTableData createTableData = new CreateTableData();
        ArrayList<Column> arrayList = createTableData.columns;
        arrayList.add(new Column("ID", 4));
        arrayList.add(new Column("TYPE", 4));
        arrayList.add(new Column("PARENT", 4));
        arrayList.add(new Column("HEAD", 4));
        arrayList.add(new Column("OPTIONS", 13));
        arrayList.add(new Column("COLUMNS", 13));
        createTableData.schema = this.metaSchema = new Schema(this.database, 0, "", null, true);
        createTableData.tableName = "PAGE_INDEX";
        createTableData.id = -1;
        createTableData.temporary = false;
        createTableData.persistData = true;
        createTableData.persistIndexes = true;
        createTableData.create = false;
        createTableData.session = this.systemSession;
        this.metaTable = new TableData(createTableData);
        this.metaIndex = (PageDataIndex)this.metaTable.getScanIndex(this.systemSession);
        this.metaObjects.clear();
        this.metaObjects.put(-1, this.metaIndex);
    }

    private void readMetaData() {
        Cursor cursor = this.metaIndex.find(this.systemSession, null, null);
        while (cursor.next()) {
            Row row = cursor.get();
            this.addMeta(row, this.systemSession, false);
        }
    }

    private void removeMeta(int n, Row row) {
        int n2;
        int n3 = row.getValue(0).getInt();
        PageIndex pageIndex = this.metaObjects.get(n3);
        int n4 = pageIndex.getRootPageId();
        pageIndex.getTable().removeIndex(pageIndex);
        if (pageIndex instanceof PageBtreeIndex) {
            if (pageIndex.isTemporary()) {
                this.systemSession.removeLocalTempTableIndex(pageIndex);
            } else {
                pageIndex.getSchema().remove(pageIndex);
            }
        } else if (pageIndex instanceof PageDelegateIndex) {
            pageIndex.getSchema().remove(pageIndex);
        }
        pageIndex.remove(this.systemSession);
        this.metaObjects.remove(n3);
        if (this.reservedPages != null && this.reservedPages.containsKey(n4) && (n2 = this.reservedPages.get(n4).intValue()) > n) {
            this.allocatePage(n4);
        }
    }

    private void addMeta(Row row, Session session, boolean bl) {
        Index index;
        Object object;
        int n = row.getValue(0).getInt();
        int n2 = row.getValue(1).getInt();
        int n3 = row.getValue(2).getInt();
        int n4 = row.getValue(3).getInt();
        String string = row.getValue(4).getString();
        String string2 = row.getValue(5).getString();
        String[] stringArray = StringUtils.arraySplit(string2, ',', false);
        String[] stringArray2 = StringUtils.arraySplit(string, ',', false);
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("addMeta id=" + n + " type=" + n2 + " parent=" + n3 + " columns=" + string2);
        }
        if (bl && n4 != 0) {
            this.writePage(n4, this.createData());
            this.allocatePage(n4);
        }
        this.metaRootPageId.put(n, n4);
        if (n2 == 0) {
            Object object2;
            object = new CreateTableData();
            for (int i = 0; i < stringArray.length; ++i) {
                object2 = new Column("C" + i, 4);
                ((CreateTableData)object).columns.add((Column)object2);
            }
            ((CreateTableData)object).schema = this.metaSchema;
            ((CreateTableData)object).tableName = "T" + n;
            ((CreateTableData)object).id = n;
            ((CreateTableData)object).temporary = stringArray2[2].equals("temp");
            ((CreateTableData)object).persistData = true;
            ((CreateTableData)object).persistIndexes = true;
            ((CreateTableData)object).create = false;
            ((CreateTableData)object).session = session;
            TableData tableData = new TableData((CreateTableData)object);
            object2 = CompareMode.getInstance(stringArray2[0], Integer.parseInt(stringArray2[1]));
            tableData.setCompareMode((CompareMode)object2);
            index = tableData.getScanIndex(session);
        } else {
            IndexType indexType;
            Object object3;
            object = this.metaObjects.get(n3);
            if (object == null) {
                throw DbException.get(90030, "Table not found:" + n3 + " for " + row + " meta:" + this.metaObjects);
            }
            TableData tableData = (TableData)object.getTable();
            Column[] columnArray = tableData.getColumns();
            IndexColumn[] indexColumnArray = new IndexColumn[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                Object object4;
                object3 = stringArray[i];
                IndexColumn indexColumn = new IndexColumn();
                int n5 = object3.indexOf(47);
                if (n5 >= 0) {
                    object4 = object3.substring(n5 + 1);
                    indexColumn.sortType = Integer.parseInt((String)object4);
                    object3 = object3.substring(0, n5);
                }
                indexColumn.column = object4 = columnArray[Integer.parseInt((String)object3)];
                indexColumnArray[i] = indexColumn;
            }
            if (stringArray2[3].equals("d")) {
                indexType = IndexType.createPrimaryKey(true, false);
                object3 = tableData.getColumns();
                for (int i = 0; i < indexColumnArray.length; ++i) {
                    object3[indexColumnArray[i].column.getColumnId()].setNullable(false);
                }
            } else {
                indexType = IndexType.createNonUnique(true);
            }
            index = tableData.addIndex(session, "I" + n, n, indexColumnArray, indexType, false, null);
        }
        object = index instanceof MultiVersionIndex ? (PageIndex)((MultiVersionIndex)index).getBaseIndex() : (PageIndex)index;
        this.metaObjects.put(n, (PageIndex)object);
    }

    public void addIndex(PageIndex pageIndex) {
        this.metaObjects.put(pageIndex.getId(), pageIndex);
    }

    /*
     * WARNING - void declaration
     */
    public void addMeta(PageIndex pageIndex, Session session) {
        void var9_18;
        void var9_15;
        int n = pageIndex instanceof PageDataIndex ? 0 : 1;
        IndexColumn[] indexColumnArray = pageIndex.getIndexColumns();
        StatementBuilder statementBuilder = new StatementBuilder();
        for (IndexColumn indexColumn : indexColumnArray) {
            statementBuilder.appendExceptFirst(",");
            int n2 = indexColumn.column.getColumnId();
            statementBuilder.append(n2);
            int n3 = indexColumn.sortType;
            if (n3 == 0) continue;
            statementBuilder.append('/');
            statementBuilder.append(n3);
        }
        String string = statementBuilder.toString();
        Table table = pageIndex.getTable();
        CompareMode compareMode = table.getCompareMode();
        String string2 = compareMode.getName() + "," + compareMode.getStrength() + ",";
        if (table.isTemporary()) {
            String string3 = string2 + "temp";
        }
        String string4 = (String)var9_15 + ",";
        if (pageIndex instanceof PageDelegateIndex) {
            String string5 = string4 + "d";
        }
        Row row = this.metaTable.getTemplateRow();
        row.setValue(0, ValueInt.get(pageIndex.getId()));
        row.setValue(1, ValueInt.get(n));
        row.setValue(2, ValueInt.get(table.getId()));
        row.setValue(3, ValueInt.get(pageIndex.getRootPageId()));
        row.setValue(4, ValueString.get((String)var9_18));
        row.setValue(5, ValueString.get(string));
        row.setKey(pageIndex.getId() + 1);
        this.metaIndex.add(session, row);
    }

    public void removeMeta(Index index, Session session) {
        if (!this.recoveryRunning) {
            this.removeMetaIndex(index, session);
            this.metaObjects.remove(index.getId());
        }
    }

    private void removeMetaIndex(Index index, Session session) {
        int n = index.getId() + 1;
        Row row = this.metaIndex.getRow(session, n);
        if (row.getKey() != (long)n) {
            DbException.throwInternalError();
        }
        this.metaIndex.remove(session, row);
    }

    public void setMaxLogSize(long l) {
        this.maxLogSize = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInDoubtTransactionState(int n, int n2, boolean bl) {
        boolean bl2 = this.database.isReadOnly();
        try {
            this.database.setReadOnly(false);
            this.log.setInDoubtTransactionState(n, n2, bl);
        }
        finally {
            this.database.setReadOnly(bl2);
        }
    }

    public ArrayList<InDoubtTransaction> getInDoubtTransactions() {
        return this.log.getInDoubtTransactions();
    }

    public boolean isRecoveryRunning() {
        return this.recoveryRunning;
    }

    private void checkOpen() {
        if (this.file == null) {
            throw DbException.get(90098);
        }
    }

    public static SearchRow[] newSearchRows(int n) {
        if (n == 0) {
            return EMPTY_SEARCH_ROW;
        }
        return new SearchRow[n];
    }

    public long getWriteCountTotal() {
        return this.writeCount + this.writeCountBase;
    }

    public long getWriteCount() {
        return this.writeCount;
    }

    public long getReadCount() {
        return this.readCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logTruncate(Session session, int n) {
        Database database = this.database;
        synchronized (database) {
            if (!this.recoveryRunning) {
                this.log.logTruncate(session, n);
            }
        }
    }

    public int getRootPageId(int n) {
        return this.metaRootPageId.get(n);
    }

    public Cache getCache() {
        return this.cache;
    }

    private void checksumSet(byte[] byArray, int n) {
        int n2 = this.pageSize;
        byte by = byArray[0];
        if (by == 0) {
            return;
        }
        int n3 = 255 + (by & 0xFF);
        int n4 = 255 + n3;
        n4 += (n3 += byArray[6] & 0xFF);
        n4 += (n3 += byArray[(n2 >> 1) - 1] & 0xFF);
        n4 += (n3 += byArray[n2 >> 1] & 0xFF);
        n4 += (n3 += byArray[n2 - 2] & 0xFF);
        byArray[1] = (byte)((n3 & 0xFF) + (n3 >> 8) ^ n);
        byArray[2] = (byte)(((n4 += (n3 += byArray[n2 - 1] & 0xFF)) & 0xFF) + (n4 >> 8) ^ n >> 8);
    }

    public static boolean checksumTest(byte[] byArray, int n, int n2) {
        int n3 = n2;
        int n4 = 255 + (byArray[0] & 0xFF);
        int n5 = 255 + n4;
        n5 += (n4 += byArray[6] & 0xFF);
        n5 += (n4 += byArray[(n3 >> 1) - 1] & 0xFF);
        n5 += (n4 += byArray[n3 >> 1] & 0xFF);
        n5 += (n4 += byArray[n3 - 2] & 0xFF);
        return byArray[1] == (byte)((n4 & 0xFF) + (n4 >> 8) ^ n) && byArray[2] == (byte)(((n5 += (n4 += byArray[n3 - 1] & 0xFF)) & 0xFF) + (n5 >> 8) ^ n >> 8);
    }

    public void incrementChangeCount() {
        ++this.changeCount;
    }

    public int getChangeCount() {
        return this.changeCount;
    }
}

