/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.h2.command.CommandInterface;
import org.h2.engine.SessionInterface;
import org.h2.expression.ParameterInterface;
import org.h2.jdbc.JdbcBatchUpdateException;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbc.JdbcParameterMetaData;
import org.h2.jdbc.JdbcResultSet;
import org.h2.jdbc.JdbcResultSetMetaData;
import org.h2.jdbc.JdbcStatement;
import org.h2.message.Message;
import org.h2.result.ResultInterface;
import org.h2.util.DateTimeUtils;
import org.h2.util.IOUtils;
import org.h2.util.ObjectArray;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueInt;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;

public class JdbcPreparedStatement
extends JdbcStatement
implements PreparedStatement {
    private final String sql;
    private CommandInterface command;
    private ObjectArray<Value[]> batchParameters;

    JdbcPreparedStatement(JdbcConnection jdbcConnection, String string, int n, int n2, int n3, boolean bl) throws SQLException {
        super(jdbcConnection, n, n2, n3, bl);
        this.setTrace(this.session.getTrace(), 3, n);
        this.sql = string;
        this.command = jdbcConnection.prepareCommand(string, this.fetchSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery() throws SQLException {
        try {
            ResultInterface resultInterface;
            int n = this.getNextId(4);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("ResultSet", 4, n, "executeQuery()");
            }
            this.checkClosed();
            this.closeOldResultSet();
            boolean bl = this.resultSetType != 1003;
            boolean bl2 = this.resultSetConcurrency == 1008;
            SessionInterface sessionInterface = this.session;
            synchronized (sessionInterface) {
                try {
                    this.setExecutingStatement(this.command);
                    resultInterface = this.command.executeQuery(this.maxRows, bl);
                }
                finally {
                    this.setExecutingStatement(null);
                }
            }
            this.resultSet = new JdbcResultSet(this.conn, this, resultInterface, n, this.closedByResultSet, bl, bl2);
            return this.resultSet;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate() throws SQLException {
        int n;
        this.debugCodeCall("executeUpdate");
        this.checkClosedForWrite();
        try {
            n = this.executeUpdateInternal();
        }
        catch (Throwable throwable) {
            try {
                this.afterWriting();
                throw throwable;
            }
            catch (Exception exception) {
                throw this.logAndConvert(exception);
            }
        }
        this.afterWriting();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeUpdateInternal() throws SQLException {
        this.closeOldResultSet();
        SessionInterface sessionInterface = this.session;
        synchronized (sessionInterface) {
            try {
                this.setExecutingStatement(this.command);
                this.updateCount = this.command.executeUpdate();
            }
            finally {
                this.setExecutingStatement(null);
            }
        }
        return this.updateCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws SQLException {
        boolean bl;
        int n = this.getNextId(4);
        if (this.isDebugEnabled()) {
            this.debugCodeCall("execute");
        }
        this.checkClosedForWrite();
        try {
            boolean bl2;
            this.closeOldResultSet();
            SessionInterface sessionInterface = this.conn.getSession();
            synchronized (sessionInterface) {
                try {
                    this.setExecutingStatement(this.command);
                    if (this.command.isQuery()) {
                        bl2 = true;
                        boolean bl3 = this.resultSetType != 1003;
                        boolean bl4 = this.resultSetConcurrency == 1008;
                        ResultInterface resultInterface = this.command.executeQuery(this.maxRows, bl3);
                        this.resultSet = new JdbcResultSet(this.conn, this, resultInterface, n, this.closedByResultSet, bl3, bl4);
                    } else {
                        bl2 = false;
                        this.updateCount = this.command.executeUpdate();
                    }
                }
                finally {
                    this.setExecutingStatement(null);
                }
            }
            bl = bl2;
        }
        catch (Throwable throwable) {
            try {
                this.afterWriting();
                throw throwable;
            }
            catch (Exception exception) {
                throw this.logAndConvert(exception);
            }
        }
        this.afterWriting();
        return bl;
    }

    public void clearParameters() throws SQLException {
        try {
            this.debugCodeCall("clearParameters");
            this.checkClosed();
            ObjectArray<? extends ParameterInterface> objectArray = this.command.getParameters();
            for (ParameterInterface parameterInterface : objectArray) {
                parameterInterface.setValue(null, this.batchParameters == null);
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public ResultSet executeQuery(String string) throws SQLException {
        try {
            this.debugCodeCall("executeQuery", string);
            throw Message.getSQLException(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void addBatch(String string) throws SQLException {
        try {
            this.debugCodeCall("addBatch", string);
            throw Message.getSQLException(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int executeUpdate(String string) throws SQLException {
        try {
            this.debugCodeCall("executeUpdate", string);
            throw Message.getSQLException(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean execute(String string) throws SQLException {
        try {
            this.debugCodeCall("execute", string);
            throw Message.getSQLException(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setNull(int n, int n2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setNull(" + n + ", " + n2 + ");");
            }
            this.setParameter(n, ValueNull.INSTANCE);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setInt(int n, int n2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setInt(" + n + ", " + n2 + ");");
            }
            this.setParameter(n, ValueInt.get(n2));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setString(int n, String string) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setString(" + n + ", " + this.quote(string) + ");");
            }
            Value value = string == null ? ValueNull.INSTANCE : ValueString.get(string);
            this.setParameter(n, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBigDecimal(" + n + ", " + this.quoteBigDecimal(bigDecimal) + ");");
            }
            Value value = bigDecimal == null ? ValueNull.INSTANCE : ValueDecimal.get(bigDecimal);
            this.setParameter(n, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setDate(int n, Date date) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setDate(" + n + ", " + this.quoteDate(date) + ");");
            }
            Value value = date == null ? ValueNull.INSTANCE : ValueDate.get(date);
            this.setParameter(n, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setTime(int n, Time time) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setTime(" + n + ", " + this.quoteTime(time) + ");");
            }
            Value value = time == null ? ValueNull.INSTANCE : ValueTime.get(time);
            this.setParameter(n, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setTimestamp(" + n + ", " + this.quoteTimestamp(timestamp) + ");");
            }
            Value value = timestamp == null ? ValueNull.INSTANCE : ValueTimestamp.get(timestamp);
            this.setParameter(n, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setObject(int n, Object object) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setObject(" + n + ", x);");
            }
            if (object == null) {
                this.setParameter(n, ValueNull.INSTANCE);
            } else {
                this.setParameter(n, DataType.convertToValue(this.session, object, -1));
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setObject(" + n + ", x, " + n2 + ");");
            }
            int n3 = DataType.convertSQLTypeToValueType(n2);
            if (object == null) {
                this.setParameter(n, ValueNull.INSTANCE);
            } else {
                Value value = DataType.convertToValue(this.conn.getSession(), object, n3);
                this.setParameter(n, value.convertTo(n3));
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setObject(" + n + ", x, " + n2 + ", " + n3 + ");");
            }
            this.setObject(n, object, n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBoolean(" + n + ", " + bl + ");");
            }
            this.setParameter(n, ValueBoolean.get(bl));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setByte(int n, byte by) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setByte(" + n + ", " + by + ");");
            }
            this.setParameter(n, ValueByte.get(by));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setShort(int n, short s) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setShort(" + n + ", (short) " + s + ");");
            }
            this.setParameter(n, ValueShort.get(s));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setLong(int n, long l) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setLong(" + n + ", " + l + "L);");
            }
            this.setParameter(n, ValueLong.get(l));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setFloat(int n, float f) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setFloat(" + n + ", " + f + "f);");
            }
            this.setParameter(n, ValueFloat.get(f));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setDouble(int n, double d) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setDouble(" + n + ", " + d + "d);");
            }
            this.setParameter(n, ValueDouble.get(d));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setRef(int n, Ref ref) throws SQLException {
        try {
            this.debugCode("setRef(" + n + ", x);");
            throw Message.getUnsupportedException("ref");
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setDate(" + n + ", " + this.quoteDate(date) + ", calendar);");
            }
            if (date == null) {
                this.setParameter(n, ValueNull.INSTANCE);
            } else {
                this.setParameter(n, DateTimeUtils.convertDateToUniversal(date, calendar));
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setTime(" + n + ", " + this.quoteTime(time) + ", calendar);");
            }
            if (time == null) {
                this.setParameter(n, ValueNull.INSTANCE);
            } else {
                this.setParameter(n, DateTimeUtils.convertTimeToUniversal(time, calendar));
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setTimestamp(" + n + ", " + this.quoteTimestamp(timestamp) + ", calendar);");
            }
            if (timestamp == null) {
                this.setParameter(n, ValueNull.INSTANCE);
            } else {
                this.setParameter(n, DateTimeUtils.convertTimestampToUniversal(timestamp, calendar));
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            this.debugCode("setUnicodeStream(" + n + ", x, " + n2 + ");");
            throw Message.getUnsupportedException("unicodeStream");
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setNull(" + n + ", " + n2 + ", " + this.quote(string) + ");");
            }
            this.setNull(n, n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlob(int n, Blob blob) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBlob(" + n + ", x);");
            }
            this.checkClosedForWrite();
            try {
                Value value = blob == null ? ValueNull.INSTANCE : this.conn.createBlob(blob.getBinaryStream(), -1L);
                this.setParameter(n, value);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlob(int n, InputStream inputStream) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBlob(" + n + ", x);");
            }
            this.checkClosedForWrite();
            try {
                Value value = this.conn.createBlob(inputStream, -1L);
                this.setParameter(n, value);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClob(int n, Clob clob) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setClob(" + n + ", x);");
            }
            this.checkClosedForWrite();
            try {
                Value value = clob == null ? ValueNull.INSTANCE : this.conn.createClob(clob.getCharacterStream(), -1L);
                this.setParameter(n, value);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClob(int n, Reader reader) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setClob(" + n + ", x);");
            }
            this.checkClosedForWrite();
            try {
                Value value = reader == null ? ValueNull.INSTANCE : this.conn.createClob(reader, -1L);
                this.setParameter(n, value);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setArray(int n, Array array) throws SQLException {
        try {
            this.debugCode("setArray(" + n + ", x);");
            throw Message.getUnsupportedException("setArray");
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBytes(" + n + ", " + this.quoteBytes(byArray) + ");");
            }
            Value value = byArray == null ? ValueNull.INSTANCE : ValueBytes.get(byArray);
            this.setParameter(n, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBinaryStream(" + n + ", x, " + l + "L);");
            }
            this.checkClosedForWrite();
            try {
                Value value = this.conn.createBlob(inputStream, l);
                this.setParameter(n, value);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setBinaryStream(n, inputStream, (long)n2);
    }

    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        this.setBinaryStream(n, inputStream, -1);
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setAsciiStream(n, inputStream, (long)n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setAsciiStream(" + n + ", x, " + l + "L);");
            }
            this.checkClosedForWrite();
            try {
                Value value = this.conn.createClob(IOUtils.getAsciiReader(inputStream), l);
                this.setParameter(n, value);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        this.setAsciiStream(n, inputStream, -1);
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.setCharacterStream(n, reader, (long)n2);
    }

    public void setCharacterStream(int n, Reader reader) throws SQLException {
        this.setCharacterStream(n, reader, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setCharacterStream(" + n + ", x, " + l + "L);");
            }
            this.checkClosedForWrite();
            try {
                Value value = this.conn.createClob(reader, l);
                this.setParameter(n, value);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setURL(int n, URL uRL) throws SQLException {
        try {
            this.debugCode("setURL(" + n + ", x);");
            throw Message.getUnsupportedException("url");
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            this.debugCodeCall("getMetaData");
            this.checkClosed();
            ResultInterface resultInterface = this.command.getMetaData();
            if (resultInterface == null) {
                return null;
            }
            int n = this.getNextId(5);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("ResultSetMetaData", 5, n, "getMetaData()");
            }
            String string = this.conn.getCatalog();
            JdbcResultSetMetaData jdbcResultSetMetaData = new JdbcResultSetMetaData(null, this, resultInterface, string, this.session.getTrace(), n);
            return jdbcResultSetMetaData;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void clearBatch() throws SQLException {
        try {
            this.debugCodeCall("clearBatch");
            this.checkClosed();
            this.batchParameters = null;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void close() throws SQLException {
        try {
            super.close();
            this.batchParameters = null;
            if (this.command != null) {
                this.command.close();
                this.command = null;
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() throws SQLException {
        int[] nArray;
        this.debugCodeCall("executeBatch");
        if (this.batchParameters == null) {
            this.batchParameters = ObjectArray.newInstance();
        }
        int[] nArray2 = new int[this.batchParameters.size()];
        boolean bl = false;
        SQLException sQLException = null;
        this.checkClosedForWrite();
        try {
            for (int i = 0; i < this.batchParameters.size(); ++i) {
                Value[] valueArray = this.batchParameters.get(i);
                ObjectArray<? extends ParameterInterface> objectArray = this.command.getParameters();
                for (int j = 0; j < valueArray.length; ++j) {
                    Value value = valueArray[j];
                    ParameterInterface parameterInterface = objectArray.get(j);
                    parameterInterface.setValue(value, false);
                }
                try {
                    nArray2[i] = this.executeUpdateInternal();
                    continue;
                }
                catch (SQLException sQLException2) {
                    if (sQLException == null) {
                        sQLException = sQLException2;
                    } else {
                        sQLException2.setNextException(sQLException);
                        sQLException = sQLException2;
                    }
                    this.logAndConvert(sQLException2);
                    nArray2[i] = -3;
                    bl = true;
                }
            }
            this.batchParameters = null;
            if (bl) {
                JdbcBatchUpdateException jdbcBatchUpdateException = new JdbcBatchUpdateException(sQLException, nArray2);
                jdbcBatchUpdateException.setNextException(sQLException);
                throw jdbcBatchUpdateException;
            }
            nArray = nArray2;
        }
        catch (Throwable throwable) {
            try {
                this.afterWriting();
                throw throwable;
            }
            catch (Exception exception) {
                throw this.logAndConvert(exception);
            }
        }
        this.afterWriting();
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBatch() throws SQLException {
        try {
            this.debugCodeCall("addBatch");
            this.checkClosedForWrite();
            try {
                ObjectArray<? extends ParameterInterface> objectArray = this.command.getParameters();
                Value[] valueArray = new Value[objectArray.size()];
                for (int i = 0; i < objectArray.size(); ++i) {
                    Value value;
                    ParameterInterface parameterInterface = objectArray.get(i);
                    valueArray[i] = value = parameterInterface.getParamValue();
                }
                if (this.batchParameters == null) {
                    this.batchParameters = ObjectArray.newInstance();
                }
                this.batchParameters.add(valueArray);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int executeUpdate(String string, int n) throws SQLException {
        try {
            this.debugCode("executeUpdate(" + this.quote(string) + ", " + n + ");");
            throw Message.getSQLException(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        try {
            this.debugCode("executeUpdate(" + this.quote(string) + ", " + this.quoteIntArray(nArray) + ");");
            throw Message.getSQLException(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        try {
            this.debugCode("executeUpdate(" + this.quote(string) + ", " + this.quoteArray(stringArray) + ");");
            throw Message.getSQLException(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean execute(String string, int n) throws SQLException {
        try {
            this.debugCode("execute(" + this.quote(string) + ", " + n + ");");
            throw Message.getSQLException(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        try {
            this.debugCode("execute(" + this.quote(string) + ", " + this.quoteIntArray(nArray) + ");");
            throw Message.getSQLException(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        try {
            this.debugCode("execute(" + this.quote(string) + ", " + this.quoteArray(stringArray) + ");");
            throw Message.getSQLException(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            int n = this.getNextId(11);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("ParameterMetaData", 11, n, "getParameterMetaData()");
            }
            this.checkClosed();
            JdbcParameterMetaData jdbcParameterMetaData = new JdbcParameterMetaData(this.session.getTrace(), this, this.command, n);
            return jdbcParameterMetaData;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    private void setParameter(int n, Value value) throws SQLException {
        this.checkClosed();
        ObjectArray<? extends ParameterInterface> objectArray = this.command.getParameters();
        if (--n < 0 || n >= objectArray.size()) {
            throw Message.getInvalidValueException("" + (n + 1), "parameterIndex");
        }
        ParameterInterface parameterInterface = objectArray.get(n);
        parameterInterface.setValue(value, this.batchParameters == null);
    }

    public void setNString(int n, String string) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setNString(" + n + ", " + this.quote(string) + ");");
            }
            Value value = string == null ? ValueNull.INSTANCE : ValueString.get(string);
            this.setParameter(n, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setNCharacterStream(" + n + ", x, " + l + "L);");
            }
            this.checkClosedForWrite();
            try {
                Value value = this.conn.createClob(reader, l);
                this.setParameter(n, value);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        this.setNCharacterStream(n, reader, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNClob(int n, Reader reader) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setNClob(" + n + ", x);");
            }
            this.checkClosedForWrite();
            try {
                Value value = this.conn.createClob(reader, -1L);
                this.setParameter(n, value);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClob(int n, Reader reader, long l) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setClob(" + n + ", x, " + l + "L);");
            }
            this.checkClosedForWrite();
            try {
                Value value = this.conn.createClob(reader, l);
                this.setParameter(n, value);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBlob(" + n + ", x, " + l + "L);");
            }
            this.checkClosedForWrite();
            try {
                Value value = this.conn.createBlob(inputStream, l);
                this.setParameter(n, value);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNClob(int n, Reader reader, long l) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setNClob(" + n + ", x, " + l + "L);");
            }
            this.checkClosedForWrite();
            try {
                Value value = this.conn.createClob(reader, l);
                this.setParameter(n, value);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public String toString() {
        return this.getTraceObjectName() + ": " + this.command;
    }

    protected boolean checkClosed(boolean bl) throws SQLException {
        if (super.checkClosed(bl)) {
            ObjectArray<? extends ParameterInterface> objectArray = this.command.getParameters();
            this.command = this.conn.prepareCommand(this.sql, this.fetchSize);
            ObjectArray<? extends ParameterInterface> objectArray2 = this.command.getParameters();
            for (int i = 0; i < objectArray.size(); ++i) {
                ParameterInterface parameterInterface = objectArray.get(i);
                Value value = parameterInterface.getParamValue();
                if (value == null) continue;
                ParameterInterface parameterInterface2 = objectArray2.get(i);
                parameterInterface2.setValue(value, false);
            }
            return true;
        }
        return false;
    }
}

