/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.sql.SQLException;
import org.h2.command.Prepared;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.Parameter;
import org.h2.expression.ValueExpression;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.result.Row;
import org.h2.result.RowList;
import org.h2.table.Column;
import org.h2.table.PlanItem;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.value.Value;

public class Update
extends Prepared {
    private Expression condition;
    private TableFilter tableFilter;
    private Expression[] expressions;

    public Update(Session session) {
        super(session);
    }

    public void setTableFilter(TableFilter tableFilter) {
        this.tableFilter = tableFilter;
        Table table = tableFilter.getTable();
        this.expressions = new Expression[table.getColumns().length];
    }

    public void setCondition(Expression expression) {
        this.condition = expression;
    }

    public void setAssignment(Column column, Expression expression) throws SQLException {
        int n = column.getColumnId();
        if (this.expressions[n] != null) {
            throw Message.getSQLException(42121, column.getName());
        }
        this.expressions[n] = expression;
        if (expression instanceof Parameter) {
            Parameter parameter = (Parameter)expression;
            parameter.setColumn(column);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update() throws SQLException {
        this.tableFilter.startQuery(this.session);
        this.tableFilter.reset();
        RowList rowList = new RowList(this.session);
        try {
            Row row;
            Row row2;
            Table table = this.tableFilter.getTable();
            this.session.getUser().checkRight(table, 8);
            table.fireBefore(this.session);
            table.lock(this.session, true, false);
            int n = table.getColumns().length;
            this.setCurrentRowNumber(0);
            int n2 = 0;
            while (this.tableFilter.next()) {
                this.setCurrentRowNumber(n2 + 1);
                if (this.condition != null && !Boolean.TRUE.equals(this.condition.getBooleanValue(this.session))) continue;
                row2 = this.tableFilter.get();
                row = table.getTemplateRow();
                for (int i = 0; i < n; ++i) {
                    Column column;
                    Value value;
                    Expression expression = this.expressions[i];
                    if (expression == null) {
                        value = row2.getValue(i);
                    } else if (expression == ValueExpression.getDefault()) {
                        column = table.getColumn(i);
                        value = table.getDefaultValue(this.session, column);
                    } else {
                        column = table.getColumn(i);
                        value = column.convert(expression.getValue(this.session));
                    }
                    row.setValue(i, value);
                }
                table.validateConvertUpdateSequence(this.session, row);
                if (table.fireRow()) {
                    table.fireBeforeRow(this.session, row2, row);
                }
                rowList.add(row2);
                rowList.add(row);
                ++n2;
            }
            table.updateRows(this, this.session, rowList);
            if (table.fireRow()) {
                rowList.invalidateCache();
                rowList.reset();
                while (rowList.hasNext()) {
                    row2 = rowList.next();
                    row = rowList.next();
                    table.fireAfterRow(this.session, row2, row);
                }
            }
            table.fireAfter(this.session);
            int n3 = n2;
            return n3;
        }
        finally {
            rowList.close();
        }
    }

    public String getPlanSQL() {
        StatementBuilder statementBuilder = new StatementBuilder("UPDATE ");
        statementBuilder.append(this.tableFilter.getPlanSQL(false)).append("\nSET ");
        Table table = this.tableFilter.getTable();
        int n = table.getColumns().length;
        for (int i = 0; i < n; ++i) {
            Expression expression = this.expressions[i];
            if (expression == null) continue;
            Column column = table.getColumn(i);
            statementBuilder.appendExceptFirst(",\n");
            statementBuilder.append(column.getName()).append(" = ").append(expression.getSQL());
        }
        if (this.condition != null) {
            statementBuilder.append("\nWHERE ").append(StringUtils.unEnclose(this.condition.getSQL()));
        }
        return statementBuilder.toString();
    }

    public void prepare() throws SQLException {
        if (this.condition != null) {
            this.condition.mapColumns(this.tableFilter, 0);
            this.condition = this.condition.optimize(this.session);
            this.condition.createIndexConditions(this.session, this.tableFilter);
        }
        for (int i = 0; i < this.expressions.length; ++i) {
            Expression expression = this.expressions[i];
            if (expression == null) continue;
            expression.mapColumns(this.tableFilter, 0);
            this.expressions[i] = expression.optimize(this.session);
        }
        PlanItem planItem = this.tableFilter.getBestPlanItem(this.session, 1);
        this.tableFilter.setPlanItem(planItem);
        this.tableFilter.prepare();
    }

    public boolean isTransactional() {
        return true;
    }

    public LocalResult queryMeta() {
        return null;
    }
}

