/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import org.h2.command.dml.Query;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.table.Column;
import org.h2.util.ObjectArray;
import org.h2.util.StatementBuilder;
import org.h2.value.CompareMode;
import org.h2.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexCondition {
    public static final int EQUALITY = 1;
    public static final int START = 2;
    public static final int END = 4;
    public static final int RANGE = 6;
    public static final int ALWAYS_FALSE = 8;
    private Column column;
    private int compareType;
    private Expression expression;
    private ObjectArray<Expression> expressionList;
    private Query expressionQuery;

    private IndexCondition(int n, ExpressionColumn expressionColumn, Expression expression) {
        this.compareType = n;
        this.column = expressionColumn == null ? null : expressionColumn.getColumn();
        this.expression = expression;
    }

    public static IndexCondition get(int n, ExpressionColumn expressionColumn, Expression expression) {
        return new IndexCondition(n, expressionColumn, expression);
    }

    public static IndexCondition getInList(ExpressionColumn expressionColumn, ObjectArray<Expression> objectArray) {
        IndexCondition indexCondition = new IndexCondition(9, expressionColumn, null);
        indexCondition.expressionList = objectArray;
        return indexCondition;
    }

    public static IndexCondition getInQuery(ExpressionColumn expressionColumn, Query query) {
        IndexCondition indexCondition = new IndexCondition(10, expressionColumn, null);
        indexCondition.expressionQuery = query;
        return indexCondition;
    }

    public Value getCurrentValue(Session session) throws SQLException {
        return this.expression.getValue(session);
    }

    public Value[] getCurrentValueList(Session session) throws SQLException {
        HashSet<Value> hashSet = new HashSet<Value>();
        for (Expression object2 : this.expressionList) {
            Value value = object2.getValue(session);
            value = this.column.convert(value);
            hashSet.add(value);
        }
        Value[] valueArray = new Value[hashSet.size()];
        hashSet.toArray(valueArray);
        final CompareMode compareMode = session.getDatabase().getCompareMode();
        Arrays.sort(valueArray, new Comparator<Value>(){

            @Override
            public int compare(Value value, Value value2) {
                try {
                    return value.compareTo(value2, compareMode);
                }
                catch (SQLException sQLException) {
                    throw Message.convertToInternal(sQLException);
                }
            }
        });
        return valueArray;
    }

    public LocalResult getCurrentResult(Session session) throws SQLException {
        return this.expressionQuery.query(0);
    }

    public String getSQL() {
        if (this.compareType == 8) {
            return "FALSE";
        }
        StatementBuilder statementBuilder = new StatementBuilder();
        statementBuilder.append(this.column.getSQL());
        switch (this.compareType) {
            case 0: {
                statementBuilder.append(" = ");
                break;
            }
            case 1: {
                statementBuilder.append(" >= ");
                break;
            }
            case 2: {
                statementBuilder.append(" > ");
                break;
            }
            case 3: {
                statementBuilder.append(" <= ");
                break;
            }
            case 4: {
                statementBuilder.append(" < ");
                break;
            }
            case 9: {
                statementBuilder.append(" IN(");
                for (Expression expression : this.expressionList) {
                    statementBuilder.appendExceptFirst(", ");
                    statementBuilder.append(expression.getSQL());
                }
                statementBuilder.append(')');
                break;
            }
            case 10: {
                statementBuilder.append(" IN(");
                statementBuilder.append(this.expressionQuery.getPlanSQL());
                statementBuilder.append(')');
                break;
            }
            default: {
                Message.throwInternalError("type=" + this.compareType);
            }
        }
        if (this.expression != null) {
            statementBuilder.append(this.expression.getSQL());
        }
        return statementBuilder.toString();
    }

    public int getMask() {
        switch (this.compareType) {
            case 8: {
                return 8;
            }
            case 0: 
            case 9: 
            case 10: {
                return 1;
            }
            case 1: 
            case 2: {
                return 2;
            }
            case 3: 
            case 4: {
                return 4;
            }
        }
        throw Message.throwInternalError("type=" + this.compareType);
    }

    public boolean isAlwaysFalse() {
        return this.compareType == 8;
    }

    public boolean isStart() {
        switch (this.compareType) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public boolean isEnd() {
        switch (this.compareType) {
            case 0: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public int getCompareType() {
        return this.compareType;
    }

    public Column getColumn() {
        return this.column;
    }

    public boolean isEvaluatable() {
        if (this.expression != null) {
            return this.expression.isEverything(3);
        }
        if (this.expressionList != null) {
            for (Expression expression : this.expressionList) {
                if (expression.isEverything(3)) continue;
                return false;
            }
            return true;
        }
        return this.expressionQuery.isEverything(3);
    }
}

