/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.store.Data;
import org.h2.store.DataPage;
import org.h2.store.Page;
import org.h2.store.PageStore;

public class PageStreamTrunk
extends Page {
    private static final int DATA_START = 13;
    private final PageStore store;
    private int parent;
    private int nextTrunk;
    private int[] pageIds;
    private int pageCount;
    private Data data;
    private int index;

    private PageStreamTrunk(PageStore pageStore, int n, int n2, int n3, int[] nArray) {
        this.setPos(n2);
        this.parent = n;
        this.store = pageStore;
        this.nextTrunk = n3;
        this.pageCount = nArray.length;
        this.pageIds = nArray;
    }

    private PageStreamTrunk(PageStore pageStore, Data data, int n) {
        this.setPos(n);
        this.data = data;
        this.store = pageStore;
    }

    static PageStreamTrunk read(PageStore pageStore, Data data, int n) {
        PageStreamTrunk pageStreamTrunk = new PageStreamTrunk(pageStore, data, n);
        pageStreamTrunk.read();
        return pageStreamTrunk;
    }

    static PageStreamTrunk create(PageStore pageStore, int n, int n2, int n3, int[] nArray) {
        return new PageStreamTrunk(pageStore, n, n2, n3, nArray);
    }

    private void read() {
        this.data.reset();
        this.parent = this.data.readInt();
        this.data.readByte();
        this.nextTrunk = this.data.readInt();
        this.pageCount = this.data.readInt();
        this.pageIds = new int[this.pageCount];
        for (int i = 0; i < this.pageCount; ++i) {
            this.pageIds[i] = this.data.readInt();
        }
    }

    void resetIndex() {
        this.index = 0;
    }

    void setNextDataPage(int n) {
        this.pageIds[this.index++] = n;
    }

    int getNextPageData() {
        if (this.index >= this.pageIds.length) {
            return -1;
        }
        return this.pageIds[this.index++];
    }

    int getNextTrunk() {
        return this.nextTrunk;
    }

    public int getByteCount(DataPage dataPage) {
        return this.store.getPageSize();
    }

    public void write(DataPage dataPage) throws SQLException {
        this.data = this.store.createData();
        this.data.writeInt(this.parent);
        this.data.writeByte((byte)7);
        this.data.writeInt(this.nextTrunk);
        this.data.writeInt(this.pageCount);
        for (int i = 0; i < this.pageCount; ++i) {
            this.data.writeInt(this.pageIds[i]);
        }
        this.store.writePage(this.getPos(), this.data);
    }

    static int getPagesAddressed(int n) {
        return (n - 13) / 4;
    }

    boolean contains(int n) {
        for (int i = 0; i < this.pageCount; ++i) {
            if (this.pageIds[i] != n) continue;
            return true;
        }
        return false;
    }

    int free() throws SQLException {
        Data data = this.store.createData();
        this.store.freePage(this.getPos(), false, null);
        int n = 1;
        for (int i = 0; i < this.pageCount; ++i) {
            int n2 = this.pageIds[i];
            this.store.freePage(n2, false, null);
            ++n;
            this.store.writePage(n2, data);
        }
        this.store.writePage(this.getPos(), data);
        return n;
    }

    public int getMemorySize() {
        return this.store.getPageSize() >> 2;
    }

    void moveChild(int n, int n2) throws SQLException {
        for (int i = 0; i < this.pageIds.length; ++i) {
            if (this.pageIds[i] != n) continue;
            this.pageIds[i] = n2;
            break;
        }
        this.store.updateRecord(this, true, this.data);
    }

    public void moveTo(Session session, int n) {
    }
}

