/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.sql.SQLException;
import org.h2.command.Parser;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Session;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.table.Table;
import org.h2.util.ObjectArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DbObjectBase
implements DbObject {
    protected Database database;
    protected Trace trace;
    protected String comment;
    private int id;
    private String objectName;
    private long modificationId;
    private boolean temporary;

    protected void initDbObjectBase(Database database, int n, String string, String string2) {
        this.database = database;
        this.trace = database.getTrace(string2);
        this.id = n;
        this.objectName = string;
        this.modificationId = database.getModificationMetaId();
    }

    @Override
    public abstract String getCreateSQLForCopy(Table var1, String var2);

    @Override
    public abstract String getCreateSQL();

    @Override
    public abstract String getDropSQL();

    @Override
    public abstract int getType();

    @Override
    public abstract void removeChildrenAndResources(Session var1) throws SQLException;

    @Override
    public abstract void checkRename() throws SQLException;

    @Override
    public void setModified() {
        this.modificationId = this.database == null ? -1L : this.database.getNextModificationMetaId();
    }

    @Override
    public long getModificationId() {
        return this.modificationId;
    }

    protected void setObjectName(String string) {
        this.objectName = string;
    }

    @Override
    public String getSQL() {
        return Parser.quoteIdentifier(this.objectName);
    }

    @Override
    public ObjectArray<DbObject> getChildren() {
        return null;
    }

    @Override
    public Database getDatabase() {
        return this.database;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.objectName;
    }

    protected void invalidate() {
        this.setModified();
        this.id = -1;
        this.database = null;
        this.trace = null;
        this.objectName = null;
    }

    @Override
    public int getHeadPos() {
        return 0;
    }

    @Override
    public void rename(String string) throws SQLException {
        this.checkRename();
        this.objectName = string;
        this.setModified();
    }

    @Override
    public boolean isTemporary() {
        return this.temporary;
    }

    @Override
    public void setTemporary(boolean bl) {
        this.temporary = bl;
    }

    @Override
    public void setComment(String string) {
        this.comment = string;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    static int getCreateOrder(int n) {
        switch (n) {
            case 6: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 10: {
                return 2;
            }
            case 12: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 11: {
                return 5;
            }
            case 9: {
                return 6;
            }
            case 0: {
                return 7;
            }
            case 1: {
                return 8;
            }
            case 5: {
                return 9;
            }
            case 4: {
                return 10;
            }
            case 7: {
                return 11;
            }
            case 8: {
                return 12;
            }
            case 14: {
                return 13;
            }
            case 13: {
                return 14;
            }
        }
        throw Message.throwInternalError("type=" + n);
    }

    public String toString() {
        return this.objectName + ":" + this.id + ":" + super.toString();
    }
}

