/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.h2.constant.SysProperties;
import org.h2.message.Message;
import org.h2.tools.SimpleResultSet;
import org.h2.tools.SimpleRowSource;
import org.h2.util.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.JdbcUtils;
import org.h2.util.New;
import org.h2.util.StringCache;

public class Csv
implements SimpleRowSource {
    private String streamCharset = SysProperties.FILE_ENCODING;
    private int bufferSize = 8192;
    private String[] columnNames;
    private char fieldSeparatorRead = (char)44;
    private char commentLineStart = (char)35;
    private String fieldSeparatorWrite = ",";
    private String rowSeparatorWrite;
    private char fieldDelimiter = (char)34;
    private char escapeCharacter = (char)34;
    private String lineSeparator = SysProperties.LINE_SEPARATOR;
    private String nullString = "";
    private String fileName;
    private Reader input;
    private Writer output;
    private int back;
    private boolean endOfLine;
    private boolean endOfFile;

    private Csv() {
    }

    public static Csv getInstance() {
        return new Csv();
    }

    private int writeResultSet(ResultSet resultSet) throws SQLException {
        try {
            int n;
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n2 = 0;
            int n3 = resultSetMetaData.getColumnCount();
            String[] stringArray = new String[n3];
            for (n = 0; n < n3; ++n) {
                stringArray[n] = resultSetMetaData.getColumnLabel(n + 1);
            }
            this.writeRow(stringArray);
            while (resultSet.next()) {
                for (n = 0; n < n3; ++n) {
                    stringArray[n] = resultSet.getString(n + 1);
                }
                this.writeRow(stringArray);
                ++n2;
            }
            this.output.close();
            n = n2;
            return n;
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, null);
        }
        finally {
            this.close();
            JdbcUtils.closeSilently(resultSet);
        }
    }

    public int write(Writer writer, ResultSet resultSet) throws SQLException {
        this.output = writer;
        return this.writeResultSet(resultSet);
    }

    public int write(String string, ResultSet resultSet, String string2) throws SQLException {
        this.init(string, string2);
        try {
            this.initWrite();
            return this.writeResultSet(resultSet);
        }
        catch (IOException iOException) {
            throw this.convertException("IOException writing " + string, iOException);
        }
    }

    public int write(Connection connection, String string, String string2, String string3) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string2);
        int n = this.write(string, resultSet, string3);
        statement.close();
        return n;
    }

    public ResultSet read(String string, String[] stringArray, String string2) throws SQLException {
        this.init(string, string2);
        try {
            return this.readResultSet(stringArray);
        }
        catch (IOException iOException) {
            throw this.convertException("IOException reading " + string, iOException);
        }
    }

    public ResultSet read(Reader reader, String[] stringArray) throws SQLException, IOException {
        this.init(null, null);
        this.input = reader;
        return this.readResultSet(stringArray);
    }

    private ResultSet readResultSet(String[] stringArray) throws SQLException, IOException {
        this.columnNames = stringArray;
        this.initRead();
        SimpleResultSet simpleResultSet = new SimpleResultSet(this);
        this.makeColumnNamesUnique();
        for (String string : this.columnNames) {
            simpleResultSet.addColumn(string, 12, Integer.MAX_VALUE, 0);
        }
        return simpleResultSet;
    }

    private void makeColumnNamesUnique() {
        for (int i = 0; i < this.columnNames.length; ++i) {
            String string = this.columnNames[i];
            if (string == null || string.length() == 0) {
                string = "C" + (i + 1);
            }
            for (int j = 0; j < i; ++j) {
                String string2 = this.columnNames[j];
                if (!string.equals(string2)) continue;
                string = string + "1";
                j = -1;
            }
            this.columnNames[i] = string;
        }
    }

    private void init(String string, String string2) {
        this.fileName = string;
        if (string2 != null) {
            this.streamCharset = string2;
        }
    }

    private void initWrite() throws IOException {
        if (this.output == null) {
            try {
                OutputStream outputStream = FileUtils.openFileOutputStream(this.fileName, false);
                outputStream = new BufferedOutputStream(outputStream, this.bufferSize);
                this.output = new BufferedWriter(new OutputStreamWriter(outputStream, this.streamCharset));
            }
            catch (SQLException sQLException) {
                this.close();
                throw Message.convertToIOException(sQLException);
            }
        }
    }

    private void writeRow(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            if (i > 0 && this.fieldSeparatorWrite != null) {
                this.output.write(this.fieldSeparatorWrite);
            }
            if ((string = stringArray[i]) != null) {
                if (this.escapeCharacter != '\u0000') {
                    if (this.fieldDelimiter != '\u0000') {
                        this.output.write(this.fieldDelimiter);
                    }
                    this.output.write(this.escape(string));
                    if (this.fieldDelimiter == '\u0000') continue;
                    this.output.write(this.fieldDelimiter);
                    continue;
                }
                this.output.write(string);
                continue;
            }
            if (this.nullString == null || this.nullString.length() <= 0) continue;
            this.output.write(this.nullString);
        }
        if (this.rowSeparatorWrite != null) {
            this.output.write(this.rowSeparatorWrite);
        }
        this.output.write(this.lineSeparator);
    }

    private String escape(String string) {
        if (string.indexOf(this.fieldDelimiter) < 0 && (this.escapeCharacter == this.fieldDelimiter || string.indexOf(this.escapeCharacter) < 0)) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == this.fieldDelimiter || c == this.escapeCharacter) {
                stringBuilder.append(this.escapeCharacter);
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private void initRead() throws IOException {
        if (this.input == null) {
            try {
                InputStream inputStream = FileUtils.openFileInputStream(this.fileName);
                inputStream = new BufferedInputStream(inputStream, this.bufferSize);
                this.input = new InputStreamReader(inputStream, this.streamCharset);
                this.input = new BufferedReader(this.input);
            }
            catch (IOException iOException) {
                this.close();
                throw iOException;
            }
        }
        if (this.columnNames == null) {
            this.readHeader();
        }
    }

    private void readHeader() throws IOException {
        ArrayList<String> arrayList = New.arrayList();
        while (true) {
            String string;
            if ((string = this.readValue()) == null) {
                if (this.endOfLine) {
                    if (!this.endOfFile && arrayList.size() <= 0) continue;
                    break;
                }
                arrayList.add("COLUMN" + arrayList.size());
                continue;
            }
            arrayList.add(string);
        }
        this.columnNames = new String[arrayList.size()];
        arrayList.toArray(this.columnNames);
    }

    private void pushBack(int n) {
        this.back = n;
    }

    private int readChar() throws IOException {
        int n = this.back;
        if (n != -1) {
            this.back = -1;
            return n;
        }
        if (this.endOfFile) {
            return -1;
        }
        n = this.input.read();
        if (n < 0) {
            this.endOfFile = true;
            this.close();
        }
        return n;
    }

    private String readValue() throws IOException {
        String string;
        block18: {
            int n;
            this.endOfLine = false;
            string = null;
            do {
                if ((n = this.readChar()) < 0 || n == 13 || n == 10) {
                    this.endOfLine = true;
                    break block18;
                }
                if (n == this.fieldSeparatorRead) break block18;
            } while (n <= 32);
            if (n == this.fieldDelimiter) {
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl = false;
                while (true) {
                    if ((n = this.readChar()) < 0) {
                        string = stringBuilder.toString();
                        break block18;
                    }
                    if (n == this.fieldDelimiter) {
                        n = this.readChar();
                        if (n == this.fieldDelimiter) {
                            stringBuilder.append((char)n);
                            continue;
                        }
                        this.pushBack(n);
                        break;
                    }
                    if (n == this.escapeCharacter) {
                        stringBuilder.append((char)n);
                        n = this.readChar();
                        if (n < 0) break;
                        bl = true;
                        stringBuilder.append((char)n);
                        continue;
                    }
                    stringBuilder.append((char)n);
                }
                string = stringBuilder.toString();
                if (bl) {
                    string = this.unEscape(string);
                }
                while ((n = this.readChar()) >= 0 && n != this.fieldSeparatorRead) {
                    if (n == 32 || n == 9) continue;
                    if (n == 13 || n == 10) {
                        this.pushBack(n);
                        this.endOfLine = true;
                    } else {
                        this.pushBack(n);
                    }
                    break;
                }
            } else if (n == this.commentLineStart) {
                while ((n = this.readChar()) >= 0 && n != 13 && n != 10) {
                }
                this.endOfLine = true;
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append((char)n);
                while ((n = this.readChar()) != this.fieldSeparatorRead) {
                    if (n == 13 || n == 10) {
                        this.pushBack(n);
                        this.endOfLine = true;
                        break;
                    }
                    if (n < 0) break;
                    stringBuilder.append((char)n);
                }
                string = this.readNull(stringBuilder.toString().trim());
            }
        }
        return StringCache.get(string);
    }

    private String readNull(String string) {
        return string.equals(this.nullString) ? null : string;
    }

    private String unEscape(String string) {
        int n;
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n2 = 0;
        char[] cArray = null;
        while ((n = string.indexOf(this.escapeCharacter, n2)) >= 0) {
            if (cArray == null) {
                cArray = string.toCharArray();
            }
            stringBuilder.append(cArray, n2, n - n2);
            if (n == string.length() - 1) {
                n2 = string.length();
                break;
            }
            stringBuilder.append(cArray[n + 1]);
            n2 = n + 2;
        }
        stringBuilder.append(string.substring(n2));
        return stringBuilder.toString();
    }

    public Object[] readRow() throws SQLException {
        if (this.input == null) {
            return null;
        }
        Object[] objectArray = new String[this.columnNames.length];
        try {
            int n = 0;
            while (true) {
                String string;
                if ((string = this.readValue()) == null) {
                    if (this.endOfFile && n == 0) {
                        return null;
                    }
                    if (this.endOfLine) {
                        if (n == 0) {
                            continue;
                        }
                        break;
                    }
                }
                if (n >= objectArray.length) continue;
                objectArray[n++] = string;
            }
        }
        catch (IOException iOException) {
            throw this.convertException("IOException reading from " + this.fileName, iOException);
        }
        return objectArray;
    }

    private SQLException convertException(String string, Exception exception) {
        SQLException sQLException = new SQLException(string, "CSV");
        sQLException.initCause(exception);
        return sQLException;
    }

    public void close() {
        IOUtils.closeSilently(this.input);
        this.input = null;
        IOUtils.closeSilently(this.output);
        this.output = null;
    }

    public void reset() throws SQLException {
        throw new SQLException("Method is not supported", "CSV");
    }

    public void setFieldSeparatorWrite(String string) {
        this.fieldSeparatorWrite = string;
    }

    public String getFieldSeparatorWrite() {
        return this.fieldSeparatorWrite;
    }

    public void setFieldSeparatorRead(char c) {
        this.fieldSeparatorRead = c;
    }

    public char getFieldSeparatorRead() {
        return this.fieldSeparatorRead;
    }

    public String getRowSeparatorWrite() {
        return this.rowSeparatorWrite;
    }

    public void setRowSeparatorWrite(String string) {
        this.rowSeparatorWrite = string;
    }

    public void setFieldDelimiter(char c) {
        this.fieldDelimiter = c;
    }

    public char getFieldDelimiter() {
        return this.fieldDelimiter;
    }

    public void setEscapeCharacter(char c) {
        this.escapeCharacter = c;
    }

    public char getEscapeCharacter() {
        return this.escapeCharacter;
    }

    public void setLineSeparator(String string) {
        this.lineSeparator = string;
    }

    public void setNullString(String string) {
        this.nullString = string;
    }
}

