/*
 * Decompiled with CFR 0.152.
 */
package org.h2.bnf;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.StringTokenizer;
import org.h2.bnf.Rule;
import org.h2.bnf.RuleElement;
import org.h2.bnf.RuleFixed;
import org.h2.bnf.RuleHead;
import org.h2.bnf.RuleList;
import org.h2.bnf.RuleOptional;
import org.h2.bnf.RuleRepeat;
import org.h2.bnf.Sentence;
import org.h2.server.web.DbContextRule;
import org.h2.tools.Csv;
import org.h2.util.New;
import org.h2.util.Resources;
import org.h2.util.StringCache;
import org.h2.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bnf {
    private final Random random = new Random();
    private final HashMap<String, RuleHead> ruleMap = New.hashMap();
    private String syntax;
    private String currentToken;
    private String[] tokens;
    private char firstChar;
    private int index;
    private Rule lastRepeat;
    private ArrayList<RuleHead> statements;
    private String currentTopic;

    Bnf() {
        this.random.setSeed(1L);
    }

    public static Bnf getInstance(Reader reader) throws SQLException, IOException {
        Bnf bnf = new Bnf();
        if (reader == null) {
            byte[] byArray = Resources.get("/org/h2/res/help.csv");
            reader = new InputStreamReader(new ByteArrayInputStream(byArray));
        }
        bnf.parse(reader);
        return bnf;
    }

    private void addFixedRule(String string, int n) {
        RuleFixed ruleFixed = new RuleFixed(n);
        this.addRule(string, "Fixed", ruleFixed);
    }

    private RuleHead addRule(String string, String string2, Rule rule) {
        RuleHead ruleHead = new RuleHead(string2, string, rule);
        if (this.ruleMap.get(StringUtils.toLowerEnglish(string)) != null) {
            throw new Error("already exists: " + string);
        }
        this.ruleMap.put(StringUtils.toLowerEnglish(string), ruleHead);
        return ruleHead;
    }

    public Random getRandom() {
        return this.random;
    }

    private void parse(Reader reader) throws SQLException, IOException {
        reader = new BufferedReader(reader);
        Rule rule = null;
        this.statements = New.arrayList();
        ResultSet resultSet = Csv.getInstance().read(reader, null);
        int n = 0;
        while (resultSet.next()) {
            String string = resultSet.getString("SECTION").trim();
            if (!string.startsWith("System")) {
                String string2 = StringUtils.toLowerEnglish(resultSet.getString("TOPIC").trim());
                string2 = StringUtils.replaceAll(string2, " ", "_");
                this.syntax = resultSet.getString("SYNTAX").trim();
                this.currentTopic = string;
                if (string.startsWith("Function")) {
                    int n2 = this.syntax.indexOf(58);
                    this.syntax = this.syntax.substring(0, n2);
                }
                this.tokens = this.tokenize();
                this.index = 0;
                Rule rule2 = this.parseRule();
                if (string.startsWith("Command")) {
                    rule2 = new RuleList(rule2, new RuleElement(";\n\n", this.currentTopic), false);
                }
                RuleHead ruleHead = this.addRule(string2, string, rule2);
                if (string.startsWith("Function")) {
                    rule = rule == null ? rule2 : new RuleList(rule2, rule, true);
                } else if (string.startsWith("Commands")) {
                    this.statements.add(ruleHead);
                }
            }
            ++n;
        }
        this.addRule("@func@", "Function", rule);
        this.addFixedRule("@ymd@", 0);
        this.addFixedRule("@hms@", 1);
        this.addFixedRule("@nanos@", 2);
        this.addFixedRule("anything_except_single_quote", 3);
        this.addFixedRule("anything_except_double_quote", 4);
        this.addFixedRule("anything_until_end_of_line", 5);
        this.addFixedRule("anything_until_end_comment", 6);
        this.addFixedRule("anything_except_two_dollar_signs", 8);
        this.addFixedRule("anything", 7);
        this.addFixedRule("@hex_start@", 10);
        this.addFixedRule("@concat@", 11);
        this.addFixedRule("@az_@", 12);
        this.addFixedRule("@af@", 13);
        this.addFixedRule("@digit@", 14);
    }

    public String getSyntaxHtml(String string) {
        StringTokenizer stringTokenizer = this.getTokenizer(string);
        StringBuilder stringBuilder = new StringBuilder();
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3 = stringTokenizer.nextToken();
            if (string3.length() == 1 || StringUtils.toUpperEnglish(string3).equals(string3)) {
                stringBuilder.append(string3);
                continue;
            }
            RuleHead ruleHead = null;
            for (int i = 0; i < string3.length(); ++i) {
                string2 = StringUtils.toLowerEnglish(string3.substring(i));
                RuleHead ruleHead2 = this.ruleMap.get(string2);
                if (ruleHead2 == null) continue;
                ruleHead = ruleHead2;
                break;
            }
            if (ruleHead == null || ruleHead.getRule() instanceof RuleFixed) {
                stringBuilder.append(string3);
                continue;
            }
            String string4 = "grammar.html";
            if (ruleHead.getSection().startsWith("Data Types")) {
                string4 = "datatypes.html";
            } else if (ruleHead.getSection().startsWith("Functions")) {
                string4 = "functions.html";
            }
            string2 = StringUtils.urlEncode(ruleHead.getTopic().toLowerCase());
            stringBuilder.append("<a href=\"").append(string4).append("#").append(string2).append("\">").append(string3).append("</a>");
        }
        return stringBuilder.toString();
    }

    private Rule parseRule() {
        this.read();
        return this.parseOr();
    }

    private Rule parseOr() {
        Rule rule = this.parseList();
        if (this.firstChar == '|') {
            this.read();
            rule = new RuleList(rule, this.parseOr(), true);
        }
        this.lastRepeat = rule;
        return rule;
    }

    private Rule parseList() {
        Rule rule = this.parseToken();
        if (this.firstChar != '|' && this.firstChar != ']' && this.firstChar != '}' && this.firstChar != '\u0000') {
            rule = new RuleList(rule, this.parseList(), false);
        }
        this.lastRepeat = rule;
        return rule;
    }

    private Rule parseToken() {
        Rule rule;
        if (this.firstChar >= 'A' && this.firstChar <= 'Z' || this.firstChar >= 'a' && this.firstChar <= 'z') {
            rule = new RuleElement(this.currentToken, this.currentTopic);
        } else if (this.firstChar == '[') {
            this.read();
            Rule rule2 = this.parseOr();
            rule = new RuleOptional(rule2);
            if (this.firstChar != ']') {
                throw new Error("expected ], got " + this.currentToken + " syntax:" + this.syntax);
            }
        } else if (this.firstChar == '{') {
            this.read();
            rule = this.parseOr();
            if (this.firstChar != '}') {
                throw new Error("expected }, got " + this.currentToken + " syntax:" + this.syntax);
            }
        } else if ("@commaDots@".equals(this.currentToken)) {
            rule = new RuleList(new RuleElement(",", this.currentTopic), this.lastRepeat, false);
            rule = new RuleRepeat(rule);
        } else {
            rule = "@dots@".equals(this.currentToken) ? new RuleRepeat(this.lastRepeat) : new RuleElement(this.currentToken, this.currentTopic);
        }
        this.lastRepeat = rule;
        this.read();
        return rule;
    }

    private void read() {
        if (this.index < this.tokens.length) {
            this.currentToken = this.tokens[this.index++];
            this.firstChar = this.currentToken.charAt(0);
        } else {
            this.currentToken = "";
            this.firstChar = '\u0000';
        }
    }

    private String[] tokenize() {
        ArrayList<String> arrayList = New.arrayList();
        this.syntax = StringUtils.replaceAll(this.syntax, "yyyy-MM-dd", "@ymd@");
        this.syntax = StringUtils.replaceAll(this.syntax, "hh:mm:ss", "@hms@");
        this.syntax = StringUtils.replaceAll(this.syntax, "nnnnnnnnn", "@nanos@");
        this.syntax = StringUtils.replaceAll(this.syntax, "function", "@func@");
        this.syntax = StringUtils.replaceAll(this.syntax, "0x", "@hexStart@");
        this.syntax = StringUtils.replaceAll(this.syntax, ",...", "@commaDots@");
        this.syntax = StringUtils.replaceAll(this.syntax, "...", "@dots@");
        this.syntax = StringUtils.replaceAll(this.syntax, "||", "@concat@");
        this.syntax = StringUtils.replaceAll(this.syntax, "a-z|_", "@az_@");
        this.syntax = StringUtils.replaceAll(this.syntax, "A-Z|_", "@az_@");
        this.syntax = StringUtils.replaceAll(this.syntax, "a-f", "@af@");
        this.syntax = StringUtils.replaceAll(this.syntax, "A-F", "@af@");
        this.syntax = StringUtils.replaceAll(this.syntax, "0-9", "@digit@");
        StringTokenizer stringTokenizer = this.getTokenizer(this.syntax);
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if ((string = StringCache.get(string)).length() == 1 && " \r\n".indexOf(string.charAt(0)) >= 0) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[0]);
    }

    public HashMap<String, String> getNextTokenList(String string) {
        Sentence sentence = new Sentence();
        sentence.setQuery(string);
        for (RuleHead ruleHead : this.statements) {
            if (!ruleHead.getSection().startsWith("Commands")) continue;
            sentence.start();
            ruleHead.getRule().addNextTokenList(sentence);
        }
        return sentence.getNext();
    }

    public void linkStatements() {
        for (RuleHead ruleHead : this.ruleMap.values()) {
            ruleHead.getRule().setLinks(this.ruleMap);
        }
    }

    public void updateTopic(String string, DbContextRule dbContextRule) {
        RuleHead ruleHead = this.ruleMap.get(string = StringUtils.toLowerEnglish(string));
        if (ruleHead == null) {
            ruleHead = new RuleHead("db", string, dbContextRule);
            this.ruleMap.put(string, ruleHead);
            this.statements.add(ruleHead);
        } else {
            ruleHead.setRule(dbContextRule);
        }
    }

    public ArrayList<RuleHead> getStatements() {
        return this.statements;
    }

    private StringTokenizer getTokenizer(String string) {
        return new StringTokenizer(string, " [](){}|.,\r\n<>:-+*/=<\">!'$", true);
    }
}

