/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.sql.SQLException;
import org.h2.message.Message;
import org.h2.store.DataPage;
import org.h2.store.PageStore;
import org.h2.store.Record;
import org.h2.util.BitField;

public class PageFreeList
extends Record {
    private static final int DATA_START = 5;
    private final PageStore store;
    private final BitField used = new BitField();
    private final int firstAddressed;
    private final int pageCount;
    private final int nextPage;
    private boolean full;
    private DataPage data;

    PageFreeList(PageStore pageStore, int n, int n2) {
        this.setPos(n);
        this.store = pageStore;
        this.firstAddressed = n2;
        this.pageCount = (pageStore.getPageSize() - 5) * 8;
        for (int i = n2; i <= n; ++i) {
            this.used.set(this.getAddress(i));
        }
        this.nextPage = n2 + this.pageCount;
    }

    private int getAddress(int n) {
        return n - this.firstAddressed;
    }

    int allocate() throws SQLException {
        if (this.full) {
            PageFreeList pageFreeList = this.getNext();
            if (pageFreeList == null) {
                return -1;
            }
            return pageFreeList.allocate();
        }
        int n = this.used.nextClearBit(0);
        if (n > this.pageCount) {
            this.full = true;
            return this.allocate();
        }
        this.used.set(n);
        this.store.updateRecord(this, true, this.data);
        return n + this.firstAddressed;
    }

    int allocateAtEnd(int n) throws SQLException {
        int n2 = Math.max(n, this.getLastUsed() + 1);
        return this.allocate(n2);
    }

    public int getLastUsed() throws SQLException {
        if (this.nextPage < this.store.getPageCount()) {
            PageFreeList pageFreeList = this.getNext();
            return pageFreeList.getLastUsed();
        }
        return this.used.getLastSetBit() + this.firstAddressed;
    }

    private PageFreeList getNext() throws SQLException {
        PageFreeList pageFreeList = (PageFreeList)this.store.getRecord(this.nextPage);
        if (pageFreeList == null && this.nextPage < this.store.getPageCount()) {
            pageFreeList = new PageFreeList(this.store, this.nextPage, this.nextPage);
            pageFreeList.read();
            this.store.updateRecord(pageFreeList, false, null);
        }
        return pageFreeList;
    }

    int allocate(int n) throws SQLException {
        if (n - this.firstAddressed > this.pageCount) {
            PageFreeList pageFreeList = this.getNext();
            if (pageFreeList == null) {
                return -1;
            }
            return pageFreeList.allocate(n);
        }
        int n2 = n - this.firstAddressed;
        if (n2 >= 0 && !this.used.get(n2)) {
            this.used.set(n - this.firstAddressed);
            this.store.updateRecord(this, true, this.data);
        }
        return n;
    }

    void free(int n) throws SQLException {
        this.full = false;
        this.used.clear(n - this.firstAddressed);
        this.store.updateRecord(this, true, this.data);
    }

    void read() throws SQLException {
        this.data = this.store.createDataPage();
        this.store.readPage(this.getPos(), this.data);
        int n = this.data.readInt();
        int n2 = this.data.readByte();
        if (n2 == 0) {
            return;
        }
        if (n2 != 7 || n != 0) {
            throw Message.getSQLException(90030, "pos:" + this.getPos() + " type:" + n2 + " parent:" + n + " expected type:" + 7);
        }
        for (int i = 0; i < this.pageCount; i += 8) {
            this.used.setByte(i, this.data.readByte());
        }
    }

    public int getByteCount(DataPage dataPage) {
        return this.store.getPageSize();
    }

    public void write(DataPage dataPage) throws SQLException {
        this.data = this.store.createDataPage();
        this.data.writeInt(0);
        int n = 7;
        this.data.writeByte((byte)n);
        for (int i = 0; i < this.pageCount; i += 8) {
            this.data.writeByte((byte)this.used.getByte(i));
        }
        this.store.writePage(this.getPos(), this.data);
    }
}

