/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.PageData;
import org.h2.index.PageDataLeaf;
import org.h2.index.PageScanIndex;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.store.DataPage;

class PageDataNode
extends PageData {
    private static final int ENTRY_START = 15;
    private static final int ENTRY_LENGTH = 8;
    private int[] childPageIds;
    private int rowCountStored = -1;
    private int rowCount = -1;

    PageDataNode(PageScanIndex pageScanIndex, int n, int n2, DataPage dataPage) {
        super(pageScanIndex, n, n2, dataPage);
    }

    void read() {
        this.data.setPos(5);
        this.entryCount = this.data.readShortInt();
        this.rowCount = this.rowCountStored = this.data.readInt();
        this.childPageIds = new int[this.entryCount + 1];
        this.childPageIds[this.entryCount] = this.data.readInt();
        this.keys = new int[this.entryCount];
        for (int i = 0; i < this.entryCount; ++i) {
            this.childPageIds[i] = this.data.readInt();
            this.keys[i] = this.data.readInt();
        }
        this.check();
    }

    private void addChild(int n, int n2, int n3) {
        int[] nArray = new int[this.entryCount + 1];
        int[] nArray2 = new int[this.entryCount + 2];
        if (this.childPageIds != null) {
            System.arraycopy(this.childPageIds, 0, nArray2, 0, n + 1);
        }
        if (this.entryCount > 0) {
            System.arraycopy(this.keys, 0, nArray, 0, n);
            if (n < this.entryCount) {
                System.arraycopy(this.keys, n, nArray, n + 1, this.entryCount - n);
                System.arraycopy(this.childPageIds, n, nArray2, n + 1, this.entryCount - n + 1);
            }
        }
        nArray[n] = n3;
        nArray2[n + 1] = n2;
        this.keys = nArray;
        this.childPageIds = nArray2;
        ++this.entryCount;
    }

    int addRow(Row row) throws SQLException {
        int n;
        PageData pageData;
        int n2;
        while ((n2 = (pageData = this.index.getPage(this.childPageIds[n = this.find(row.getPos())])).addRow(row)) != 0) {
            int n3 = pageData.getKey(n2 - 1);
            PageData pageData2 = pageData.split(n2);
            this.index.getPageStore().updateRecord(pageData, true, pageData.data);
            this.index.getPageStore().updateRecord(pageData2, true, pageData2.data);
            this.addChild(n, pageData2.getPageId(), n3);
            int n4 = (this.index.getPageStore().getPageSize() - 15) / 8;
            if (this.entryCount >= n4) {
                return this.entryCount / 2;
            }
            this.index.getPageStore().updateRecord(this, true, this.data);
        }
        this.updateRowCount(1);
        return 0;
    }

    private void updateRowCount(int n) throws SQLException {
        if (this.rowCount != -1) {
            this.rowCount += n;
        }
        if (this.rowCountStored != -1) {
            this.rowCountStored = -1;
            this.index.getPageStore().updateRecord(this, true, this.data);
        }
    }

    Cursor find() throws SQLException {
        int n = this.childPageIds[0];
        return this.index.getPage(n).find();
    }

    PageData split(int n) throws SQLException {
        int n2 = this.index.getPageStore().allocatePage();
        PageDataNode pageDataNode = new PageDataNode(this.index, n2, this.parentPageId, this.index.getPageStore().createDataPage());
        int n3 = this.childPageIds[n];
        int n4 = n;
        while (n4 < this.entryCount) {
            pageDataNode.addChild(pageDataNode.entryCount, this.childPageIds[n + 1], this.keys[n]);
            this.removeChild(n);
        }
        n4 = this.childPageIds[n - 1];
        this.removeChild(n - 1);
        this.childPageIds[n - 1] = n4;
        pageDataNode.childPageIds[0] = n3;
        pageDataNode.remapChildren();
        return pageDataNode;
    }

    protected void remapChildren() throws SQLException {
        for (int n : this.childPageIds) {
            PageData pageData = this.index.getPage(n);
            pageData.setParentPageId(this.getPos());
            this.index.getPageStore().updateRecord(pageData, true, pageData.data);
        }
    }

    void init(PageData pageData, int n, PageData pageData2) {
        this.entryCount = 1;
        this.childPageIds = new int[]{pageData.getPageId(), pageData2.getPageId()};
        this.keys = new int[]{n};
        this.check();
    }

    int getLastKey() throws SQLException {
        return this.index.getPage(this.childPageIds[this.entryCount]).getLastKey();
    }

    PageDataLeaf getNextPage(int n) throws SQLException {
        int n2 = this.find(n) + 1;
        if (n2 > this.entryCount) {
            if (this.parentPageId == 0) {
                return null;
            }
            PageDataNode pageDataNode = (PageDataNode)this.index.getPage(this.parentPageId);
            return pageDataNode.getNextPage(n);
        }
        PageData pageData = this.index.getPage(this.childPageIds[n2]);
        return pageData.getFirstLeaf();
    }

    PageDataLeaf getFirstLeaf() throws SQLException {
        int n = this.childPageIds[0];
        return this.index.getPage(n).getFirstLeaf();
    }

    boolean remove(int n) throws SQLException {
        int n2 = this.find(n);
        PageData pageData = this.index.getPage(this.childPageIds[n2]);
        boolean bl = pageData.remove(n);
        this.updateRowCount(-1);
        if (!bl) {
            return false;
        }
        this.index.getPageStore().freePage(pageData.getPageId(), true, pageData.data);
        if (this.entryCount < 1) {
            return true;
        }
        this.removeChild(n2);
        this.index.getPageStore().updateRecord(this, true, this.data);
        return false;
    }

    Row getRow(Session session, int n) throws SQLException {
        int n2 = this.find(n);
        PageData pageData = this.index.getPage(this.childPageIds[n2]);
        return pageData.getRow(session, n);
    }

    int getRowCount() throws SQLException {
        if (this.rowCount == -1) {
            int n = 0;
            for (int n2 : this.childPageIds) {
                PageData pageData = this.index.getPage(n2);
                if (this.getPos() == pageData.getPos()) {
                    throw Message.throwInternalError("Page it its own child: " + this.getPageId());
                }
                n += pageData.getRowCount();
            }
            this.rowCount = n;
        }
        return this.rowCount;
    }

    void setRowCountStored(int n) throws SQLException {
        this.rowCount = n;
        if (this.rowCountStored != n) {
            this.rowCountStored = n;
            this.index.getPageStore().updateRecord(this, true, this.data);
        }
    }

    private void check() {
        for (int n : this.childPageIds) {
            if (n != 0) continue;
            Message.throwInternalError();
        }
    }

    public int getByteCount(DataPage dataPage) {
        return this.index.getPageStore().getPageSize();
    }

    public void write(DataPage dataPage) throws SQLException {
        this.check();
        this.data.reset();
        this.data.writeInt(this.parentPageId);
        this.data.writeByte((byte)2);
        this.data.writeShortInt(this.entryCount);
        this.data.writeInt(this.rowCountStored);
        this.data.writeInt(this.childPageIds[this.entryCount]);
        for (int i = 0; i < this.entryCount; ++i) {
            this.data.writeInt(this.childPageIds[i]);
            this.data.writeInt(this.keys[i]);
        }
        this.index.getPageStore().writePage(this.getPos(), this.data);
    }

    private void removeChild(int n) {
        --this.entryCount;
        if (this.entryCount < 0) {
            Message.throwInternalError();
        }
        int[] nArray = new int[this.entryCount];
        int[] nArray2 = new int[this.entryCount + 1];
        System.arraycopy(this.keys, 0, nArray, 0, Math.min(this.entryCount, n));
        System.arraycopy(this.childPageIds, 0, nArray2, 0, n);
        if (this.entryCount > n) {
            System.arraycopy(this.keys, n + 1, nArray, n, this.entryCount - n);
        }
        System.arraycopy(this.childPageIds, n + 1, nArray2, n, this.entryCount - n + 1);
        this.keys = nArray;
        this.childPageIds = nArray2;
    }

    public String toString() {
        return "page[" + this.getPos() + "] data node table:" + this.index.getId() + " entries:" + this.entryCount;
    }
}

