/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.text.CollationKey;
import java.text.Collator;
import java.util.Locale;
import org.h2.constant.SysProperties;
import org.h2.util.SmallLRUCache;
import org.h2.util.StringUtils;

public class CompareMode {
    public static final String OFF = "OFF";
    private final Collator collator;
    private final String name;
    private final SmallLRUCache collationKeys;

    public CompareMode(String string, int n) {
        this.collator = CompareMode.getCollator(string);
        int n2 = 0;
        if (this.collator != null) {
            this.collator.setStrength(n);
            n2 = SysProperties.getCollatorCacheSize();
        }
        this.collationKeys = n2 != 0 ? new SmallLRUCache(n2) : null;
        this.name = string == null ? OFF : string;
    }

    public boolean equalsChars(String string, int n, String string2, int n2, boolean bl) {
        if (this.collator != null) {
            return this.compareString(string.substring(n, n + 1), string2.substring(n2, n2 + 1), bl) == 0;
        }
        char c = string.charAt(n);
        char c2 = string2.charAt(n2);
        if (bl) {
            c = Character.toUpperCase(c);
            c2 = Character.toUpperCase(c2);
        }
        return c == c2;
    }

    public int compareString(String string, String string2, boolean bl) {
        int n;
        if (this.collator == null) {
            if (bl) {
                return string.compareToIgnoreCase(string2);
            }
            return string.compareTo(string2);
        }
        if (bl) {
            string = string.toUpperCase();
            string2 = string2.toUpperCase();
        }
        if (this.collationKeys != null) {
            CollationKey collationKey = this.getKey(string);
            CollationKey collationKey2 = this.getKey(string2);
            n = collationKey.compareTo(collationKey2);
        } else {
            n = this.collator.compare(string, string2);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CollationKey getKey(String string) {
        SmallLRUCache smallLRUCache = this.collationKeys;
        synchronized (smallLRUCache) {
            CollationKey collationKey = (CollationKey)this.collationKeys.get(string);
            if (collationKey == null) {
                collationKey = this.collator.getCollationKey(string);
                this.collationKeys.put(string, collationKey);
            }
            return collationKey;
        }
    }

    public static String getName(Locale locale) {
        Locale locale2 = Locale.ENGLISH;
        String string = locale.getDisplayLanguage(locale2) + ' ' + locale.getDisplayCountry(locale2) + ' ' + locale.getVariant();
        string = StringUtils.toUpperEnglish(string.trim().replace(' ', '_'));
        return string;
    }

    private static boolean compareLocaleNames(Locale locale, String string) {
        return string.equalsIgnoreCase(locale.toString()) || string.equalsIgnoreCase(CompareMode.getName(locale));
    }

    public static Collator getCollator(String string) {
        Object object;
        String string2;
        Locale locale;
        int n;
        Locale[] localeArray;
        if (string == null) {
            return null;
        }
        Collator collator = null;
        if (string.length() == 2) {
            localeArray = new Locale(string.toLowerCase(), "");
            if (CompareMode.compareLocaleNames((Locale)localeArray, string)) {
                collator = Collator.getInstance((Locale)localeArray);
            }
        } else if (string.length() == 5 && (n = string.indexOf(95)) >= 0 && CompareMode.compareLocaleNames(locale = new Locale(string2 = string.substring(0, n).toLowerCase(), (String)(object = string.substring(n + 1))), string)) {
            collator = Collator.getInstance(locale);
        }
        if (collator == null) {
            localeArray = Collator.getAvailableLocales();
            for (int i = 0; i < localeArray.length; ++i) {
                object = localeArray[i];
                if (!CompareMode.compareLocaleNames((Locale)object, string)) continue;
                collator = Collator.getInstance((Locale)object);
                break;
            }
        }
        return collator;
    }

    public String getName() {
        return this.name;
    }
}

