/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;

public class RandomUtils {
    static SecureRandom cachedSecureRandom;
    static volatile boolean seeded;
    private static final Random RANDOM;

    private RandomUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized SecureRandom getSecureRandom() {
        block10: {
            if (cachedSecureRandom != null) {
                return cachedSecureRandom;
            }
            try {
                cachedSecureRandom = SecureRandom.getInstance("SHA1PRNG");
                Runnable runnable = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
                            byte[] byArray = secureRandom.generateSeed(20);
                            SecureRandom secureRandom2 = cachedSecureRandom;
                            synchronized (secureRandom2) {
                                cachedSecureRandom.setSeed(byArray);
                                seeded = true;
                            }
                        }
                        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                            RandomUtils.warn("SecureRandom", noSuchAlgorithmException);
                        }
                    }
                };
                try {
                    Thread thread = new Thread(runnable);
                    thread.setDaemon(true);
                    thread.start();
                    Thread.yield();
                    try {
                        thread.join(400L);
                    }
                    catch (InterruptedException interruptedException) {
                        RandomUtils.warn("InterruptedException", interruptedException);
                    }
                    if (seeded) break block10;
                    byte[] byArray = RandomUtils.generateAlternativeSeed();
                    SecureRandom secureRandom = cachedSecureRandom;
                    synchronized (secureRandom) {
                        cachedSecureRandom.setSeed(byArray);
                    }
                }
                catch (SecurityException securityException) {
                    runnable.run();
                    RandomUtils.generateAlternativeSeed();
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                RandomUtils.warn("SecureRandom", noSuchAlgorithmException);
                cachedSecureRandom = new SecureRandom();
            }
        }
        return cachedSecureRandom;
    }

    private static byte[] generateAlternativeSeed() {
        try {
            Class<?> clazz;
            Object object;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeLong(System.currentTimeMillis());
            try {
                object = System.class.getMethod("nanoTime", new Class[0]);
                if (object != null) {
                    clazz = ((Method)object).invoke(null, (Object[])null);
                    dataOutputStream.writeUTF(((Object)clazz).toString());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            dataOutputStream.writeInt(new Object().hashCode());
            object = Runtime.getRuntime();
            dataOutputStream.writeLong(((Runtime)object).freeMemory());
            dataOutputStream.writeLong(((Runtime)object).maxMemory());
            dataOutputStream.writeLong(((Runtime)object).totalMemory());
            try {
                dataOutputStream.writeUTF(System.getProperties().toString());
            }
            catch (Exception exception) {
                RandomUtils.warn("generateAlternativeSeed", exception);
            }
            try {
                clazz = Class.forName("java.net.InetAddress");
                Object object2 = clazz.getMethod("getLocalHost", new Class[0]).invoke(null, new Object[0]);
                String string = clazz.getMethod("getHostName", new Class[0]).invoke(object2, new Object[0]).toString();
                dataOutputStream.writeUTF(string);
                Object[] objectArray = (Object[])clazz.getMethod("getAllByName", String.class).invoke(null, string);
                Method method = clazz.getMethod("getAddress", new Class[0]);
                for (int i = 0; i < objectArray.length; ++i) {
                    dataOutputStream.write((byte[])method.invoke(objectArray[i], new Object[0]));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            for (int i = 0; i < 16; ++i) {
                int n = 0;
                long l = System.currentTimeMillis();
                while (l == System.currentTimeMillis()) {
                    ++n;
                }
                dataOutputStream.writeInt(n);
            }
            dataOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            RandomUtils.warn("generateAlternativeSeed", iOException);
            return new byte[1];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getSecureLong() {
        SecureRandom secureRandom;
        SecureRandom secureRandom2 = secureRandom = RandomUtils.getSecureRandom();
        synchronized (secureRandom2) {
            return secureRandom.nextLong();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getSecureBytes(int n) {
        SecureRandom secureRandom;
        if (n <= 0) {
            n = 1;
        }
        byte[] byArray = new byte[n];
        SecureRandom secureRandom2 = secureRandom = RandomUtils.getSecureRandom();
        synchronized (secureRandom2) {
            secureRandom.nextBytes(byArray);
        }
        return byArray;
    }

    public static int nextInt(int n) {
        return RANDOM.nextInt(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int nextSecureInt(int n) {
        SecureRandom secureRandom;
        SecureRandom secureRandom2 = secureRandom = RandomUtils.getSecureRandom();
        synchronized (secureRandom2) {
            return secureRandom.nextInt(n);
        }
    }

    static void warn(String string, Throwable throwable) {
        System.out.println("RandomUtils warning: " + string);
        if (throwable != null) {
            throwable.printStackTrace();
        }
    }

    static {
        RANDOM = new Random();
    }
}

