/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.PatternSyntaxException;
import org.h2.command.Command;
import org.h2.command.Parser;
import org.h2.engine.Database;
import org.h2.engine.Mode;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.FunctionCall;
import org.h2.expression.FunctionInfo;
import org.h2.expression.SequenceValue;
import org.h2.expression.TableFunction;
import org.h2.expression.ValueExpression;
import org.h2.expression.Variable;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.Message;
import org.h2.schema.Sequence;
import org.h2.security.BlockCipher;
import org.h2.security.CipherFactory;
import org.h2.security.SHA256;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.LinkSchema;
import org.h2.table.TableFilter;
import org.h2.tools.CompressTool;
import org.h2.tools.Csv;
import org.h2.util.AutoCloseInputStream;
import org.h2.util.ByteUtils;
import org.h2.util.DateTimeIso8601Utils;
import org.h2.util.DateTimeUtils;
import org.h2.util.FileUtils;
import org.h2.util.MathUtils;
import org.h2.util.MemoryUtils;
import org.h2.util.ObjectArray;
import org.h2.util.ObjectUtils;
import org.h2.util.RandomUtils;
import org.h2.util.StringUtils;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDouble;
import org.h2.value.ValueInt;
import org.h2.value.ValueLob;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueResultSet;
import org.h2.value.ValueString;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueUuid;

public class Function
extends Expression
implements FunctionCall {
    public static final int ABS = 0;
    public static final int ACOS = 1;
    public static final int ASIN = 2;
    public static final int ATAN = 3;
    public static final int ATAN2 = 4;
    public static final int BITAND = 5;
    public static final int BITOR = 6;
    public static final int BITXOR = 7;
    public static final int CEILING = 8;
    public static final int COS = 9;
    public static final int COT = 10;
    public static final int DEGREES = 11;
    public static final int EXP = 12;
    public static final int FLOOR = 13;
    public static final int LOG = 14;
    public static final int LOG10 = 15;
    public static final int MOD = 16;
    public static final int PI = 17;
    public static final int POWER = 18;
    public static final int RADIANS = 19;
    public static final int RAND = 20;
    public static final int ROUND = 21;
    public static final int ROUNDMAGIC = 22;
    public static final int SIGN = 23;
    public static final int SIN = 24;
    public static final int SQRT = 25;
    public static final int TAN = 26;
    public static final int TRUNCATE = 27;
    public static final int SECURE_RAND = 28;
    public static final int HASH = 29;
    public static final int ENCRYPT = 30;
    public static final int DECRYPT = 31;
    public static final int COMPRESS = 32;
    public static final int EXPAND = 33;
    public static final int ZERO = 34;
    public static final int RANDOM_UUID = 35;
    public static final int ASCII = 50;
    public static final int BIT_LENGTH = 51;
    public static final int CHAR = 52;
    public static final int CHAR_LENGTH = 53;
    public static final int CONCAT = 54;
    public static final int DIFFERENCE = 55;
    public static final int HEXTORAW = 56;
    public static final int INSERT = 57;
    public static final int INSTR = 58;
    public static final int LCASE = 59;
    public static final int LEFT = 60;
    public static final int LENGTH = 61;
    public static final int LOCATE = 62;
    public static final int LTRIM = 63;
    public static final int OCTET_LENGTH = 64;
    public static final int RAWTOHEX = 65;
    public static final int REPEAT = 66;
    public static final int REPLACE = 67;
    public static final int RIGHT = 68;
    public static final int RTRIM = 69;
    public static final int SOUNDEX = 70;
    public static final int SPACE = 71;
    public static final int SUBSTR = 72;
    public static final int SUBSTRING = 73;
    public static final int UCASE = 74;
    public static final int LOWER = 75;
    public static final int UPPER = 76;
    public static final int POSITION = 77;
    public static final int TRIM = 78;
    public static final int STRINGENCODE = 79;
    public static final int STRINGDECODE = 80;
    public static final int STRINGTOUTF8 = 81;
    public static final int UTF8TOSTRING = 82;
    public static final int XMLATTR = 83;
    public static final int XMLNODE = 84;
    public static final int XMLCOMMENT = 85;
    public static final int XMLCDATA = 86;
    public static final int XMLSTARTDOC = 87;
    public static final int XMLTEXT = 88;
    public static final int REGEXP_REPLACE = 89;
    public static final int RPAD = 90;
    public static final int LPAD = 91;
    public static final int CURDATE = 100;
    public static final int CURTIME = 101;
    public static final int DATE_ADD = 102;
    public static final int DATE_DIFF = 103;
    public static final int DAY_NAME = 104;
    public static final int DAY_OF_MONTH = 105;
    public static final int DAY_OF_WEEK = 106;
    public static final int DAY_OF_YEAR = 107;
    public static final int HOUR = 108;
    public static final int MINUTE = 109;
    public static final int MONTH = 110;
    public static final int MONTH_NAME = 111;
    public static final int NOW = 112;
    public static final int QUARTER = 113;
    public static final int SECOND = 114;
    public static final int WEEK = 115;
    public static final int YEAR = 116;
    public static final int CURRENT_DATE = 117;
    public static final int CURRENT_TIME = 118;
    public static final int CURRENT_TIMESTAMP = 119;
    public static final int EXTRACT = 120;
    public static final int FORMATDATETIME = 121;
    public static final int PARSEDATETIME = 122;
    public static final int ISO_YEAR = 123;
    public static final int ISO_WEEK = 124;
    public static final int ISO_DAY_OF_WEEK = 125;
    public static final int DATABASE = 150;
    public static final int USER = 151;
    public static final int CURRENT_USER = 152;
    public static final int IDENTITY = 153;
    public static final int AUTOCOMMIT = 154;
    public static final int READONLY = 155;
    public static final int DATABASE_PATH = 156;
    public static final int LOCK_TIMEOUT = 157;
    public static final int IFNULL = 200;
    public static final int CASEWHEN = 201;
    public static final int CONVERT = 202;
    public static final int CAST = 203;
    public static final int COALESCE = 204;
    public static final int NULLIF = 205;
    public static final int CASE = 206;
    public static final int NEXTVAL = 207;
    public static final int CURRVAL = 208;
    public static final int ARRAY_GET = 209;
    public static final int CSVREAD = 210;
    public static final int CSVWRITE = 211;
    public static final int MEMORY_FREE = 212;
    public static final int MEMORY_USED = 213;
    public static final int LOCK_MODE = 214;
    public static final int SCHEMA = 215;
    public static final int SESSION_ID = 216;
    public static final int ARRAY_LENGTH = 217;
    public static final int LINK_SCHEMA = 218;
    public static final int GREATEST = 219;
    public static final int LEAST = 220;
    public static final int CANCEL_SESSION = 221;
    public static final int SET = 222;
    public static final int TABLE = 223;
    public static final int TABLE_DISTINCT = 224;
    public static final int FILE_READ = 225;
    public static final int TRANSACTION_ID = 226;
    private static final int VAR_ARGS = -1;
    private static final long PRECISION_UNKNOWN = -1L;
    private static final HashMap FUNCTIONS = new HashMap();
    private static final HashMap DATE_PART = new HashMap();
    private static final SimpleDateFormat FORMAT_DAYNAME = new SimpleDateFormat("EEEE", Locale.ENGLISH);
    private static final SimpleDateFormat FORMAT_MONTHNAME = new SimpleDateFormat("MMMM", Locale.ENGLISH);
    private static final char[] SOUNDEX_INDEX = new char[128];
    protected Expression[] args;
    private FunctionInfo info;
    private ObjectArray varArgs;
    private int dataType;
    private int scale;
    private long precision = -1L;
    private int displaySize;
    private Database database;

    protected Function(Database database, FunctionInfo functionInfo) {
        this.database = database;
        this.info = functionInfo;
        if (functionInfo.parameterCount == -1) {
            this.varArgs = new ObjectArray();
        } else {
            this.args = new Expression[functionInfo.parameterCount];
        }
    }

    private static void addFunction(String string, int n, int n2, int n3, boolean bl, boolean bl2) {
        FunctionInfo functionInfo = new FunctionInfo();
        functionInfo.name = string;
        functionInfo.type = n;
        functionInfo.parameterCount = n2;
        functionInfo.dataType = n3;
        functionInfo.nullIfParameterIsNull = bl;
        functionInfo.deterministic = bl2;
        FUNCTIONS.put(string, functionInfo);
    }

    private static void addFunctionNotDeterministic(String string, int n, int n2, int n3) {
        Function.addFunction(string, n, n2, n3, true, false);
    }

    private static void addFunction(String string, int n, int n2, int n3) {
        Function.addFunction(string, n, n2, n3, true, true);
    }

    private static void addFunctionWithNull(String string, int n, int n2, int n3) {
        Function.addFunction(string, n, n2, n3, false, true);
    }

    public static FunctionInfo getFunctionInfo(String string) {
        return (FunctionInfo)FUNCTIONS.get(string);
    }

    public static Function getFunction(Database database, String string) {
        FunctionInfo functionInfo = Function.getFunctionInfo(string);
        if (functionInfo == null) {
            return null;
        }
        switch (functionInfo.type) {
            case 223: 
            case 224: {
                return new TableFunction(database, functionInfo, Long.MAX_VALUE);
            }
        }
        return new Function(database, functionInfo);
    }

    public void setParameter(int n, Expression expression) throws SQLException {
        if (this.varArgs != null) {
            this.varArgs.add(expression);
        } else {
            if (n >= this.args.length) {
                throw Message.getSQLException(7001, new String[]{this.info.name, "" + this.args.length});
            }
            this.args[n] = expression;
        }
    }

    private strictfp double log10(double d) {
        return this.roundmagic(StrictMath.log(d) / StrictMath.log(10.0));
    }

    public Value getValue(Session session) throws SQLException {
        return this.getValueWithArgs(session, this.args);
    }

    private Value getNullOrValue(Session session, Expression[] expressionArray, int n) throws SQLException {
        Expression expression;
        if (n < expressionArray.length && (expression = expressionArray[n]) != null) {
            return expression.getValue(session);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Value getSimpleValue(Session session, Value value, Expression[] expressionArray) throws SQLException {
        Value value2;
        block4 : switch (this.info.type) {
            case 0: {
                value2 = value.getSignum() > 0 ? value : value.negate();
                break;
            }
            case 1: {
                value2 = ValueDouble.get(Math.acos(value.getDouble()));
                break;
            }
            case 2: {
                value2 = ValueDouble.get(Math.asin(value.getDouble()));
                break;
            }
            case 3: {
                value2 = ValueDouble.get(Math.atan(value.getDouble()));
                break;
            }
            case 8: {
                value2 = ValueDouble.get(Math.ceil(value.getDouble()));
                break;
            }
            case 9: {
                value2 = ValueDouble.get(Math.cos(value.getDouble()));
                break;
            }
            case 10: {
                double d = Math.tan(value.getDouble());
                if (d == 0.0) {
                    throw Message.getSQLException(22012, this.getSQL());
                }
                value2 = ValueDouble.get(1.0 / d);
                break;
            }
            case 11: {
                value2 = ValueDouble.get(Math.toDegrees(value.getDouble()));
                break;
            }
            case 12: {
                value2 = ValueDouble.get(Math.exp(value.getDouble()));
                break;
            }
            case 13: {
                value2 = ValueDouble.get(Math.floor(value.getDouble()));
                break;
            }
            case 14: {
                value2 = ValueDouble.get(Math.log(value.getDouble()));
                break;
            }
            case 15: {
                value2 = ValueDouble.get(this.log10(value.getDouble()));
                break;
            }
            case 17: {
                value2 = ValueDouble.get(Math.PI);
                break;
            }
            case 19: {
                value2 = ValueDouble.get(Math.toRadians(value.getDouble()));
                break;
            }
            case 20: {
                if (value != null) {
                    session.getRandom().setSeed(value.getInt());
                }
                value2 = ValueDouble.get(session.getRandom().nextDouble());
                break;
            }
            case 22: {
                value2 = ValueDouble.get(this.roundmagic(value.getDouble()));
                break;
            }
            case 23: {
                value2 = ValueInt.get(value.getSignum());
                break;
            }
            case 24: {
                value2 = ValueDouble.get(Math.sin(value.getDouble()));
                break;
            }
            case 25: {
                value2 = ValueDouble.get(Math.sqrt(value.getDouble()));
                break;
            }
            case 26: {
                value2 = ValueDouble.get(Math.tan(value.getDouble()));
                break;
            }
            case 28: {
                value2 = ValueBytes.getNoCopy(RandomUtils.getSecureBytes(value.getInt()));
                break;
            }
            case 33: {
                value2 = ValueBytes.getNoCopy(CompressTool.getInstance().expand(value.getBytesNoCopy()));
                break;
            }
            case 34: {
                value2 = ValueInt.get(0);
                break;
            }
            case 35: {
                value2 = ValueUuid.getNewRandom();
                break;
            }
            case 50: {
                String string = value.getString();
                if (string.length() == 0) {
                    value2 = ValueNull.INSTANCE;
                    break;
                }
                value2 = ValueInt.get(string.charAt(0));
                break;
            }
            case 51: {
                value2 = ValueInt.get(16 * this.length(value));
                break;
            }
            case 52: {
                value2 = ValueString.get(String.valueOf((char)value.getInt()));
                break;
            }
            case 53: 
            case 61: {
                value2 = ValueInt.get(this.length(value));
                break;
            }
            case 64: {
                value2 = ValueInt.get(2 * this.length(value));
                break;
            }
            case 54: {
                value2 = ValueNull.INSTANCE;
                for (int i = 0; i < expressionArray.length; ++i) {
                    Value value3 = expressionArray[i].getValue(session);
                    if (value3 == ValueNull.INSTANCE) continue;
                    value2 = value2 == ValueNull.INSTANCE ? value3 : ValueString.get(((Value)value2).getString().concat(value3.getString()));
                }
                break;
            }
            case 56: {
                value2 = ValueString.get(Function.hexToRaw(value.getString()));
                break;
            }
            case 59: 
            case 75: {
                value2 = ValueString.get(value.getString().toLowerCase());
                break;
            }
            case 65: {
                value2 = ValueString.get(Function.rawToHex(value.getString()));
                break;
            }
            case 70: {
                value2 = ValueString.get(Function.getSoundex(value.getString()));
                break;
            }
            case 71: {
                int n = Math.max(0, value.getInt());
                char[] cArray = new char[n];
                for (int i = n - 1; i >= 0; --i) {
                    cArray[i] = 32;
                }
                value2 = ValueString.get(new String(cArray));
                break;
            }
            case 74: 
            case 76: {
                value2 = ValueString.get(value.getString().toUpperCase());
                break;
            }
            case 79: {
                value2 = ValueString.get(StringUtils.javaEncode(value.getString()));
                break;
            }
            case 80: {
                value2 = ValueString.get(StringUtils.javaDecode(value.getString()));
                break;
            }
            case 81: {
                value2 = ValueBytes.getNoCopy(StringUtils.utf8Encode(value.getString()));
                break;
            }
            case 82: {
                value2 = ValueString.get(StringUtils.utf8Decode(value.getBytesNoCopy()));
                break;
            }
            case 85: {
                value2 = ValueString.get(StringUtils.xmlComment(value.getString()));
                break;
            }
            case 86: {
                value2 = ValueString.get(StringUtils.xmlCData(value.getString()));
                break;
            }
            case 87: {
                value2 = ValueString.get(StringUtils.xmlStartDoc());
                break;
            }
            case 88: {
                value2 = ValueString.get(StringUtils.xmlText(value.getString()));
                break;
            }
            case 104: {
                SimpleDateFormat simpleDateFormat = FORMAT_DAYNAME;
                synchronized (simpleDateFormat) {
                    value2 = ValueString.get(FORMAT_DAYNAME.format(value.getDateNoCopy()));
                    break;
                }
            }
            case 105: {
                value2 = ValueInt.get(DateTimeUtils.getDatePart(value.getDateNoCopy(), 5));
                break;
            }
            case 106: {
                value2 = ValueInt.get(DateTimeUtils.getDatePart(value.getDateNoCopy(), 7));
                break;
            }
            case 107: {
                value2 = ValueInt.get(DateTimeUtils.getDatePart(value.getDateNoCopy(), 6));
                break;
            }
            case 108: {
                value2 = ValueInt.get(DateTimeUtils.getDatePart(value.getTimestampNoCopy(), 11));
                break;
            }
            case 109: {
                value2 = ValueInt.get(DateTimeUtils.getDatePart(value.getTimestampNoCopy(), 12));
                break;
            }
            case 110: {
                value2 = ValueInt.get(DateTimeUtils.getDatePart(value.getDateNoCopy(), 2));
                break;
            }
            case 111: {
                SimpleDateFormat simpleDateFormat = FORMAT_MONTHNAME;
                synchronized (simpleDateFormat) {
                    value2 = ValueString.get(FORMAT_MONTHNAME.format(value.getDateNoCopy()));
                    break;
                }
            }
            case 113: {
                value2 = ValueInt.get((DateTimeUtils.getDatePart(value.getDateNoCopy(), 2) - 1) / 3 + 1);
                break;
            }
            case 114: {
                value2 = ValueInt.get(DateTimeUtils.getDatePart(value.getTimestampNoCopy(), 13));
                break;
            }
            case 115: {
                value2 = ValueInt.get(DateTimeUtils.getDatePart(value.getDateNoCopy(), 3));
                break;
            }
            case 116: {
                value2 = ValueInt.get(DateTimeUtils.getDatePart(value.getDateNoCopy(), 1));
                break;
            }
            case 123: {
                value2 = ValueInt.get(DateTimeIso8601Utils.getIsoYear(value.getDateNoCopy()));
                break;
            }
            case 124: {
                value2 = ValueInt.get(DateTimeIso8601Utils.getIsoWeek(value.getDateNoCopy()));
                break;
            }
            case 125: {
                value2 = ValueInt.get(DateTimeIso8601Utils.getIsoDayOfWeek(value.getDateNoCopy()));
                break;
            }
            case 100: 
            case 117: {
                value2 = ValueDate.get(new Date(System.currentTimeMillis()));
                break;
            }
            case 101: 
            case 118: {
                value2 = ValueTime.get(new Time(System.currentTimeMillis()));
                break;
            }
            case 112: 
            case 119: {
                ValueTimestamp valueTimestamp = ValueTimestamp.getNoCopy(new Timestamp(System.currentTimeMillis()));
                if (value != null) {
                    Mode mode = this.database.getMode();
                    valueTimestamp = (ValueTimestamp)valueTimestamp.convertScale(mode.convertOnlyToSmallerScale, value.getInt());
                }
                value2 = valueTimestamp;
                break;
            }
            case 150: {
                value2 = ValueString.get(this.database.getShortName());
                break;
            }
            case 151: 
            case 152: {
                value2 = ValueString.get(session.getUser().getName());
                break;
            }
            case 153: {
                value2 = session.getLastIdentity();
                break;
            }
            case 154: {
                value2 = ValueBoolean.get(session.getAutoCommit());
                break;
            }
            case 155: {
                value2 = ValueBoolean.get(this.database.getReadOnly());
                break;
            }
            case 156: {
                String string = this.database.getDatabasePath();
                value2 = string == null ? ValueNull.INSTANCE : ValueString.get(string);
                break;
            }
            case 157: {
                value2 = ValueInt.get(session.getLockTimeout());
                break;
            }
            case 202: 
            case 203: {
                value = value.convertTo(this.dataType);
                Mode mode = this.database.getMode();
                value = value.convertScale(mode.convertOnlyToSmallerScale, this.scale);
                value = value.convertPrecision(this.getPrecision());
                value2 = value;
                break;
            }
            case 212: {
                session.getUser().checkAdmin();
                value2 = ValueInt.get(MemoryUtils.getMemoryFree());
                break;
            }
            case 213: {
                session.getUser().checkAdmin();
                value2 = ValueInt.get(MemoryUtils.getMemoryUsed());
                break;
            }
            case 214: {
                value2 = ValueInt.get(this.database.getLockMode());
                break;
            }
            case 215: {
                value2 = ValueString.get(session.getCurrentSchemaName());
                break;
            }
            case 216: {
                value2 = ValueInt.get(session.getId());
                break;
            }
            case 200: {
                value2 = value == ValueNull.INSTANCE ? expressionArray[1].getValue(session) : value;
                break;
            }
            case 201: {
                Expression expression = value == ValueNull.INSTANCE || value.getBoolean() == false ? expressionArray[2] : expressionArray[1];
                Value value4 = expression.getValue(session);
                value2 = value4.convertTo(this.dataType);
                break;
            }
            case 204: {
                value2 = value;
                for (int i = 0; i < expressionArray.length; ++i) {
                    Value value5;
                    Value value6 = value5 = i == 0 ? value : expressionArray[i].getValue(session);
                    if (value5 == ValueNull.INSTANCE) continue;
                    value2 = value5.convertTo(this.dataType);
                    break block4;
                }
                break;
            }
            case 219: 
            case 220: {
                value2 = ValueNull.INSTANCE;
                for (int i = 0; i < expressionArray.length; ++i) {
                    Value value7;
                    Value value8 = value7 = i == 0 ? value : expressionArray[i].getValue(session);
                    if (value7 == ValueNull.INSTANCE) continue;
                    value7 = value7.convertTo(this.dataType);
                    if (value2 == ValueNull.INSTANCE) {
                        value2 = value7;
                        continue;
                    }
                    int n = this.database.compareTypeSave(value2, value7);
                    if (this.info.type == 219 && n < 0) {
                        value2 = value7;
                        continue;
                    }
                    if (this.info.type != 220 || n <= 0) continue;
                    value2 = value7;
                }
                break;
            }
            case 206: {
                int n;
                value2 = null;
                for (n = 0; n < expressionArray.length; ++n) {
                    Value value9;
                    if (!Boolean.TRUE.equals(value9 = expressionArray[n++].getValue(session))) continue;
                    value2 = expressionArray[n].getValue(session);
                    break;
                }
                if (value2 != null) break;
                value2 = n < expressionArray.length ? expressionArray[n].getValue(session) : ValueNull.INSTANCE;
                break;
            }
            case 209: {
                if (value.getType() == 17) {
                    Value value10 = expressionArray[1].getValue(session);
                    int n = value10.getInt();
                    Value[] valueArray = ((ValueArray)value).getList();
                    if (n < 1 || n > valueArray.length) {
                        value2 = ValueNull.INSTANCE;
                        break;
                    }
                    value2 = valueArray[n - 1];
                    break;
                }
                value2 = ValueNull.INSTANCE;
                break;
            }
            case 217: {
                if (value.getType() == 17) {
                    Value[] valueArray = ((ValueArray)value).getList();
                    value2 = ValueInt.get(valueArray.length);
                    break;
                }
                value2 = ValueNull.INSTANCE;
                break;
            }
            case 221: {
                value2 = ValueBoolean.get(this.cancelStatement(session, value.getInt()));
                break;
            }
            case 226: {
                value2 = session.getTransactionId();
                break;
            }
            default: {
                value2 = null;
            }
        }
        return value2;
    }

    private boolean cancelStatement(Session session, int n) throws SQLException {
        session.getUser().checkAdmin();
        Session[] sessionArray = session.getDatabase().getSessions(false);
        for (int i = 0; i < sessionArray.length; ++i) {
            Session session2 = sessionArray[i];
            if (session2.getId() != n) continue;
            Command command = session2.getCurrentCommand();
            if (command == null) {
                return false;
            }
            command.cancel();
            return true;
        }
        return false;
    }

    private Value getValueWithArgs(Session session, Expression[] expressionArray) throws SQLException {
        Value value;
        Value value2;
        Value value3;
        if (this.info.nullIfParameterIsNull) {
            for (int i = 0; i < expressionArray.length; ++i) {
                if (this.getNullOrValue(session, expressionArray, i) != ValueNull.INSTANCE) continue;
                return ValueNull.INSTANCE;
            }
        }
        if ((value3 = this.getSimpleValue(session, value2 = this.getNullOrValue(session, expressionArray, 0), expressionArray)) != null) {
            return value3;
        }
        Value value4 = this.getNullOrValue(session, expressionArray, 1);
        Value value5 = this.getNullOrValue(session, expressionArray, 2);
        Value value6 = this.getNullOrValue(session, expressionArray, 3);
        Value value7 = this.getNullOrValue(session, expressionArray, 4);
        Value value8 = this.getNullOrValue(session, expressionArray, 5);
        switch (this.info.type) {
            case 4: {
                value = ValueDouble.get(Math.atan2(value2.getDouble(), value4.getDouble()));
                break;
            }
            case 5: {
                value = ValueLong.get(value2.getLong() & value4.getLong());
                break;
            }
            case 6: {
                value = ValueLong.get(value2.getLong() | value4.getLong());
                break;
            }
            case 7: {
                value = ValueLong.get(value2.getLong() ^ value4.getLong());
                break;
            }
            case 16: {
                long l = value4.getLong();
                if (l == 0L) {
                    throw Message.getSQLException(22012, this.getSQL());
                }
                value = ValueLong.get(value2.getLong() % l);
                break;
            }
            case 18: {
                value = ValueDouble.get(Math.pow(value2.getDouble(), value4.getDouble()));
                break;
            }
            case 21: {
                double d = Math.pow(10.0, value4.getDouble());
                value = ValueDouble.get((double)Math.round(value2.getDouble() * d) / d);
                break;
            }
            case 27: {
                double d = value2.getDouble();
                int n = value4.getInt();
                double d2 = Math.pow(10.0, n);
                double d3 = d * d2;
                value = ValueDouble.get((d < 0.0 ? Math.ceil(d3) : Math.floor(d3)) / d2);
                break;
            }
            case 29: {
                value = ValueBytes.getNoCopy(this.getHash(value2.getString(), value4.getBytesNoCopy(), value5.getInt()));
                break;
            }
            case 30: {
                value = ValueBytes.getNoCopy(this.encrypt(value2.getString(), value4.getBytesNoCopy(), value5.getBytesNoCopy()));
                break;
            }
            case 31: {
                value = ValueBytes.getNoCopy(this.decrypt(value2.getString(), value4.getBytesNoCopy(), value5.getBytesNoCopy()));
                break;
            }
            case 32: {
                String string = null;
                if (value4 != null) {
                    string = value4.getString();
                }
                value = ValueBytes.getNoCopy(CompressTool.getInstance().compress(value2.getBytesNoCopy(), string));
                break;
            }
            case 55: {
                value = ValueInt.get(Function.getDifference(value2.getString(), value4.getString()));
                break;
            }
            case 57: {
                if (value4 == ValueNull.INSTANCE || value5 == ValueNull.INSTANCE) {
                    value = value4;
                    break;
                }
                value = ValueString.get(Function.insert(value2.getString(), value4.getInt(), value5.getInt(), value6.getString()));
                break;
            }
            case 60: {
                value = ValueString.get(Function.left(value2.getString(), value4.getInt()));
                break;
            }
            case 62: {
                int n = value5 == null ? 0 : value5.getInt();
                value = ValueInt.get(Function.locate(value2.getString(), value4.getString(), n));
                break;
            }
            case 58: {
                int n = value5 == null ? 0 : value5.getInt();
                value = ValueInt.get(Function.locate(value4.getString(), value2.getString(), n));
                break;
            }
            case 66: {
                int n = Math.max(0, value4.getInt());
                value = ValueString.get(Function.repeat(value2.getString(), n));
                break;
            }
            case 67: {
                String string = value2 == ValueNull.INSTANCE ? "" : value2.getString();
                String string2 = value4 == ValueNull.INSTANCE ? "" : value4.getString();
                String string3 = value5 == null || value5 == ValueNull.INSTANCE ? "" : value5.getString();
                value = ValueString.get(Function.replace(string, string2, string3));
                break;
            }
            case 68: {
                value = ValueString.get(Function.right(value2.getString(), value4.getInt()));
                break;
            }
            case 63: {
                value = ValueString.get(StringUtils.trim(value2.getString(), true, false, value4 == null ? " " : value4.getString()));
                break;
            }
            case 78: {
                value = ValueString.get(StringUtils.trim(value2.getString(), true, true, value4 == null ? " " : value4.getString()));
                break;
            }
            case 69: {
                value = ValueString.get(StringUtils.trim(value2.getString(), false, true, value4 == null ? " " : value4.getString()));
                break;
            }
            case 72: 
            case 73: {
                String string = value2.getString();
                int n = value5 == null ? string.length() : value5.getInt();
                value = ValueString.get(Function.substring(string, value4.getInt(), n));
                break;
            }
            case 77: {
                value = ValueInt.get(Function.locate(value2.getString(), value4.getString(), 0));
                break;
            }
            case 83: {
                value = ValueString.get(StringUtils.xmlAttr(value2.getString(), value4.getString()));
                break;
            }
            case 84: {
                String string;
                String string4 = value4 == null ? null : (string = value4 == ValueNull.INSTANCE ? null : value4.getString());
                String string5 = value5 == null ? null : (value5 == ValueNull.INSTANCE ? null : value5.getString());
                value = ValueString.get(StringUtils.xmlNode(value2.getString(), string, string5));
                break;
            }
            case 89: {
                String string = value4.getString();
                try {
                    value = ValueString.get(value2.getString().replaceAll(string, value5.getString()));
                    break;
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw Message.getSQLException(22025, new String[]{string}, patternSyntaxException);
                }
            }
            case 90: {
                value = ValueString.get(StringUtils.pad(value2.getString(), value4.getInt(), value5 == null ? null : value5.getString(), true));
                break;
            }
            case 91: {
                value = ValueString.get(StringUtils.pad(value2.getString(), value4.getInt(), value5 == null ? null : value5.getString(), false));
                break;
            }
            case 102: {
                value = ValueTimestamp.getNoCopy(Function.dateadd(value2.getString(), value4.getInt(), value5.getTimestampNoCopy()));
                break;
            }
            case 103: {
                value = ValueLong.get(Function.datediff(value2.getString(), value4.getTimestampNoCopy(), value5.getTimestampNoCopy()));
                break;
            }
            case 120: {
                int n = Function.getDatePart(value2.getString());
                value = ValueInt.get(DateTimeUtils.getDatePart(value4.getTimestamp(), n));
                break;
            }
            case 121: {
                String string;
                if (value2 == ValueNull.INSTANCE || value4 == ValueNull.INSTANCE) {
                    value = ValueNull.INSTANCE;
                    break;
                }
                String string6 = value5 == null ? null : (string = value5 == ValueNull.INSTANCE ? null : value5.getString());
                String string7 = value6 == null ? null : (value6 == ValueNull.INSTANCE ? null : value6.getString());
                value = ValueString.get(StringUtils.formatDateTime(value2.getTimestamp(), value4.getString(), string, string7));
                break;
            }
            case 122: {
                String string;
                if (value2 == ValueNull.INSTANCE || value4 == ValueNull.INSTANCE) {
                    value = ValueNull.INSTANCE;
                    break;
                }
                String string8 = value5 == null ? null : (string = value5 == ValueNull.INSTANCE ? null : value5.getString());
                String string9 = value6 == null ? null : (value6 == ValueNull.INSTANCE ? null : value6.getString());
                java.util.Date date = StringUtils.parseDateTime(value2.getString(), value4.getString(), string, string9);
                value = ValueTimestamp.getNoCopy(new Timestamp(date.getTime()));
                break;
            }
            case 205: {
                value = this.database.areEqual(value2, value4) ? ValueNull.INSTANCE : value2;
                break;
            }
            case 207: {
                Sequence sequence = this.getSequence(session, value2, value4);
                SequenceValue sequenceValue = new SequenceValue(sequence);
                value = sequenceValue.getValue(session);
                break;
            }
            case 208: {
                Sequence sequence = this.getSequence(session, value2, value4);
                value = ValueLong.get(sequence.getCurrentValue());
                break;
            }
            case 210: {
                String string = value2.getString();
                String string10 = value4 == null ? null : value4.getString();
                String string11 = value5 == null ? null : value5.getString();
                String string12 = value6 == null ? null : value6.getString();
                String string13 = value7 == null ? null : value7.getString();
                String string14 = value8 == null ? null : value8.getString();
                Value value9 = this.getNullOrValue(session, expressionArray, 6);
                String string15 = value9 == null ? null : value9.getString();
                Csv csv = Csv.getInstance();
                this.setCsvDelimiterEscape(csv, string12, string13, string14);
                csv.setNullString(string15);
                char c = csv.getFieldSeparatorRead();
                String[] stringArray = StringUtils.arraySplit(string10, c, true);
                ValueResultSet valueResultSet = ValueResultSet.get(csv.read(string, stringArray, string11));
                value = valueResultSet;
                break;
            }
            case 218: {
                session.getUser().checkAdmin();
                JdbcConnection jdbcConnection = session.createConnection(false);
                ResultSet resultSet = LinkSchema.linkSchema(jdbcConnection, value2.getString(), value4.getString(), value5.getString(), value6.getString(), value7.getString(), value8.getString());
                value = ValueResultSet.get(resultSet);
                break;
            }
            case 211: {
                session.getUser().checkAdmin();
                JdbcConnection jdbcConnection = session.createConnection(false);
                String string = value5 == null ? null : value5.getString();
                String string16 = value6 == null ? null : value6.getString();
                String string17 = value7 == null ? null : value7.getString();
                String string18 = value8 == null ? null : value8.getString();
                Value value10 = this.getNullOrValue(session, expressionArray, 6);
                String string19 = value10 == null ? null : value10.getString();
                Value value11 = this.getNullOrValue(session, expressionArray, 7);
                String string20 = value11 == null ? null : value11.getString();
                Csv csv = Csv.getInstance();
                this.setCsvDelimiterEscape(csv, string16, string17, string18);
                csv.setNullString(string19);
                if (string20 != null) {
                    csv.setLineSeparator(string20);
                }
                int n = csv.write(jdbcConnection, value2.getString(), value4.getString(), string);
                value = ValueInt.get(n);
                break;
            }
            case 222: {
                Variable variable = (Variable)expressionArray[0];
                session.setVariable(variable.getName(), value4);
                value = value4;
                break;
            }
            case 225: {
                session.getUser().checkAdmin();
                String string = value2.getString();
                boolean bl = expressionArray.length == 1;
                try {
                    AutoCloseInputStream autoCloseInputStream = new AutoCloseInputStream(FileUtils.openFileInputStream(string));
                    if (bl) {
                        value = ValueLob.createBlob(autoCloseInputStream, -1L, this.database);
                        break;
                    }
                    InputStreamReader inputStreamReader = value4 == ValueNull.INSTANCE ? new InputStreamReader(autoCloseInputStream) : new InputStreamReader((InputStream)autoCloseInputStream, value4.getString());
                    value = ValueLob.createClob(inputStreamReader, -1L, this.database);
                    break;
                }
                catch (IOException iOException) {
                    throw Message.convertIOException(iOException, string);
                }
            }
            default: {
                throw Message.throwInternalError("type=" + this.info.type);
            }
        }
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Sequence getSequence(Session session, Value value, Value value2) throws SQLException {
        String string;
        String string2;
        if (value2 == null) {
            Parser parser = new Parser(session);
            String string3 = value.getString();
            Expression expression = parser.parseExpression(string3);
            if (!(expression instanceof ExpressionColumn)) throw Message.getSyntaxError(string3, 1);
            ExpressionColumn expressionColumn = (ExpressionColumn)expression;
            string2 = expressionColumn.getOriginalTableAliasName();
            if (string2 == null) {
                string2 = session.getCurrentSchemaName();
            } else if (string2.equals(StringUtils.toLowerEnglish(string2))) {
                string2 = StringUtils.toUpperEnglish(string2);
            }
            string = expressionColumn.getColumnName();
            if (!string.equals(StringUtils.toLowerEnglish(string))) return this.database.getSchema(string2).getSequence(string);
            string = StringUtils.toUpperEnglish(string);
            return this.database.getSchema(string2).getSequence(string);
        } else {
            string2 = value.getString();
            string = value2.getString();
        }
        return this.database.getSchema(string2).getSequence(string);
    }

    private int length(Value value) {
        switch (value.getType()) {
            case 12: 
            case 15: 
            case 16: 
            case 19: {
                return (int)value.getPrecision();
            }
        }
        return value.getString().length();
    }

    private byte[] getPaddedArrayCopy(byte[] byArray, int n) {
        int n2 = MathUtils.roundUp(byArray.length, n);
        byte[] byArray2 = ByteUtils.newBytes(n2);
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    private byte[] decrypt(String string, byte[] byArray, byte[] byArray2) throws SQLException {
        BlockCipher blockCipher = CipherFactory.getBlockCipher(string);
        byte[] byArray3 = this.getPaddedArrayCopy(byArray, blockCipher.getKeyLength());
        blockCipher.setKey(byArray3);
        byte[] byArray4 = this.getPaddedArrayCopy(byArray2, 16);
        blockCipher.decrypt(byArray4, 0, byArray4.length);
        return byArray4;
    }

    private byte[] encrypt(String string, byte[] byArray, byte[] byArray2) throws SQLException {
        BlockCipher blockCipher = CipherFactory.getBlockCipher(string);
        byte[] byArray3 = this.getPaddedArrayCopy(byArray, blockCipher.getKeyLength());
        blockCipher.setKey(byArray3);
        byte[] byArray4 = this.getPaddedArrayCopy(byArray2, 16);
        blockCipher.encrypt(byArray4, 0, byArray4.length);
        return byArray4;
    }

    private byte[] getHash(String string, byte[] byArray, int n) throws SQLException {
        SHA256 sHA256 = CipherFactory.getHash(string);
        for (int i = 0; i < n; ++i) {
            byArray = sHA256.getHash(byArray, false);
        }
        return byArray;
    }

    public static boolean isDatePart(String string) {
        Integer n = (Integer)DATE_PART.get(StringUtils.toUpperEnglish(string));
        return n != null;
    }

    private static int getDatePart(String string) throws SQLException {
        Integer n = (Integer)DATE_PART.get(StringUtils.toUpperEnglish(string));
        if (n == null) {
            throw Message.getSQLException(90008, new String[]{"date part", string});
        }
        return n;
    }

    private static Timestamp dateadd(String string, int n, Timestamp timestamp) throws SQLException {
        int n2 = Function.getDatePart(string);
        Calendar calendar = Calendar.getInstance();
        int n3 = timestamp.getNanos() % 1000000;
        calendar.setTime(timestamp);
        calendar.add(n2, n);
        long l = calendar.getTime().getTime();
        Timestamp timestamp2 = new Timestamp(l);
        timestamp2.setNanos(timestamp2.getNanos() + n3);
        return timestamp2;
    }

    private static long datediff(String string, Timestamp timestamp, Timestamp timestamp2) throws SQLException {
        int n = Function.getDatePart(string);
        Calendar calendar = Calendar.getInstance();
        long l = timestamp.getTime();
        long l2 = timestamp2.getTime();
        TimeZone timeZone = calendar.getTimeZone();
        calendar.setTime(timestamp);
        l += (long)timeZone.getOffset(calendar.get(0), calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(7), calendar.get(14));
        calendar.setTime(timestamp2);
        l2 += (long)timeZone.getOffset(calendar.get(0), calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(7), calendar.get(14));
        switch (n) {
            case 14: {
                return l2 - l;
            }
            case 11: 
            case 12: 
            case 13: {
                long l3 = 3600000L;
                long l4 = Math.min(l / l3 * l3, l2 / l3 * l3);
                l -= l4;
                l2 -= l4;
                switch (n) {
                    case 13: {
                        return l2 / 1000L - l / 1000L;
                    }
                    case 12: {
                        return l2 / 60000L - l / 60000L;
                    }
                    case 11: {
                        return l2 / l3 - l / l3;
                    }
                }
                throw Message.throwInternalError("field:" + n);
            }
            case 5: {
                return l2 / 86400000L - l / 86400000L;
            }
        }
        calendar.setTime(new Timestamp(l));
        int n2 = calendar.get(1);
        int n3 = calendar.get(2);
        calendar.setTime(new Timestamp(l2));
        int n4 = calendar.get(1);
        int n5 = calendar.get(2);
        int n6 = n4 - n2;
        if (n == 2) {
            n6 = 12 * n6 + (n5 - n3);
        }
        return n6;
    }

    private static String substring(String string, int n, int n2) {
        int n3 = string.length();
        if (--n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        int n4 = n = n > n3 ? n3 : n;
        if (n + n2 > n3) {
            n2 = n3 - n;
        }
        return string.substring(n, n + n2);
    }

    private static String replace(String string, String string2, String string3) {
        int n;
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n2 = 0;
        int n3 = string2.length();
        while ((n = string.indexOf(string2, n2)) != -1) {
            stringBuffer.append(string.substring(n2, n));
            stringBuffer.append(string3);
            n2 = n + n3;
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    private static String repeat(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string.length() * n);
        while (n-- > 0) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private static String rawToHex(String string) {
        StringBuffer stringBuffer = new StringBuffer(4 * string.length());
        for (int i = 0; i < string.length(); ++i) {
            String string2 = Integer.toHexString(string.charAt(i) & 0xFFFF);
            for (int j = string2.length(); j < 4; ++j) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private static int locate(String string, String string2, int n) {
        if (n < 0) {
            int n2 = string2.length() + n;
            return string2.lastIndexOf(string, n2) + 1;
        }
        int n3 = n == 0 ? 0 : n - 1;
        return string2.indexOf(string, n3) + 1;
    }

    private static String right(String string, int n) {
        if (n < 0) {
            n = 0;
        } else if (n > string.length()) {
            n = string.length();
        }
        return string.substring(string.length() - n);
    }

    private static String left(String string, int n) {
        if (n < 0) {
            n = 0;
        } else if (n > string.length()) {
            n = string.length();
        }
        return string.substring(0, n);
    }

    private static String insert(String string, int n, int n2, String string2) {
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        int n3 = string.length();
        int n4 = string2.length();
        if (--n < 0 || n2 <= 0 || n4 == 0 || n > n3) {
            return string;
        }
        if (n + n2 > n3) {
            n2 = n3 - n;
        }
        return string.substring(0, n) + string2 + string.substring(n + n2);
    }

    private static String hexToRaw(String string) throws SQLException {
        int n = string.length();
        if (n % 4 != 0) {
            throw Message.getSQLException(90021, string);
        }
        StringBuffer stringBuffer = new StringBuffer(n / 4);
        for (int i = 0; i < n; i += 4) {
            try {
                char c = (char)Integer.parseInt(string.substring(i, i + 4), 16);
                stringBuffer.append(c);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw Message.getSQLException(90021, string);
            }
        }
        return stringBuffer.toString();
    }

    private static int getDifference(String string, String string2) {
        string = Function.getSoundex(string);
        string2 = Function.getSoundex(string2);
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            if (string.charAt(i) != string2.charAt(i)) continue;
            ++n;
        }
        return n;
    }

    private double roundmagic(double d) {
        if (d < 1.0E-13 && d > -1.0E-13) {
            return 0.0;
        }
        if (d > 1.0E12 || d < -1.0E12) {
            return d;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(d);
        if (stringBuffer.toString().indexOf("E") >= 0) {
            return d;
        }
        int n = stringBuffer.length();
        if (n < 16) {
            return d;
        }
        if (stringBuffer.toString().indexOf(".") > n - 3) {
            return d;
        }
        stringBuffer.delete(n - 2, n);
        char c = stringBuffer.charAt((n -= 2) - 2);
        char c2 = stringBuffer.charAt(n - 3);
        char c3 = stringBuffer.charAt(n - 4);
        if (c == '0' && c2 == '0' && c3 == '0') {
            stringBuffer.setCharAt(n - 1, '0');
        } else if (c == '9' && c2 == '9' && c3 == '9') {
            stringBuffer.setCharAt(n - 1, '9');
            stringBuffer.append('9');
            stringBuffer.append('9');
            stringBuffer.append('9');
        }
        return Double.valueOf(stringBuffer.toString());
    }

    private static String getSoundex(String string) {
        int n = string.length();
        char[] cArray = new char[]{'0', '0', '0', '0'};
        char c = '0';
        int n2 = 0;
        for (int i = 0; i < n && n2 < 4; ++i) {
            char c2;
            char c3 = string.charAt(i);
            char c4 = c2 = c3 > SOUNDEX_INDEX.length ? (char)'\u0000' : SOUNDEX_INDEX[c3];
            if (c2 == '\u0000') continue;
            if (n2 == 0) {
                cArray[n2++] = c3;
                c = c2;
                continue;
            }
            if (c2 <= '6') {
                if (c2 == c) continue;
                cArray[n2++] = c2;
                c = c2;
                continue;
            }
            if (c2 != '7') continue;
            c = c2;
        }
        return new String(cArray);
    }

    public int getType() {
        return this.dataType;
    }

    public void mapColumns(ColumnResolver columnResolver, int n) throws SQLException {
        for (int i = 0; i < this.args.length; ++i) {
            this.args[i].mapColumns(columnResolver, n);
        }
    }

    protected void checkParameterCount(int n) throws SQLException {
        boolean bl;
        int n2 = 0;
        int n3 = Integer.MAX_VALUE;
        switch (this.info.type) {
            case 204: 
            case 210: 
            case 219: 
            case 220: {
                n2 = 1;
                break;
            }
            case 20: 
            case 112: 
            case 119: {
                n3 = 1;
                break;
            }
            case 32: 
            case 63: 
            case 69: 
            case 78: 
            case 225: {
                n2 = 1;
                n3 = 2;
                break;
            }
            case 58: 
            case 62: 
            case 67: 
            case 72: 
            case 73: 
            case 90: 
            case 91: {
                n2 = 2;
                n3 = 3;
                break;
            }
            case 54: 
            case 206: 
            case 211: {
                n2 = 2;
                break;
            }
            case 84: {
                n2 = 1;
                n3 = 3;
                break;
            }
            case 121: 
            case 122: {
                n2 = 2;
                n3 = 4;
                break;
            }
            case 207: 
            case 208: {
                n2 = 1;
                n3 = 2;
                break;
            }
            default: {
                Message.throwInternalError("type=" + this.info.type);
            }
        }
        boolean bl2 = bl = n >= n2 && n <= n3;
        if (!bl) {
            throw Message.getSQLException(7001, new String[]{this.info.name, n2 + ".." + n3});
        }
    }

    public void doneWithParameters() throws SQLException {
        if (this.info.parameterCount == -1) {
            int n = this.varArgs.size();
            this.checkParameterCount(n);
            this.args = new Expression[n];
            this.varArgs.toArray(this.args);
            this.varArgs = null;
        } else {
            int n = this.args.length;
            if (n > 0 && this.args[n - 1] == null) {
                throw Message.getSQLException(7001, new String[]{this.info.name, "" + n});
            }
        }
    }

    public void setDataType(int n, long l, int n2, int n3) {
        this.dataType = n;
        this.precision = l;
        this.displaySize = n3;
        this.scale = n2;
    }

    public void setDataType(Column column) {
        this.dataType = column.getType();
        this.precision = column.getPrecision();
        this.displaySize = column.getDisplaySize();
        this.scale = column.getScale();
    }

    public Expression optimize(Session session) throws SQLException {
        int n;
        long l;
        int n2;
        int n3;
        boolean bl = this.info.deterministic;
        for (n3 = 0; n3 < this.args.length; ++n3) {
            Expression expression;
            this.args[n3] = expression = this.args[n3].optimize(session);
            if (expression.isConstant()) continue;
            bl = false;
        }
        Expression expression = this.args.length < 1 ? null : this.args[0];
        switch (this.info.type) {
            case 200: 
            case 204: 
            case 205: 
            case 219: 
            case 220: {
                n3 = -1;
                n2 = 0;
                l = 0L;
                n = 0;
                for (int i = 0; i < this.args.length; ++i) {
                    Expression expression2 = this.args[i];
                    if (expression2 == ValueExpression.getNull() || expression2.getType() == -1) continue;
                    n3 = Value.getHigherOrder(n3, expression2.getType());
                    n2 = Math.max(n2, expression2.getScale());
                    l = Math.max(l, expression2.getPrecision());
                    n = Math.max(n, expression2.getDisplaySize());
                }
                if (n3 != -1) break;
                n3 = 13;
                n2 = 0;
                l = Integer.MAX_VALUE;
                n = Integer.MAX_VALUE;
                break;
            }
            case 201: {
                n3 = Value.getHigherOrder(this.args[1].getType(), this.args[2].getType());
                l = Math.max(this.args[1].getPrecision(), this.args[2].getPrecision());
                n = Math.max(this.args[1].getDisplaySize(), this.args[2].getDisplaySize());
                n2 = Math.max(this.args[1].getScale(), this.args[2].getScale());
                break;
            }
            case 202: 
            case 203: {
                n3 = this.dataType;
                l = this.precision;
                n2 = this.scale;
                n = this.displaySize;
                break;
            }
            case 0: 
            case 13: 
            case 18: 
            case 19: 
            case 21: 
            case 27: {
                n3 = expression.getType();
                n2 = expression.getScale();
                l = expression.getPrecision();
                n = expression.getDisplaySize();
                if (n3 != 0) break;
                n3 = 4;
                l = 10L;
                n = 11;
                n2 = 0;
                break;
            }
            case 222: {
                Expression expression3 = this.args[1];
                n3 = expression3.getType();
                l = expression3.getPrecision();
                n2 = expression3.getScale();
                n = expression3.getDisplaySize();
                if (expression instanceof Variable) break;
                throw Message.getSQLException(90137, expression.getSQL());
            }
            case 225: {
                n3 = this.args.length == 1 ? 15 : 16;
                l = Integer.MAX_VALUE;
                n2 = 0;
                n = Integer.MAX_VALUE;
                break;
            }
            case 72: 
            case 73: {
                n3 = this.info.dataType;
                l = this.args[0].getPrecision();
                n2 = 0;
                if (this.args[1].isConstant()) {
                    l -= this.args[1].getValue(session).getLong() - 1L;
                }
                if (this.args.length == 3 && this.args[2].isConstant()) {
                    l = Math.min(l, this.args[2].getValue(session).getLong());
                }
                l = Math.max(0L, l);
                n = MathUtils.convertLongToInt(l);
                break;
            }
            default: {
                n3 = this.info.dataType;
                DataType dataType = DataType.getDataType(n3);
                l = -1L;
                n = 0;
                n2 = dataType.defaultScale;
            }
        }
        this.dataType = n3;
        this.precision = l;
        this.scale = n2;
        this.displaySize = n;
        if (bl) {
            return ValueExpression.get(this.getValue(session));
        }
        return this;
    }

    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        for (int i = 0; i < this.args.length; ++i) {
            Expression expression = this.args[i];
            if (expression == null) continue;
            expression.setEvaluatable(tableFilter, bl);
        }
    }

    public int getScale() {
        return this.scale;
    }

    public long getPrecision() {
        if (this.precision == -1L) {
            this.calculatePrecisionAndDisplaySize();
        }
        return this.precision;
    }

    public int getDisplaySize() {
        if (this.precision == -1L) {
            this.calculatePrecisionAndDisplaySize();
        }
        return this.displaySize;
    }

    private void calculatePrecisionAndDisplaySize() {
        switch (this.info.type) {
            case 30: 
            case 31: {
                this.precision = this.args[2].getPrecision();
                this.displaySize = this.args[2].getDisplaySize();
                break;
            }
            case 32: {
                this.precision = this.args[0].getPrecision();
                this.displaySize = this.args[0].getDisplaySize();
                break;
            }
            case 52: {
                this.precision = 1L;
                this.displaySize = 1;
                break;
            }
            case 54: {
                this.precision = 0L;
                this.displaySize = 0;
                for (int i = 0; i < this.args.length; ++i) {
                    this.precision += this.args[i].getPrecision();
                    this.displaySize = MathUtils.convertLongToInt((long)this.displaySize + (long)this.args[i].getDisplaySize());
                    if (this.precision >= 0L) continue;
                    this.precision = Long.MAX_VALUE;
                }
                break;
            }
            case 56: {
                this.precision = (this.args[0].getPrecision() + 3L) / 4L;
                this.displaySize = MathUtils.convertLongToInt(this.precision);
                break;
            }
            case 59: 
            case 63: 
            case 68: 
            case 69: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 80: 
            case 82: {
                this.precision = this.args[0].getPrecision();
                this.displaySize = this.args[0].getDisplaySize();
                break;
            }
            case 65: {
                this.precision = this.args[0].getPrecision() * 4L;
                this.displaySize = MathUtils.convertLongToInt(this.precision);
                break;
            }
            case 70: {
                this.precision = 4L;
                this.displaySize = (int)this.precision;
                break;
            }
            case 104: 
            case 111: {
                this.precision = 20L;
                this.displaySize = (int)this.precision;
                break;
            }
            default: {
                DataType dataType = DataType.getDataType(this.dataType);
                this.precision = dataType.defaultPrecision;
                this.displaySize = dataType.defaultDisplaySize;
            }
        }
    }

    public String getSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.info.name);
        stringBuffer.append('(');
        switch (this.info.type) {
            case 203: {
                stringBuffer.append(this.args[0].getSQL());
                stringBuffer.append(" AS ");
                stringBuffer.append(new Column(null, this.dataType, this.precision, this.scale, this.displaySize).getCreateSQL());
                break;
            }
            case 202: {
                stringBuffer.append(this.args[0].getSQL());
                stringBuffer.append(",");
                stringBuffer.append(new Column(null, this.dataType, this.precision, this.scale, this.displaySize).getCreateSQL());
                break;
            }
            case 120: {
                ValueString valueString = (ValueString)((ValueExpression)this.args[0]).getValue(null);
                stringBuffer.append(valueString.getString());
                stringBuffer.append(" FROM ");
                stringBuffer.append(this.args[1].getSQL());
                break;
            }
            default: {
                for (int i = 0; i < this.args.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(", ");
                    }
                    Expression expression = this.args[i];
                    stringBuffer.append(expression.getSQL());
                }
            }
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public void updateAggregate(Session session) throws SQLException {
        for (int i = 0; i < this.args.length; ++i) {
            Expression expression = this.args[i];
            if (expression == null) continue;
            expression.updateAggregate(session);
        }
    }

    public int getFunctionType() {
        return this.info.type;
    }

    public String getName() {
        return this.info.name;
    }

    public int getParameterCount() {
        return this.args.length;
    }

    public ValueResultSet getValueForColumnList(Session session, Expression[] expressionArray) throws SQLException {
        switch (this.info.type) {
            case 210: {
                String string = expressionArray[0].getValue(session).getString();
                if (string == null) {
                    throw Message.getSQLException(90012, "fileName");
                }
                String string2 = expressionArray.length < 2 ? null : expressionArray[1].getValue(session).getString();
                String string3 = expressionArray.length < 3 ? null : expressionArray[2].getValue(session).getString();
                String string4 = expressionArray.length < 4 ? null : expressionArray[3].getValue(session).getString();
                String string5 = expressionArray.length < 5 ? null : expressionArray[4].getValue(session).getString();
                String string6 = expressionArray.length < 6 ? null : expressionArray[5].getValue(session).getString();
                Csv csv = Csv.getInstance();
                this.setCsvDelimiterEscape(csv, string4, string5, string6);
                char c = csv.getFieldSeparatorRead();
                String[] stringArray = StringUtils.arraySplit(string2, c, true);
                ResultSet resultSet = csv.read(string, stringArray, string3);
                ValueResultSet valueResultSet = ValueResultSet.getCopy(resultSet, 0);
                return valueResultSet;
            }
        }
        return (ValueResultSet)this.getValueWithArgs(session, expressionArray);
    }

    private void setCsvDelimiterEscape(Csv csv, String string, String string2, String string3) {
        char c;
        if (string != null) {
            csv.setFieldSeparatorWrite(string);
            if (string.length() > 0) {
                c = string.charAt(0);
                csv.setFieldSeparatorRead(c);
            }
        }
        if (string2 != null) {
            c = string2.length() == 0 ? (char)'\u0000' : string2.charAt(0);
            csv.setFieldDelimiter(c);
        }
        if (string3 != null) {
            c = string3.length() == 0 ? (char)'\u0000' : string3.charAt(0);
            csv.setEscapeCharacter(c);
        }
    }

    public Expression[] getArgs() {
        return this.args;
    }

    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        if (expressionVisitor.getType() == 2 && !this.info.deterministic) {
            return false;
        }
        for (int i = 0; i < this.args.length; ++i) {
            Expression expression = this.args[i];
            if (expression == null || expression.isEverything(expressionVisitor)) continue;
            return false;
        }
        return true;
    }

    public int getCost() {
        int n = 3;
        for (int i = 0; i < this.args.length; ++i) {
            n += this.args[i].getCost();
        }
        return n;
    }

    public boolean isDeterministic() {
        return this.info.deterministic;
    }

    static {
        DATE_PART.put("YEAR", ObjectUtils.getInteger(1));
        DATE_PART.put("YYYY", ObjectUtils.getInteger(1));
        DATE_PART.put("YY", ObjectUtils.getInteger(1));
        DATE_PART.put("MONTH", ObjectUtils.getInteger(2));
        DATE_PART.put("MM", ObjectUtils.getInteger(2));
        DATE_PART.put("M", ObjectUtils.getInteger(2));
        DATE_PART.put("WW", ObjectUtils.getInteger(3));
        DATE_PART.put("WK", ObjectUtils.getInteger(3));
        DATE_PART.put("DAY", ObjectUtils.getInteger(5));
        DATE_PART.put("DD", ObjectUtils.getInteger(5));
        DATE_PART.put("D", ObjectUtils.getInteger(5));
        DATE_PART.put("DAYOFYEAR", ObjectUtils.getInteger(6));
        DATE_PART.put("DAY_OF_YEAR", ObjectUtils.getInteger(6));
        DATE_PART.put("DY", ObjectUtils.getInteger(6));
        DATE_PART.put("DOY", ObjectUtils.getInteger(6));
        DATE_PART.put("HOUR", ObjectUtils.getInteger(11));
        DATE_PART.put("HH", ObjectUtils.getInteger(11));
        DATE_PART.put("MINUTE", ObjectUtils.getInteger(12));
        DATE_PART.put("MI", ObjectUtils.getInteger(12));
        DATE_PART.put("N", ObjectUtils.getInteger(12));
        DATE_PART.put("SECOND", ObjectUtils.getInteger(13));
        DATE_PART.put("SS", ObjectUtils.getInteger(13));
        DATE_PART.put("S", ObjectUtils.getInteger(13));
        DATE_PART.put("MILLISECOND", ObjectUtils.getInteger(14));
        DATE_PART.put("MS", ObjectUtils.getInteger(14));
        String string = "7AEIOUY8HW1BFPV2CGJKQSXZ3DT4L5MN6R";
        char c = '\u0000';
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 < '9') {
                c = c2;
                continue;
            }
            Function.SOUNDEX_INDEX[c2] = c;
            Function.SOUNDEX_INDEX[Character.toLowerCase((char)c2)] = c;
        }
        Function.addFunction("ABS", 0, 1, 0);
        Function.addFunction("ACOS", 1, 1, 7);
        Function.addFunction("ASIN", 2, 1, 7);
        Function.addFunction("ATAN", 3, 1, 7);
        Function.addFunction("ATAN2", 4, 2, 7);
        Function.addFunction("BITAND", 5, 2, 5);
        Function.addFunction("BITOR", 6, 2, 5);
        Function.addFunction("BITXOR", 7, 2, 5);
        Function.addFunction("CEILING", 8, 1, 7);
        Function.addFunction("COS", 9, 1, 7);
        Function.addFunction("COT", 10, 1, 7);
        Function.addFunction("DEGREES", 11, 1, 7);
        Function.addFunction("EXP", 12, 1, 7);
        Function.addFunction("FLOOR", 13, 1, 7);
        Function.addFunction("LOG", 14, 1, 7);
        Function.addFunction("LOG10", 15, 1, 7);
        Function.addFunction("MOD", 16, 2, 5);
        Function.addFunction("PI", 17, 0, 7);
        Function.addFunction("POWER", 18, 2, 7);
        Function.addFunction("RADIANS", 19, 1, 7);
        Function.addFunctionNotDeterministic("RAND", 20, -1, 7);
        Function.addFunction("ROUND", 21, 2, 7);
        Function.addFunction("ROUNDMAGIC", 22, 1, 7);
        Function.addFunction("SIGN", 23, 1, 4);
        Function.addFunction("SIN", 24, 1, 7);
        Function.addFunction("SQRT", 25, 1, 7);
        Function.addFunction("TAN", 26, 1, 7);
        Function.addFunction("TRUNCATE", 27, 2, 7);
        Function.addFunction("HASH", 29, 3, 12);
        Function.addFunction("ENCRYPT", 30, 3, 12);
        Function.addFunction("DECRYPT", 31, 3, 12);
        Function.addFunctionNotDeterministic("SECURE_RAND", 28, 1, 12);
        Function.addFunction("COMPRESS", 32, -1, 12);
        Function.addFunction("EXPAND", 33, 1, 12);
        Function.addFunction("ZERO", 34, 0, 4);
        Function.addFunctionNotDeterministic("RANDOM_UUID", 35, 0, 20);
        Function.addFunctionNotDeterministic("SYS_GUID", 35, 0, 20);
        Function.addFunction("ASCII", 50, 1, 4);
        Function.addFunction("BIT_LENGTH", 51, 1, 4);
        Function.addFunction("CHAR", 52, 1, 13);
        Function.addFunction("CHR", 52, 1, 13);
        Function.addFunction("CHAR_LENGTH", 53, 1, 4);
        Function.addFunction("CHARACTER_LENGTH", 53, 1, 4);
        Function.addFunctionWithNull("CONCAT", 54, -1, 13);
        Function.addFunction("DIFFERENCE", 55, 2, 4);
        Function.addFunction("HEXTORAW", 56, 1, 13);
        Function.addFunctionWithNull("INSERT", 57, 4, 13);
        Function.addFunction("LCASE", 59, 1, 13);
        Function.addFunction("LEFT", 60, 2, 13);
        Function.addFunction("LENGTH", 61, 1, 4);
        Function.addFunction("LOCATE", 62, -1, 4);
        Function.addFunction("POSITION", 62, 2, 4);
        Function.addFunction("INSTR", 58, -1, 4);
        Function.addFunction("LTRIM", 63, -1, 13);
        Function.addFunction("OCTET_LENGTH", 64, 1, 4);
        Function.addFunction("RAWTOHEX", 65, 1, 13);
        Function.addFunction("REPEAT", 66, 2, 13);
        Function.addFunctionWithNull("REPLACE", 67, -1, 13);
        Function.addFunction("RIGHT", 68, 2, 13);
        Function.addFunction("RTRIM", 69, -1, 13);
        Function.addFunction("SOUNDEX", 70, 1, 13);
        Function.addFunction("SPACE", 71, 1, 13);
        Function.addFunction("SUBSTR", 72, -1, 13);
        Function.addFunction("SUBSTRING", 73, -1, 13);
        Function.addFunction("UCASE", 74, 1, 13);
        Function.addFunction("LOWER", 75, 1, 13);
        Function.addFunction("UPPER", 76, 1, 13);
        Function.addFunction("POSITION", 77, 2, 4);
        Function.addFunction("TRIM", 78, -1, 13);
        Function.addFunction("STRINGENCODE", 79, 1, 13);
        Function.addFunction("STRINGDECODE", 80, 1, 13);
        Function.addFunction("STRINGTOUTF8", 81, 1, 12);
        Function.addFunction("UTF8TOSTRING", 82, 1, 13);
        Function.addFunction("XMLATTR", 83, 2, 13);
        Function.addFunctionWithNull("XMLNODE", 84, -1, 13);
        Function.addFunction("XMLCOMMENT", 85, 1, 13);
        Function.addFunction("XMLCDATA", 86, 1, 13);
        Function.addFunction("XMLSTARTDOC", 87, 0, 13);
        Function.addFunction("XMLTEXT", 88, 1, 13);
        Function.addFunction("REGEXP_REPLACE", 89, 3, 13);
        Function.addFunction("RPAD", 90, -1, 13);
        Function.addFunction("LPAD", 91, -1, 13);
        Function.addFunctionNotDeterministic("CURRENT_DATE", 117, 0, 10);
        Function.addFunctionNotDeterministic("CURDATE", 100, 0, 10);
        Function.addFunctionNotDeterministic("CURRENT_TIME", 118, 0, 9);
        Function.addFunctionNotDeterministic("CURTIME", 101, 0, 9);
        Function.addFunctionNotDeterministic("CURRENT_TIMESTAMP", 119, -1, 11);
        Function.addFunctionNotDeterministic("NOW", 112, -1, 11);
        Function.addFunction("DATEADD", 102, 3, 11);
        Function.addFunction("DATEDIFF", 103, 3, 5);
        Function.addFunction("DAYNAME", 104, 1, 13);
        Function.addFunction("DAYNAME", 104, 1, 13);
        Function.addFunction("DAY", 105, 1, 4);
        Function.addFunction("DAY_OF_MONTH", 105, 1, 4);
        Function.addFunction("DAY_OF_WEEK", 106, 1, 4);
        Function.addFunction("DAY_OF_YEAR", 107, 1, 4);
        Function.addFunction("DAYOFMONTH", 105, 1, 4);
        Function.addFunction("DAYOFWEEK", 106, 1, 4);
        Function.addFunction("DAYOFYEAR", 107, 1, 4);
        Function.addFunction("HOUR", 108, 1, 4);
        Function.addFunction("MINUTE", 109, 1, 4);
        Function.addFunction("MONTH", 110, 1, 4);
        Function.addFunction("MONTHNAME", 111, 1, 13);
        Function.addFunction("QUARTER", 113, 1, 4);
        Function.addFunction("SECOND", 114, 1, 4);
        Function.addFunction("WEEK", 115, 1, 4);
        Function.addFunction("YEAR", 116, 1, 4);
        Function.addFunction("EXTRACT", 120, 2, 4);
        Function.addFunctionWithNull("FORMATDATETIME", 121, -1, 13);
        Function.addFunctionWithNull("PARSEDATETIME", 122, -1, 11);
        Function.addFunction("ISO_YEAR", 123, 1, 4);
        Function.addFunction("ISO_WEEK", 124, 1, 4);
        Function.addFunction("ISO_DAY_OF_WEEK", 125, 1, 4);
        Function.addFunctionNotDeterministic("DATABASE", 150, 0, 13);
        Function.addFunctionNotDeterministic("USER", 151, 0, 13);
        Function.addFunctionNotDeterministic("CURRENT_USER", 152, 0, 13);
        Function.addFunctionNotDeterministic("IDENTITY", 153, 0, 5);
        Function.addFunctionNotDeterministic("IDENTITY_VAL_LOCAL", 153, 0, 5);
        Function.addFunctionNotDeterministic("LAST_INSERT_ID", 153, 0, 5);
        Function.addFunctionNotDeterministic("AUTOCOMMIT", 154, 0, 1);
        Function.addFunctionNotDeterministic("READONLY", 155, 0, 1);
        Function.addFunction("DATABASE_PATH", 156, 0, 13);
        Function.addFunction("LOCK_TIMEOUT", 157, 0, 4);
        Function.addFunctionWithNull("IFNULL", 200, 2, 0);
        Function.addFunctionWithNull("CASEWHEN", 201, 3, 0);
        Function.addFunctionWithNull("CONVERT", 202, 1, 0);
        Function.addFunctionWithNull("CAST", 203, 1, 0);
        Function.addFunctionWithNull("COALESCE", 204, -1, 0);
        Function.addFunctionWithNull("NVL", 204, -1, 0);
        Function.addFunctionWithNull("NULLIF", 205, 2, 0);
        Function.addFunctionWithNull("CASE", 206, -1, 0);
        Function.addFunctionNotDeterministic("NEXTVAL", 207, -1, 5);
        Function.addFunctionNotDeterministic("CURRVAL", 208, -1, 5);
        Function.addFunction("ARRAY_GET", 209, 2, 13);
        Function.addFunction("CSVREAD", 210, -1, 18, false, false);
        Function.addFunction("CSVWRITE", 211, -1, 4, false, false);
        Function.addFunctionNotDeterministic("MEMORY_FREE", 212, 0, 4);
        Function.addFunctionNotDeterministic("MEMORY_USED", 213, 0, 4);
        Function.addFunctionNotDeterministic("LOCK_MODE", 214, 0, 4);
        Function.addFunctionNotDeterministic("SCHEMA", 215, 0, 13);
        Function.addFunctionNotDeterministic("SESSION_ID", 216, 0, 4);
        Function.addFunction("ARRAY_LENGTH", 217, 1, 4);
        Function.addFunction("LINK_SCHEMA", 218, 6, 18);
        Function.addFunctionWithNull("LEAST", 220, -1, 0);
        Function.addFunctionWithNull("GREATEST", 219, -1, 0);
        Function.addFunction("CANCEL_SESSION", 221, 1, 1);
        Function.addFunction("SET", 222, 2, 0, false, false);
        Function.addFunction("FILE_READ", 225, -1, 0, false, true);
        Function.addFunctionNotDeterministic("TRANSACTION_ID", 226, 0, 13);
        Function.addFunctionWithNull("TABLE", 223, -1, 18);
        Function.addFunctionWithNull("TABLE_DISTINCT", 224, -1, 18);
    }
}

