/*
 * Decompiled with CFR 0.152.
 */
package org.h2.schema;

import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.message.Message;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObjectBase;
import org.h2.table.Table;

public class Sequence
extends SchemaObjectBase {
    public static final int DEFAULT_CACHE_SIZE = 32;
    private long value = 1L;
    private long valueWithMargin;
    private long increment = 1L;
    private long cacheSize = 32L;
    private boolean belongsToTable;

    public Sequence(Schema schema, int n, String string, boolean bl) {
        this.initSchemaObjectBase(schema, n, string, "sequence");
        this.belongsToTable = bl;
    }

    public synchronized void setStartValue(long l) {
        this.value = l;
        this.valueWithMargin = l;
    }

    public boolean getBelongsToTable() {
        return this.belongsToTable;
    }

    public long getIncrement() {
        return this.increment;
    }

    public void setIncrement(long l) throws SQLException {
        if (l == 0L) {
            throw Message.getSQLException(90008, new String[]{"0", "INCREMENT"}, null);
        }
        this.increment = l;
    }

    public String getDropSQL() {
        if (this.getBelongsToTable()) {
            return null;
        }
        return "DROP SEQUENCE IF EXISTS " + this.getSQL();
    }

    public String getCreateSQLForCopy(Table table, String string) {
        throw Message.throwInternalError();
    }

    public synchronized String getCreateSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE SEQUENCE ");
        stringBuffer.append(this.getSQL());
        stringBuffer.append(" START WITH ");
        stringBuffer.append(this.value);
        if (this.increment != 1L) {
            stringBuffer.append(" INCREMENT BY ");
            stringBuffer.append(this.increment);
        }
        if (this.cacheSize != 32L) {
            stringBuffer.append(" CACHE ");
            stringBuffer.append(this.cacheSize);
        }
        if (this.belongsToTable) {
            stringBuffer.append(" BELONGS_TO_TABLE");
        }
        return stringBuffer.toString();
    }

    public synchronized long getNext(Session session) throws SQLException {
        if (this.increment > 0L && this.value >= this.valueWithMargin || this.increment < 0L && this.value <= this.valueWithMargin) {
            this.valueWithMargin += this.increment * this.cacheSize;
            this.flush(session);
        }
        long l = this.value;
        this.value += this.increment;
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void flush(Session session) throws SQLException {
        Session session2 = this.database.getSystemSession();
        if (session == null || !this.database.isSysTableLocked()) {
            session = session2;
        }
        Session session3 = session;
        synchronized (session3) {
            long l = this.value;
            try {
                this.value = this.valueWithMargin;
                this.database.update(session, this);
            }
            finally {
                this.value = l;
            }
            if (session == session2) {
                session2.commit(false);
            }
        }
    }

    public void close() throws SQLException {
        this.valueWithMargin = this.value;
        this.flush(null);
    }

    public int getType() {
        return 3;
    }

    public void removeChildrenAndResources(Session session) throws SQLException {
        this.database.removeMeta(session, this.getId());
        this.invalidate();
    }

    public void checkRename() {
    }

    public synchronized long getCurrentValue() {
        return this.value - this.increment;
    }

    public void setBelongsToTable(boolean bl) {
        this.belongsToTable = bl;
    }

    public void setCacheSize(long l) {
        this.cacheSize = l;
    }

    public long getCacheSize() {
        return this.cacheSize;
    }
}

