/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command;

import java.sql.SQLException;
import org.h2.command.Command;
import org.h2.command.Parser;
import org.h2.result.LocalResult;
import org.h2.util.ObjectArray;

public class CommandList
extends Command {
    private final Command command;
    private final String remaining;

    public CommandList(Parser parser, String string, Command command, String string2) {
        super(parser, string);
        this.command = command;
        this.remaining = string2;
    }

    public ObjectArray getParameters() {
        return this.command.getParameters();
    }

    private void executeRemaining() throws SQLException {
        Command command = this.session.prepareLocal(this.remaining);
        if (command.isQuery()) {
            command.query(0);
        } else {
            command.update();
        }
    }

    public int update() throws SQLException {
        int n = this.command.executeUpdate();
        this.executeRemaining();
        return n;
    }

    public LocalResult query(int n) throws SQLException {
        LocalResult localResult = this.command.query(n);
        this.executeRemaining();
        return localResult;
    }

    public boolean isQuery() {
        return this.command.isQuery();
    }

    public boolean isTransactional() {
        return true;
    }

    public boolean isReadOnly() {
        return false;
    }

    public LocalResult queryMeta() throws SQLException {
        return this.command.queryMeta();
    }
}

