/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.message.Message;
import org.h2.util.StringUtils;

public class IOUtils {
    private static final int BUFFER_BLOCK_SIZE = 4096;

    private IOUtils() {
    }

    public static void closeSilently(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                IOUtils.trace("closeSilently", null, outputStream);
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void skipFully(InputStream inputStream, long l) throws IOException {
        while (l > 0L) {
            long l2 = inputStream.skip(l);
            if (l2 <= 0L) {
                throw new EOFException();
            }
            l -= l2;
        }
    }

    public static void skipFully(Reader reader, long l) throws IOException {
        while (l > 0L) {
            long l2 = reader.skip(l);
            if (l2 <= 0L) {
                throw new EOFException();
            }
            l -= l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copyAndClose(InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            long l = IOUtils.copyAndCloseInput(inputStream, outputStream);
            outputStream.close();
            long l2 = l;
            return l2;
        }
        finally {
            IOUtils.closeSilently(outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copyAndCloseInput(InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            long l = IOUtils.copy(inputStream, outputStream);
            return l;
        }
        finally {
            IOUtils.closeSilently(inputStream);
        }
    }

    public static long copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        long l = 0L;
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copyAndCloseInput(Reader reader, Writer writer) throws IOException {
        long l = 0L;
        try {
            int n;
            char[] cArray = new char[4096];
            while ((n = reader.read(cArray)) >= 0) {
                writer.write(cArray, 0, n);
                l += (long)n;
            }
        }
        finally {
            reader.close();
        }
        return l;
    }

    public static void closeSilently(InputStream inputStream) {
        if (inputStream != null) {
            try {
                IOUtils.trace("closeSilently", null, inputStream);
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeSilently(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeSilently(Writer writer) {
        if (writer != null) {
            try {
                writer.flush();
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytesAndClose(InputStream inputStream, int n) throws IOException {
        try {
            if (n <= 0) {
                n = Integer.MAX_VALUE;
            }
            int n2 = Math.min(4096, n);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
            byte[] byArray = new byte[n2];
            while (n > 0) {
                int n3 = Math.min(n2, n);
                if ((n3 = inputStream.read(byArray, 0, n3)) < 0) break;
                byteArrayOutputStream.write(byArray, 0, n3);
                n -= n3;
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readStringAndClose(Reader reader, int n) throws IOException {
        try {
            if (n <= 0) {
                n = Integer.MAX_VALUE;
            }
            int n2 = Math.min(4096, n);
            StringWriter stringWriter = new StringWriter(n == Integer.MAX_VALUE ? n2 : n);
            char[] cArray = new char[n2];
            while (n > 0) {
                int n3 = Math.min(n2, n);
                if ((n3 = reader.read(cArray, 0, n3)) < 0) break;
                stringWriter.write(cArray, 0, n3);
                n -= n3;
            }
            String string = stringWriter.toString();
            return string;
        }
        finally {
            reader.close();
        }
    }

    public static int readFully(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = 0;
        for (int i = Math.min(n2, byArray.length); i > 0 && (n3 = inputStream.read(byArray, n, i)) >= 0; i -= n3) {
            n4 += n3;
            n += n3;
        }
        return n4;
    }

    public static int readFully(Reader reader, char[] cArray, int n) throws IOException {
        int n2;
        int n3 = 0;
        int n4 = Math.min(n, cArray.length);
        if (n4 == 0) {
            return 0;
        }
        while ((n2 = n4 - n3) > 0 && (n2 = reader.read(cArray, n3, n2)) >= 0) {
            n3 += n2;
        }
        return n3 <= 0 ? -1 : n3;
    }

    public static Reader getReader(InputStream inputStream) throws SQLException {
        try {
            return inputStream == null ? null : new BufferedReader(new InputStreamReader(inputStream, "UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw Message.convert(unsupportedEncodingException);
        }
    }

    public static Writer getWriter(OutputStream outputStream) throws SQLException {
        try {
            return outputStream == null ? null : new BufferedWriter(new OutputStreamWriter(outputStream, "UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw Message.convert(unsupportedEncodingException);
        }
    }

    public static InputStream getInputStream(String string) throws SQLException {
        if (string == null) {
            return null;
        }
        return new ByteArrayInputStream(StringUtils.utf8Encode(string));
    }

    public static Reader getReader(String string) {
        return string == null ? null : new StringReader(string);
    }

    public static Reader getAsciiReader(InputStream inputStream) throws SQLException {
        try {
            return inputStream == null ? null : new InputStreamReader(inputStream, "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw Message.convert(unsupportedEncodingException);
        }
    }

    private static void trace(String string, String string2, Object object) {
        if (SysProperties.TRACE_IO) {
            System.out.println("IOUtils." + string + " " + string2 + " " + object);
        }
    }
}

