/*
 * Decompiled with CFR 0.152.
 */
package org.h2.constraint;

import java.sql.SQLException;
import org.h2.command.Parser;
import org.h2.command.Prepared;
import org.h2.constraint.Constraint;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.Parameter;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.util.ObjectArray;
import org.h2.util.StringUtils;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class ConstraintReferential
extends Constraint {
    public static final int RESTRICT = 0;
    public static final int CASCADE = 1;
    public static final int SET_DEFAULT = 2;
    public static final int SET_NULL = 3;
    private IndexColumn[] columns;
    private IndexColumn[] refColumns;
    private int deleteAction;
    private int updateAction;
    private Table refTable;
    private Index index;
    private Index refIndex;
    private boolean indexOwner;
    private boolean refIndexOwner;
    private String deleteSQL;
    private String updateSQL;
    private boolean skipOwnTable;

    public ConstraintReferential(Schema schema, int n, String string, Table table) {
        super(schema, n, string, table);
    }

    public String getConstraintType() {
        return "REFERENTIAL";
    }

    private void appendAction(StringBuffer stringBuffer, int n) {
        switch (n) {
            case 1: {
                stringBuffer.append("CASCADE");
                break;
            }
            case 2: {
                stringBuffer.append("SET DEFAULT");
                break;
            }
            case 3: {
                stringBuffer.append("SET NULL");
                break;
            }
            default: {
                throw Message.getInternalError("action=" + n);
            }
        }
    }

    public String getCreateSQLForCopy(Table table, String string) {
        return this.getCreateSQLForCopy(table, this.refTable, string, true);
    }

    public String getCreateSQLForCopy(Table table, Table table2, String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ALTER TABLE ");
        String string2 = table.getSQL();
        stringBuffer.append(string2);
        stringBuffer.append(" ADD CONSTRAINT ");
        stringBuffer.append(string);
        if (this.comment != null) {
            stringBuffer.append(" COMMENT ");
            stringBuffer.append(StringUtils.quoteStringSQL(this.comment));
        }
        IndexColumn[] indexColumnArray = this.columns;
        IndexColumn[] indexColumnArray2 = this.refColumns;
        stringBuffer.append(" FOREIGN KEY(");
        for (int i = 0; i < indexColumnArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(indexColumnArray[i].getSQL());
        }
        stringBuffer.append(")");
        if (bl && this.indexOwner && table == this.table) {
            stringBuffer.append(" INDEX ");
            stringBuffer.append(this.index.getSQL());
        }
        stringBuffer.append(" REFERENCES ");
        String string3 = this.table == this.refTable ? table.getSQL() : table2.getSQL();
        stringBuffer.append(string3);
        stringBuffer.append("(");
        for (int i = 0; i < indexColumnArray2.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(indexColumnArray2[i].getSQL());
        }
        stringBuffer.append(")");
        if (bl && this.refIndexOwner && table == this.table) {
            stringBuffer.append(" INDEX ");
            stringBuffer.append(this.refIndex.getSQL());
        }
        if (this.deleteAction != 0) {
            stringBuffer.append(" ON DELETE ");
            this.appendAction(stringBuffer, this.deleteAction);
        }
        if (this.updateAction != 0) {
            stringBuffer.append(" ON UPDATE ");
            this.appendAction(stringBuffer, this.updateAction);
        }
        stringBuffer.append(" NOCHECK");
        return stringBuffer.toString();
    }

    public String getShortDescription() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getName());
        stringBuffer.append(": ");
        stringBuffer.append(this.table.getSQL());
        stringBuffer.append(" FOREIGN KEY(");
        for (n = 0; n < this.columns.length; ++n) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.columns[n].getSQL());
        }
        stringBuffer.append(")");
        stringBuffer.append(" REFERENCES ");
        stringBuffer.append(this.refTable.getSQL());
        stringBuffer.append("(");
        for (n = 0; n < this.refColumns.length; ++n) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.refColumns[n].getSQL());
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String getCreateSQLWithoutIndexes() {
        return this.getCreateSQLForCopy(this.table, this.refTable, this.getSQL(), false);
    }

    public String getCreateSQL() {
        return this.getCreateSQLForCopy(this.table, this.getSQL());
    }

    public void setColumns(IndexColumn[] indexColumnArray) {
        this.columns = indexColumnArray;
    }

    public IndexColumn[] getColumns() {
        return this.columns;
    }

    public void setRefColumns(IndexColumn[] indexColumnArray) {
        this.refColumns = indexColumnArray;
    }

    public IndexColumn[] getRefColumns() {
        return this.refColumns;
    }

    public void setRefTable(Table table) {
        this.refTable = table;
        if (table.getTemporary()) {
            this.setTemporary(true);
        }
    }

    public void setIndex(Index index, boolean bl) {
        this.index = index;
        this.indexOwner = bl;
    }

    public void setRefIndex(Index index, boolean bl) {
        this.refIndex = index;
        this.refIndexOwner = bl;
    }

    public void removeChildrenAndResources(Session session) throws SQLException {
        this.table.removeConstraint(this);
        this.refTable.removeConstraint(this);
        if (this.indexOwner) {
            this.table.removeIndexOrTransferOwnership(session, this.index);
        }
        if (this.refIndexOwner) {
            this.refTable.removeIndexOrTransferOwnership(session, this.refIndex);
        }
        this.database.removeMeta(session, this.getId());
        this.refTable = null;
        this.index = null;
        this.refIndex = null;
        this.columns = null;
        this.refColumns = null;
        this.deleteSQL = null;
        this.updateSQL = null;
        this.table = null;
        this.invalidate();
    }

    public void checkRow(Session session, Table table, Row row, Row row2) throws SQLException {
        if (!this.database.getReferentialIntegrity()) {
            return;
        }
        if (!this.table.getCheckForeignKeyConstraints() || !this.refTable.getCheckForeignKeyConstraints()) {
            return;
        }
        if (table == this.table && !this.skipOwnTable) {
            this.checkRowOwnTable(session, row2);
        }
        if (table == this.refTable) {
            this.checkRowRefTable(session, row, row2);
        }
    }

    private void checkRowOwnTable(Session session, Row row) throws SQLException {
        int n;
        Column column;
        Value value;
        int n2;
        int n3;
        if (row == null) {
            return;
        }
        boolean bl = false;
        for (n3 = 0; n3 < this.columns.length; ++n3) {
            n2 = this.columns[n3].column.getColumnId();
            Value value2 = row.getValue(n2);
            if (value2 != ValueNull.INSTANCE) continue;
            bl = true;
            break;
        }
        if (bl) {
            return;
        }
        if (this.refTable == this.table) {
            n3 = 1;
            for (n2 = 0; n2 < this.columns.length; ++n2) {
                int n4 = this.columns[n2].column.getColumnId();
                value = row.getValue(n4);
                column = this.refColumns[n2].column;
                n = column.getColumnId();
                Value value3 = row.getValue(n);
                if (this.database.areEqual(value3, value)) continue;
                n3 = 0;
                break;
            }
            if (n3 != 0) {
                return;
            }
        }
        Row row2 = this.refTable.getTemplateRow();
        for (n2 = 0; n2 < this.columns.length; ++n2) {
            int n5 = this.columns[n2].column.getColumnId();
            value = row.getValue(n5);
            column = this.refColumns[n2].column;
            n = column.getColumnId();
            row2.setValue(n, value.convertTo(column.getType()));
        }
        if (!this.found(session, this.refIndex, row2)) {
            throw Message.getSQLException(23002, this.getShortDescription());
        }
    }

    private boolean found(Session session, Index index, SearchRow searchRow) throws SQLException {
        index.getTable().lock(session, false, false);
        Cursor cursor = index.find(session, searchRow, searchRow);
        while (cursor.next()) {
            SearchRow searchRow2 = cursor.getSearchRow();
            Column[] columnArray = index.getColumns();
            boolean bl = true;
            for (int i = 0; i < this.columns.length && i < columnArray.length; ++i) {
                Value value;
                int n = columnArray[i].getColumnId();
                Value value2 = searchRow.getValue(n);
                if (this.database.compareTypeSave(value2, value = searchRow2.getValue(n)) == 0) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    private boolean isEqual(Row row, Row row2) throws SQLException {
        return this.refIndex.compareRows(row, row2) == 0;
    }

    private void checkRow(Session session, Row row) throws SQLException {
        Value value;
        int n;
        Object object;
        int n2;
        Column column;
        int n3;
        if (this.refTable == this.table) {
            boolean bl = true;
            for (n3 = 0; n3 < this.columns.length; ++n3) {
                column = this.refColumns[n3].column;
                n2 = column.getColumnId();
                object = row.getValue(n2);
                n = this.columns[n3].column.getColumnId();
                value = row.getValue(n);
                if (this.database.areEqual(value, (Value)object)) continue;
                bl = false;
                break;
            }
            if (bl) {
                return;
            }
        }
        SearchRow searchRow = this.table.getTemplateSimpleRow(false);
        for (n3 = 0; n3 < this.columns.length; ++n3) {
            column = this.refColumns[n3].column;
            n2 = column.getColumnId();
            object = this.columns[n3].column;
            n = ((Column)object).getColumnId();
            value = row.getValue(n2).convertTo(((Column)object).getType());
            searchRow.setValue(n, value);
        }
        if (this.found(session, this.index, searchRow)) {
            throw Message.getSQLException(23003, this.getShortDescription());
        }
    }

    private void checkRowRefTable(Session session, Row row, Row row2) throws SQLException {
        if (row == null) {
            return;
        }
        if (row2 != null && this.isEqual(row, row2)) {
            return;
        }
        if (row2 == null) {
            if (this.deleteAction == 0) {
                this.checkRow(session, row);
            } else {
                int n = this.deleteAction == 1 ? 0 : this.columns.length;
                Prepared prepared = this.getDelete(session);
                this.setWhere(prepared, n, row);
                this.updateWithSkipCheck(prepared);
            }
        } else if (this.updateAction == 0) {
            this.checkRow(session, row);
        } else {
            Prepared prepared = this.getUpdate(session);
            if (this.updateAction == 1) {
                ObjectArray objectArray = prepared.getParameters();
                for (int i = 0; i < this.columns.length; ++i) {
                    Parameter parameter = (Parameter)objectArray.get(i);
                    Column column = this.refColumns[i].column;
                    parameter.setValue(row2.getValue(column.getColumnId()));
                }
            }
            this.setWhere(prepared, this.columns.length, row);
            this.updateWithSkipCheck(prepared);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateWithSkipCheck(Prepared prepared) throws SQLException {
        try {
            this.skipOwnTable = true;
            prepared.update();
        }
        finally {
            this.skipOwnTable = false;
        }
    }

    private void setWhere(Prepared prepared, int n, Row row) {
        for (int i = 0; i < this.refColumns.length; ++i) {
            int n2 = this.refColumns[i].column.getColumnId();
            Value value = row.getValue(n2);
            ObjectArray objectArray = prepared.getParameters();
            Parameter parameter = (Parameter)objectArray.get(n + i);
            parameter.setValue(value);
        }
    }

    public int getDeleteAction() {
        return this.deleteAction;
    }

    public void setDeleteAction(int n) throws SQLException {
        if (n == this.deleteAction) {
            return;
        }
        if (this.deleteAction != 0) {
            throw Message.getSQLException(90045, "ON DELETE");
        }
        this.deleteAction = n;
        StringBuffer stringBuffer = new StringBuffer();
        if (n == 1) {
            stringBuffer.append("DELETE FROM ");
            stringBuffer.append(this.table.getSQL());
        } else {
            this.appendUpdate(stringBuffer);
        }
        this.appendWhere(stringBuffer);
        this.deleteSQL = stringBuffer.toString();
    }

    private Prepared getUpdate(Session session) throws SQLException {
        return this.prepare(session, this.updateSQL, this.updateAction);
    }

    private Prepared getDelete(Session session) throws SQLException {
        return this.prepare(session, this.deleteSQL, this.deleteAction);
    }

    public int getUpdateAction() {
        return this.updateAction;
    }

    public void setUpdateAction(int n) throws SQLException {
        if (n == this.updateAction) {
            return;
        }
        if (this.updateAction != 0) {
            throw Message.getSQLException(90045, "ON UPDATE");
        }
        this.updateAction = n;
        StringBuffer stringBuffer = new StringBuffer();
        this.appendUpdate(stringBuffer);
        this.appendWhere(stringBuffer);
        this.updateSQL = stringBuffer.toString();
    }

    private Prepared prepare(Session session, String string, int n) throws SQLException {
        Prepared prepared = session.prepare(string);
        if (n != 1) {
            ObjectArray objectArray = prepared.getParameters();
            for (int i = 0; i < this.columns.length; ++i) {
                Value value;
                Column column = this.columns[i].column;
                Parameter parameter = (Parameter)objectArray.get(i);
                if (n == 3) {
                    value = ValueNull.INSTANCE;
                } else {
                    Expression expression = column.getDefaultExpression();
                    if (expression == null) {
                        throw Message.getSQLException(90056, column.getName());
                    }
                    value = expression.getValue(session);
                }
                parameter.setValue(value);
            }
        }
        return prepared;
    }

    private void appendUpdate(StringBuffer stringBuffer) {
        stringBuffer.append("UPDATE ");
        stringBuffer.append(this.table.getSQL());
        stringBuffer.append(" SET ");
        for (int i = 0; i < this.columns.length; ++i) {
            if (i > 0) {
                stringBuffer.append(" , ");
            }
            Column column = this.columns[i].column;
            stringBuffer.append(Parser.quoteIdentifier(column.getName()));
            stringBuffer.append("=?");
        }
    }

    private void appendWhere(StringBuffer stringBuffer) {
        stringBuffer.append(" WHERE ");
        for (int i = 0; i < this.columns.length; ++i) {
            if (i > 0) {
                stringBuffer.append(" AND ");
            }
            Column column = this.columns[i].column;
            stringBuffer.append(Parser.quoteIdentifier(column.getName()));
            stringBuffer.append("=?");
        }
    }

    public Table getRefTable() {
        return this.refTable;
    }

    public boolean usesIndex(Index index) {
        return index == this.index || index == this.refIndex;
    }

    public void setIndexOwner(Index index) {
        if (this.index == index) {
            this.indexOwner = true;
        } else if (this.refIndex == index) {
            this.refIndexOwner = true;
        } else {
            throw Message.getInternalError();
        }
    }

    public boolean containsColumn(Column column) {
        int n;
        for (n = 0; n < this.columns.length; ++n) {
            if (this.columns[n].column != column) continue;
            return true;
        }
        for (n = 0; n < this.refColumns.length; ++n) {
            if (this.refColumns[n].column != column) continue;
            return true;
        }
        return false;
    }

    public boolean isBefore() {
        return false;
    }

    public void checkExistingData(Session session) throws SQLException {
        int n;
        if (session.getDatabase().isStarting()) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT 1 FROM (SELECT ");
        for (n = 0; n < this.columns.length; ++n) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.columns[n].getSQL());
        }
        stringBuffer.append(" FROM ");
        stringBuffer.append(this.table.getSQL());
        stringBuffer.append(" WHERE ");
        for (n = 0; n < this.columns.length; ++n) {
            if (n > 0) {
                stringBuffer.append(" AND ");
            }
            stringBuffer.append(this.columns[n].getSQL());
            stringBuffer.append(" IS NOT NULL ");
        }
        stringBuffer.append(" ORDER BY ");
        for (n = 0; n < this.columns.length; ++n) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.columns[n].getSQL());
        }
        stringBuffer.append(") C WHERE NOT EXISTS(SELECT 1 FROM ");
        stringBuffer.append(this.refTable.getSQL());
        stringBuffer.append(" P WHERE ");
        for (n = 0; n < this.columns.length; ++n) {
            if (n > 0) {
                stringBuffer.append(" AND ");
            }
            stringBuffer.append("C.");
            stringBuffer.append(this.columns[n].getSQL());
            stringBuffer.append("=");
            stringBuffer.append("P.");
            stringBuffer.append(this.refColumns[n].getSQL());
        }
        stringBuffer.append(")");
        String string = stringBuffer.toString();
        LocalResult localResult = session.prepare(string).query(1);
        if (localResult.next()) {
            throw Message.getSQLException(23002, this.getShortDescription());
        }
    }

    public Index getUniqueIndex() {
        return this.refIndex;
    }
}

