/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.sql.SQLException;
import org.h2.message.Message;

public class ByteUtils {
    private static final char[] HEX = "0123456789abcdef".toCharArray();

    private ByteUtils() {
    }

    public static int readInt(byte[] byArray, int n) {
        return (byArray[n++] << 24) + ((byArray[n++] & 0xFF) << 16) + ((byArray[n++] & 0xFF) << 8) + (byArray[n] & 0xFF);
    }

    public static long readLong(byte[] byArray, int n) {
        return ((long)ByteUtils.readInt(byArray, n) << 32) + ((long)ByteUtils.readInt(byArray, n + 4) & 0xFFFFFFFFL);
    }

    public static int indexOf(byte[] byArray, byte[] byArray2, int n) {
        if (byArray2.length == 0) {
            return n;
        }
        if (n > byArray.length) {
            return -1;
        }
        int n2 = byArray.length - byArray2.length + 1;
        while (n < n2) {
            block5: {
                for (int i = 0; i < byArray2.length; ++i) {
                    if (byArray[n + i] == byArray2[i]) {
                        continue;
                    }
                    break block5;
                }
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static byte[] convertStringToBytes(String string) throws SQLException {
        int n = string.length();
        if (n % 2 != 0) {
            throw Message.getSQLException(90003, string);
        }
        byte[] byArray = new byte[n /= 2];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)(ByteUtils.getHexDigit(string, i + i) << 4 | ByteUtils.getHexDigit(string, i + i + 1));
        }
        return byArray;
    }

    private static int getHexDigit(String string, int n) throws SQLException {
        char c = string.charAt(n);
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        throw Message.getSQLException(90004, string);
    }

    public static int getByteArrayHash(byte[] byArray) {
        int n = 1;
        int n2 = 0;
        while (n2 < byArray.length) {
            n = 31 * n + byArray[n2++];
        }
        return n;
    }

    public static String convertBytesToString(byte[] byArray) {
        return ByteUtils.convertBytesToString(byArray, byArray.length);
    }

    public static String convertBytesToString(byte[] byArray, int n) {
        char[] cArray = new char[n + n];
        char[] cArray2 = HEX;
        for (int i = 0; i < n; ++i) {
            int n2 = byArray[i] & 0xFF;
            cArray[i + i] = cArray2[n2 >> 4];
            cArray[i + i + 1] = cArray2[n2 & 0xF];
        }
        return new String(cArray);
    }

    public static boolean compareSecure(byte[] byArray, byte[] byArray2) {
        if (byArray == null || byArray2 == null) {
            return byArray == null && byArray2 == null;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        if (byArray.length == 0) {
            return true;
        }
        boolean bl = true;
        boolean bl2 = false;
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray[i] != byArray2[i]) {
                bl = false;
                continue;
            }
            bl2 = true;
        }
        return bl && bl2;
    }

    public static void clear(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 0;
        }
    }

    public static int compareNotNull(byte[] byArray, byte[] byArray2) {
        int n;
        int n2 = Math.min(byArray.length, byArray2.length);
        for (n = 0; n < n2; ++n) {
            byte by = byArray[n];
            byte by2 = byArray2[n];
            if (by == by2) continue;
            return by > by2 ? 1 : -1;
        }
        n = byArray.length - byArray2.length;
        return n == 0 ? 0 : (n < 0 ? -1 : 1);
    }

    public static String convertToBinString(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            cArray[i] = (char)(byArray[i] & 0xFF);
        }
        return new String(cArray);
    }

    public static byte[] convertBinStringToBytes(String string) {
        byte[] byArray = new byte[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            byArray[i] = (byte)(string.charAt(i) & 0xFF);
        }
        return byArray;
    }

    public static byte[] copy(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        if (n > byArray2.length) {
            byArray2 = new byte[n];
        }
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    public static byte[] cloneByteArray(byte[] byArray) {
        int n = byArray.length;
        if (n == 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }
}

