/*
 * Decompiled with CFR 0.152.
 */
package org.h2.message;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.h2.constant.SysProperties;
import org.h2.jdbc.JdbcSQLException;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.message.TraceWriter;
import org.h2.util.ClassUtils;
import org.h2.util.FileUtils;
import org.h2.util.SmallLRUCache;

public class TraceSystem
implements TraceWriter {
    public static final int OFF = 0;
    public static final int ERROR = 1;
    public static final int INFO = 2;
    public static final int DEBUG = 3;
    public static final int ADAPTER = 4;
    public static final int DEFAULT_TRACE_LEVEL_SYSTEM_OUT = 0;
    public static final int DEFAULT_TRACE_LEVEL_FILE = 1;
    private static final int DEFAULT_MAX_FILE_SIZE = 0x4000000;
    private static final int CHECK_FILE_TIME = 4000;
    private static final int CHECK_SIZE_EACH_WRITES = 128;
    private int levelSystemOut = 0;
    private int levelFile = 1;
    private int maxFileSize = 0x4000000;
    private String fileName;
    private long lastCheck;
    private SmallLRUCache traces;
    private SimpleDateFormat dateFormat;
    private Writer fileWriter;
    private PrintWriter printWriter;
    private int checkSize;
    private boolean closed;
    private boolean manualEnabling = true;
    private boolean writingErrorLogged;
    private TraceWriter writer = this;

    public TraceSystem(String string, boolean bl) {
        this.fileName = string;
        this.traces = new SmallLRUCache(100);
        this.dateFormat = new SimpleDateFormat("MM-dd HH:mm:ss ");
        if (string != null && bl) {
            try {
                this.openWriter();
            }
            catch (Exception exception) {
                this.logWritingError(exception);
            }
        }
    }

    public static void traceThrowable(Throwable throwable) {
        PrintWriter printWriter = DriverManager.getLogWriter();
        if (printWriter != null) {
            throwable.printStackTrace(printWriter);
        }
    }

    public void setManualEnabling(boolean bl) {
        this.manualEnabling = bl;
    }

    public synchronized Trace getTrace(String string) {
        Trace trace = (Trace)this.traces.get(string);
        if (trace == null) {
            trace = new Trace(this.writer, string);
            this.traces.put(string, trace);
        }
        return trace;
    }

    public boolean isEnabled(int n) {
        int n2 = Math.max(this.levelSystemOut, this.levelFile);
        return n <= n2;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setMaxFileSize(int n) {
        this.maxFileSize = n;
    }

    public void setLevelSystemOut(int n) {
        this.levelSystemOut = n;
    }

    public void setLevelFile(int n) {
        if (n == 4) {
            String string = "org.h2.message.TraceWriterAdapter";
            try {
                this.writer = (TraceWriter)ClassUtils.loadSystemClass(string).newInstance();
            }
            catch (Throwable throwable) {
                JdbcSQLException jdbcSQLException = Message.getSQLException(90086, new String[]{string}, throwable);
                this.write(1, "database", string, jdbcSQLException);
                return;
            }
            String string2 = this.fileName;
            if (string2 != null) {
                int n2;
                if (string2.endsWith(".trace.db")) {
                    string2 = string2.substring(0, string2.length() - ".trace.db".length());
                }
                if ((n2 = Math.max(string2.lastIndexOf(47), string2.lastIndexOf(92))) >= 0) {
                    string2 = string2.substring(n2 + 1);
                }
                this.writer.setName(string2);
            }
        }
        this.levelFile = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String format(String string, String string2) {
        SimpleDateFormat simpleDateFormat = this.dateFormat;
        synchronized (simpleDateFormat) {
            return this.dateFormat.format(new Date()) + string + ": " + string2;
        }
    }

    public void write(int n, String string, String string2, Throwable throwable) {
        if (n <= this.levelSystemOut) {
            System.out.println(this.format(string, string2));
            if (throwable != null && this.levelSystemOut == 3) {
                throwable.printStackTrace();
            }
        }
        if (this.fileName != null) {
            if (n > this.levelFile) {
                this.enableIfRequired();
            }
            if (n <= this.levelFile) {
                this.writeFile(this.format(string, string2), throwable);
            }
        }
    }

    private void enableIfRequired() {
        if (!this.manualEnabling) {
            return;
        }
        long l = System.currentTimeMillis();
        if (l > this.lastCheck + 4000L) {
            String string = this.fileName + ".start";
            this.lastCheck = l;
            if (FileUtils.exists(string)) {
                this.levelFile = 3;
                try {
                    FileUtils.delete(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private synchronized void writeFile(String string, Throwable throwable) {
        try {
            if (this.checkSize++ >= 128) {
                this.checkSize = 0;
                this.closeWriter();
                if (this.maxFileSize > 0 && FileUtils.length(this.fileName) > (long)this.maxFileSize) {
                    String string2 = this.fileName + ".old";
                    if (FileUtils.exists(string2)) {
                        FileUtils.delete(string2);
                    }
                    FileUtils.rename(this.fileName, string2);
                }
            }
            if (!this.openWriter()) {
                return;
            }
            this.printWriter.println(string);
            if (throwable != null) {
                throwable.printStackTrace(this.printWriter);
            }
            this.printWriter.flush();
            if (this.closed) {
                this.closeWriter();
            }
        }
        catch (Exception exception) {
            this.logWritingError(exception);
        }
    }

    private void logWritingError(Exception exception) {
        if (this.writingErrorLogged) {
            return;
        }
        this.writingErrorLogged = true;
        JdbcSQLException jdbcSQLException = Message.getSQLException(90034, new String[]{this.fileName, exception.toString()}, exception);
        this.fileName = null;
        System.out.println(jdbcSQLException);
        ((Throwable)jdbcSQLException).printStackTrace();
    }

    private boolean openWriter() {
        if (this.printWriter == null) {
            try {
                FileUtils.createDirs(this.fileName);
                if (FileUtils.exists(this.fileName) && FileUtils.isReadOnly(this.fileName)) {
                    return false;
                }
                this.fileWriter = FileUtils.openFileWriter(this.fileName, true);
                this.printWriter = new PrintWriter(this.fileWriter, true);
            }
            catch (Exception exception) {
                this.logWritingError(exception);
                return false;
            }
        }
        return true;
    }

    private synchronized void closeWriter() {
        if (this.printWriter != null) {
            this.printWriter.flush();
            this.printWriter.close();
            this.printWriter = null;
        }
        if (this.fileWriter != null) {
            try {
                this.fileWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.fileWriter = null;
        }
        try {
            if (this.fileName != null && FileUtils.length(this.fileName) == 0L) {
                FileUtils.delete(this.fileName);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void close() {
        this.closeWriter();
        this.closed = true;
    }

    protected void finalize() {
        if (!SysProperties.runFinalize) {
            return;
        }
        this.close();
    }

    public void setName(String string) {
    }
}

