/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.BtreeCursor;
import org.h2.index.BtreeHead;
import org.h2.index.BtreeLeaf;
import org.h2.index.BtreeNode;
import org.h2.index.BtreePage;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.store.DataPage;
import org.h2.store.Record;
import org.h2.store.RecordReader;
import org.h2.store.Storage;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableData;
import org.h2.util.ObjectArray;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class BtreeIndex
extends BaseIndex
implements RecordReader {
    private Storage storage;
    private BtreePage rootPage;
    private TableData tableData;
    private BtreeHead head;
    private boolean needRebuild;
    private int headPos;
    private long lastChange;

    public BtreeIndex(Session session, TableData tableData, int n, String string, IndexColumn[] indexColumnArray, IndexType indexType, int n2) throws SQLException {
        this.initBaseIndex(tableData, n, string, indexColumnArray, indexType);
        this.tableData = tableData;
        Database database = tableData.getDatabase();
        this.storage = database.getStorage(this, n, false);
        this.headPos = n2;
        if (n2 == -1 || this.database.getRecovery()) {
            this.truncate(session);
            this.needRebuild = true;
        } else {
            Record record = this.storage.getRecordIfStored(session, n2);
            if (record != null && record instanceof BtreeHead) {
                this.head = (BtreeHead)record;
            }
            if (this.head != null && this.head.getConsistent()) {
                this.needRebuild = false;
                this.rowCount = tableData.getRowCount(session);
            } else {
                this.truncate(session);
                this.needRebuild = true;
            }
        }
    }

    private BtreePage getRoot(Session session) throws SQLException {
        if (this.rootPage == null) {
            this.setRoot((BtreePage)this.storage.getRecord(session, this.head.getRootPosition()));
        }
        return this.rootPage;
    }

    private BtreePage setRoot(BtreePage btreePage) {
        if (this.rootPage != null) {
            this.rootPage.setRoot(false);
        }
        btreePage.setRoot(true);
        this.rootPage = btreePage;
        return this.rootPage;
    }

    public int getHeadPos() {
        return this.headPos;
    }

    public void remove(Session session) throws SQLException {
        this.storage.delete(session);
        this.storage = null;
    }

    private void setChanged(Session session) throws SQLException {
        if (this.head != null && !this.database.getLogIndexChanges()) {
            this.database.invalidateIndexSummary();
            if (this.head.getConsistent()) {
                this.deletePage(session, this.head);
                this.head.setConsistent(false);
                this.flushHead(session);
            }
            this.lastChange = System.currentTimeMillis();
        }
    }

    void updatePage(Session session, Record record) throws SQLException {
        if (this.database.getLogIndexChanges()) {
            this.storage.addRecord(session, record, record.getPos());
        } else {
            this.storage.updateRecord(session, record);
        }
    }

    void deletePage(Session session, Record record) throws SQLException {
        if (this.database.getLogIndexChanges()) {
            this.storage.removeRecord(session, record.getPos());
        }
    }

    void addPage(Session session, Record record) throws SQLException {
        this.storage.addRecord(session, record, -1);
    }

    public BtreePage getPage(Session session, int n) throws SQLException {
        return (BtreePage)this.storage.getRecord(session, n);
    }

    public void flush(Session session) throws SQLException {
        this.lastChange = 0L;
        if (this.storage != null) {
            this.storage.flushFile();
            if (!this.database.getReadOnly()) {
                this.deletePage(session, this.head);
                if (this.database.getLogIndexChanges() || !this.database.getLog().containsInDoubtTransactions()) {
                    this.head.setConsistent(true);
                }
                this.flushHead(session);
            }
        }
    }

    public void close(Session session) throws SQLException {
        this.flush(session);
        this.storage = null;
    }

    public void add(Session session, Row row) throws SQLException {
        Object object;
        this.setChanged(session);
        Row row2 = this.table.getTemplateRow();
        row2.setPosAndVersion(row);
        for (int i = 0; i < this.columns.length; ++i) {
            Column column = this.columns[i];
            int n = column.getColumnId();
            object = row.getValue(n);
            row2.setValue(n, (Value)object);
        }
        BtreePage btreePage = this.getRoot(session);
        int n = btreePage.add(row2, session);
        if (n != 0) {
            SearchRow searchRow = btreePage.getData(n);
            object = btreePage;
            BtreePage btreePage2 = btreePage.split(session, n);
            btreePage = this.setRoot(new BtreeNode(this, (BtreePage)object, searchRow, btreePage2));
            this.addPage(session, btreePage);
            this.deletePage(session, this.head);
            this.head.setRootPosition(btreePage.getPos());
            this.flushHead(session);
        }
        ++this.rowCount;
    }

    SearchRow getSearchRow(Row row) {
        SearchRow searchRow = this.table.getTemplateSimpleRow(this.columns.length == 1);
        searchRow.setPosAndVersion(row);
        for (int i = 0; i < this.columns.length; ++i) {
            int n = this.columns[i].getColumnId();
            searchRow.setValue(n, row.getValue(n));
        }
        return searchRow;
    }

    public void remove(Session session, Row row) throws SQLException {
        this.setChanged(session);
        if (this.rowCount == 1L) {
            this.truncate(session);
        } else {
            BtreePage btreePage = this.getRoot(session);
            btreePage.remove(session, row);
            --this.rowCount;
        }
    }

    public boolean canFindNext() {
        return true;
    }

    public Cursor findNext(Session session, SearchRow searchRow, SearchRow searchRow2) throws SQLException {
        return this.find(session, searchRow, true, searchRow2);
    }

    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) throws SQLException {
        return this.find(session, searchRow, false, searchRow2);
    }

    private Cursor find(Session session, SearchRow searchRow, boolean bl, SearchRow searchRow2) throws SQLException {
        if (SysProperties.CHECK && this.storage == null) {
            throw Message.getSQLException(90007);
        }
        BtreePage btreePage = this.getRoot(session);
        if (searchRow == null) {
            BtreeCursor btreeCursor = new BtreeCursor(session, this, searchRow2);
            btreePage.first(btreeCursor);
            return btreeCursor;
        }
        BtreeCursor btreeCursor = new BtreeCursor(session, this, searchRow2);
        if (this.getRowCount(session) == 0L || !btreePage.findFirst(btreeCursor, searchRow, bl)) {
            btreeCursor.setCurrentRow(null);
        }
        return btreeCursor;
    }

    public int getLookupCost(int n) {
        int n2 = 0;
        int n3 = 1;
        while ((n3 *= 8) <= n) {
            ++n2;
        }
        return n2 + 1;
    }

    public double getCost(Session session, int[] nArray) throws SQLException {
        return 10L * this.getCostRangeIndex(nArray, this.tableData.getRowCount(session));
    }

    public Record read(Session session, DataPage dataPage) throws SQLException {
        char c = (char)dataPage.readByte();
        if (c == 'N') {
            return new BtreeNode(this, dataPage);
        }
        if (c == 'L') {
            return new BtreeLeaf(this, session, dataPage);
        }
        if (c == 'H') {
            return new BtreeHead(dataPage);
        }
        throw Message.getSQLException(90030, this.getName());
    }

    ObjectArray readRowArray(DataPage dataPage) throws SQLException {
        int n = dataPage.readInt();
        ObjectArray objectArray = new ObjectArray(n);
        for (int i = 0; i < n; ++i) {
            SearchRow searchRow;
            int n2 = dataPage.readInt();
            if (n2 < 0) {
                searchRow = null;
            } else {
                searchRow = this.table.getTemplateSimpleRow(this.columns.length == 1);
                searchRow.setPos(n2);
                for (int j = 0; j < this.columns.length; ++j) {
                    int n3 = this.columns[j].getColumnId();
                    searchRow.setValue(n3, dataPage.readValue());
                }
            }
            objectArray.add(searchRow);
        }
        return objectArray;
    }

    public Row getRow(Session session, int n) throws SQLException {
        return this.tableData.getRow(session, n);
    }

    private void flushHead(Session session) throws SQLException {
        this.updatePage(session, this.head);
        if (!this.database.getLogIndexChanges() && !this.database.getReadOnly()) {
            this.storage.flushRecord(this.head);
        }
        this.trace.debug("Index " + this.getSQL() + " head consistent=" + this.head.getConsistent());
    }

    public void truncate(Session session) throws SQLException {
        this.setChanged(session);
        this.storage.truncate(session);
        this.head = new BtreeHead();
        this.addPage(session, this.head);
        BtreePage btreePage = this.setRoot(new BtreeLeaf(this, new ObjectArray()));
        this.addPage(session, btreePage);
        this.deletePage(session, this.head);
        this.head.setRootPosition(btreePage.getPos());
        this.head.setConsistent(this.database.getLogIndexChanges());
        this.lastChange = System.currentTimeMillis();
        this.flushHead(session);
        this.headPos = this.head.getPos();
        this.rowCount = 0L;
    }

    public void checkRename() throws SQLException {
    }

    public boolean needRebuild() {
        return this.needRebuild;
    }

    public int getRecordOverhead() {
        return this.storage.getRecordOverhead();
    }

    public long getLastChange() {
        return this.lastChange;
    }

    public boolean canGetFirstOrLast() {
        return true;
    }

    public Cursor findFirstOrLast(Session session, boolean bl) throws SQLException {
        SearchRow searchRow;
        if (bl) {
            Cursor cursor = this.find(session, null, false, null);
            while (cursor.next()) {
                SearchRow searchRow2 = cursor.getSearchRow();
                Value value = searchRow2.getValue(this.columnIds[0]);
                if (value == ValueNull.INSTANCE) continue;
                return cursor;
            }
            return cursor;
        }
        BtreePage btreePage = this.getRoot(session);
        BtreeCursor btreeCursor = new BtreeCursor(session, this, null);
        btreePage.last(btreeCursor);
        while ((searchRow = btreeCursor.getSearchRow()) != null) {
            Value value = searchRow.getValue(this.columnIds[0]);
            if (value != ValueNull.INSTANCE) {
                return btreeCursor;
            }
            if (btreeCursor.previous()) continue;
        }
        return btreeCursor;
    }
}

