/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.index.BtreeCursor;
import org.h2.index.BtreeIndex;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.store.DataPage;
import org.h2.store.Record;
import org.h2.table.Column;
import org.h2.util.ObjectArray;
import org.h2.value.Value;

public abstract class BtreePage
extends Record {
    protected static final int BLOCKS_PER_PAGE = 8;
    protected BtreeIndex index;
    protected ObjectArray pageData;
    protected boolean root;

    abstract int add(Row var1, Session var2) throws SQLException;

    abstract SearchRow remove(Session var1, Row var2) throws SQLException;

    abstract BtreePage split(Session var1, int var2) throws SQLException;

    abstract boolean findFirst(BtreeCursor var1, SearchRow var2, boolean var3) throws SQLException;

    abstract SearchRow getFirst(Session var1) throws SQLException;

    abstract void next(BtreeCursor var1, int var2) throws SQLException;

    abstract void previous(BtreeCursor var1, int var2) throws SQLException;

    abstract void first(BtreeCursor var1) throws SQLException;

    abstract void last(BtreeCursor var1) throws SQLException;

    abstract int getRealByteCount() throws SQLException;

    BtreePage(BtreeIndex btreeIndex) {
        this.index = btreeIndex;
    }

    SearchRow getData(int n) throws SQLException {
        return (SearchRow)this.pageData.get(n);
    }

    public int getByteCount(DataPage dataPage) throws SQLException {
        return 1024;
    }

    int getSplitPoint() throws SQLException {
        if (this.pageData.size() == 1) {
            return 0;
        }
        int n = this.getRealByteCount();
        if (n >= 1024) {
            return this.pageData.size() / 2;
        }
        return 0;
    }

    public boolean isEmpty() {
        return false;
    }

    int getRowSize(DataPage dataPage, SearchRow searchRow) throws SQLException {
        int n = dataPage.getIntLen();
        Column[] columnArray = this.index.getColumns();
        for (int i = 0; i < columnArray.length; ++i) {
            Value value = searchRow.getValue(columnArray[i].getColumnId());
            n += dataPage.getValueLen(value);
        }
        return n;
    }

    void setRoot(boolean bl) {
        this.root = bl;
    }

    public boolean isPinned() {
        return this.root;
    }
}

